<?php

class DefaultController extends BaseController {

    public $milestoneData;

    public function filters() {
        return isset($_GET['bypass']) ? array() : parent::filters();
    }

    private function _calculatePlanningSteps($userID = 0){
        if($userID){
            Yii::import('application.modules.student.components.CustomCareerPlan');
            $careerPlan = new CustomCareerPlan($userID);
            $this->milestoneData = $careerPlan->getPlanningSteps();
        }
    }

    private function _getUserID(){

        $studentID = false;
        $uid = Yii::app()->request->getParam('uid', 0);
        $userType = CommonUtils::getRbacUserRole(Yii::app()->user->id);
        if($userType == 'Student'){
            $studentID = Yii::app()->user->sub_id;
        }elseif($userType == 'SI'){
             $studentID = TblSiStudents::model()->exists(sprintf('user_ref_id="%d" AND inst_ref_id="%d"', $uid, Yii::app()->user->sub_id)) ? $uid : false;
        }else{
            $studentID = $uid;
        }
        if(!$studentID){ throw new CHttpException(404,'The specified post cannot be found.');  }
        return $studentID;
    }

    public function actionIndex(){

        $uid = isset($_GET['bypass']) ? $_GET['uid'] : $this->_getUserID();

        $this->pageTitle = Yii::app()->name .' - Milestone Progress';
        $this->_calculatePlanningSteps($uid);
        $userModel = TblUserMaster::model()->findByPk($uid);
        $curMonth = date('m'); $curYear = date('Y'); $passoutYear = $userModel->passout_year;
        if(
            ($curMonth < 7 && in_array($passoutYear, [$curYear, $curYear+1])) ||
            ($curMonth > 6 && in_array($passoutYear, [$curYear+1, $curYear+2])) ||
            ($userModel->present_class > '10')

        ){

            if(isset($_GET['bypass'])){
                $this->layout ="//layouts/milestone_snapshot";
                $this->render('index', compact('userModel', 'uid'));
            }else{
                $this->render('index', compact('userModel', 'uid'));
            }
        }

    }

    public function actionCountryPreferences(){
        $uid = Yii::app()->request->getParam('uid', 0);
        $this->_calculatePlanningSteps($uid);
        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('country_preferences', compact('uid'), false, true);
    }

    public function actionMajorPreferences(){

        $uid = Yii::app()->request->getParam('uid', 0);
        $this->_calculatePlanningSteps($uid);
        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('major_preferences', compact('uid'), false, true);
    }

    public function actionTestPreferences(){
        $uid = Yii::app()->request->getParam('uid', 0);
        $this->_calculatePlanningSteps($uid);
        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('test_preferences', compact('uid'), false, true);
    }

    public function actionUpdateImportantDates(){
        $uid = Yii::app()->request->getParam('uid', 0);
        $testID = Yii::app()->request->getParam('testid', false);
        $deadLines = EntranceExamDateSection::getEntranceExamDateSectionByYear($testID, date('Y'), date('Y')+1);
        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('view_test_deadlines',compact('uid', 'testID', 'deadLines'), false, true);
    }

    public function actionUpdateDeadLines(){

        $chosenidsStr = Yii::app()->request->getParam('chosenids', false);
        $chosenids = $chosenidsStr ? explode(',', $chosenidsStr) : array();
        $userID = Yii::app()->request->getParam('uid', 0);
        $testID = Yii::app()->request->getParam('testID', false);

        if(count($chosenids)){
            $Sql = "DELETE FROM milestone_test_deadlines_chosen WHERE entrance_exam_ref_id='".$testID."' AND user_ref_id = '".$userID."'";
            Yii::app()->db->createCommand($Sql)->execute();
            $this->_userDataUpdated($userID);

            foreach($chosenids as $chosenid){
                $model = new MilestoneTestDeadlinesChosen;
                $model->setAttributes(array(
                    'user_ref_id'=> $userID,
                    'entrance_exam_ref_id'=> $testID,
                    'entrance_exam_date_label_ref_id' => $chosenid,
                    'added_on' => date('Y-m-d H:i:s')
                ), false);
                $model->save(false);
            }
            $this->_userDataUpdated($userID);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($userID,'MilestoneTestDeadlinesChosen');
        }
    }

    public function actionInstitutePreferences(){

        $uid = Yii::app()->request->getParam('uid', 0);
        $Sql = "UPDATE tbl_user_master SET need_coaching='Y' WHERE user_id= '".$uid."'";
        Yii::app()->db->createCommand($Sql)->execute();

        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('institute_preferences', compact('uid'), false, true);
    }

    public function actionFindInstitutes(){

        $formModel = new InstituteFormModel;

        if(isset($_POST['ajax'])){
            echo CActiveForm::validate($formModel);
            Yii::app()->end();
        }

        if (isset($_POST['fetch'])) {
            $uid = Yii::app()->request->getParam('uid', 0);
            $formModel->attributes = $_POST['InstituteFormModel'];
            $formData = array(
                'lat'=> $_POST['latitude'] ?: 0 ,
                'lng'=> $_POST['longitude'] ?: 0,
                'test_id'=>$formModel->test_id);
            $results = $formModel->getCoachingCenters($formData, $uid);
            $this->renderPartial('show_coaching_centers',compact('results'));
            Yii::app()->end();
        }

        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('find_coaching_centers',compact('formModel'), false, true);
    }

    public function actionCollegePreferences(){

        $uid = Yii::app()->request->getParam('uid', 0);
        $this->_calculatePlanningSteps($uid);
        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('college_preferences', compact('uid'), false, true);
    }

    public function actionAdmissionPreferences(){
        $uid = Yii::app()->request->getParam('uid', 0);
        $this->_calculatePlanningSteps($uid);

        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('admission_preferences', compact('uid'), false, true);
    }

    public function actionNotes(){
        $uid = Yii::app()->request->getParam('uid', 0);

        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('counsellor_notes', compact('uid'), false, true);
    }

    public function actionAddNotes() {

        $uid = Yii::app()->request->getParam('uid', 0);
        $model = new UserDataPoint('counsellor');
        $attributes_to_validate = array('comments', 'interaction_ref_id');

        if (Yii::app()->request->getParam('ajax')){
            echo CActiveForm::validate($model, $attributes_to_validate);
            Yii::app()->end();
        }

        if (Yii::app()->request->isPostRequest) {
            $model->attributes = Yii::app()->request->getParam('UserDataPoint');
            $model->setAttributes([
                'user_ref_id' => $uid,
                'added_by' => Yii::app()->user->id,
                'added_on' => date('Y-m-d H:i:s')
            ], false);
            $model->save(false);
            $this->_userDataUpdated($uid);
        }
    }

    public function actionDeleteNotes() {
        $loginId = Yii::app()->user->id;
        $userId = Yii::app()->request->getParam('uid');
        $notesId = Yii::app()->request->getParam('nId');
        if($userId && $notesId && $loginId) {
            UserDataPoint::model()->deleteByPk($notesId);
            $this->_userDataUpdated($userId);
            OfflineDeleteRecordLog::deleteRecordUpdateTime($userId,'UserDataPoint');
        }
    }

    public function actionShareDiscussion(){

        Yii::app()->clientScript->scriptMap['*.js'] = false;
		$uid = Yii::app()->request->getParam('uid', 0);

        $model = new ShareDiscussion();
        if(Yii::app()->request->getParam('ajax')){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (Yii::app()->request->isPostRequest){
            $model->attributes = Yii::app()->request->getParam('ShareDiscussion');
            $student = TblUserMaster::model()->findByPk($uid);

            // push to Umail table as well
            $this->_sendUmailToStudent($student, $model->message);
            // push to interaction as well
            $this->_addInteraction($student, $model);

            $attributes = array('user_ref_id' => $uid, 'added_by' => Yii::app()->user->id, 'comments' => $model->message, 'added_on' => date('Y-m-d H:i:s'), 'interaction_ref_id' => $model->interaction_ref_id);
            $noteID = UserDataPoint::addUserDataPoint($attributes);
            $explodeEmails = explode(',', trim($model->email));
            array_push($explodeEmails, 'guideme@univariety.com');
            foreach($explodeEmails as $email){
                $this->_send_mail(trim($email), $model, $student, $noteID);
            }
            $this->_userDataUpdated($uid);
            Yii::app()->end();
        }
        $this->renderPartial('_share_discussion', compact('model', 'uid'), false, true);
    }

    private function _send_mail($email, $model, $student, $noteID) {

        $emailq = new EmailMessage;
        $displayName = ucwords($student->first_name .' '.$student->last_name );
        $isPreview = false;
        $email_body = $this->renderPartial('_preview_share_discussion', compact('model','isPreview', 'noteID','email'), TRUE);

        $message = array();
        $message['subject'] = $displayName.' : Digital Dossier';
        $message['body'] = $email_body;
        $message['type'] = 'Signup';
        $message['toName'] = 'Univariety';
        $message['toEmail'] = $email;
        $message['apiKey'] = Yii::app()->params['emailCron']['curlKey'];

        if(Yii::app()->params['OfflineSystem']){
            $message['pdfUserId'] = $student->user_id;
            $mailInfo  = serialize($message);
            $model = new MilestoneOfflineShare;
            $model->setAttributes([
                'data' => $mailInfo,
                'user_id' => $student->user_id,
                'added_on' => date('Y-m-d H:i:s')
            ], false);
            $model->save(false);
        }else{
            $attachments = array();
            list($fileName, $fileFullPath) = ShareDiscussion::UserMilestonePDF($student->user_id);
            $attachments[] = array('name' => 'MilestoneProgress.pdf', 'path' => $fileFullPath);
            $message['attachments']  = $attachments;
            $emailq->addEmailMessage($message);
        }
    }

    public function morphLink($link = '', $userLoginID = 0){
        // autologin morphed links for internal advisers
        if(!Yii::app()->user->isGuest){
            $loginID = Yii::app()->user->id;
            if(CommonUtils::getRbacUserRole($loginID) == 'Advisor'){
                $redirectUrl = base64_encode($userLoginID.'==='.$link);
                return Yii::app()->baseUrl.'/login/loginRedirect?ref='.$redirectUrl;
            }
        }
        return $link;
    }

    public function actionPreviewShareDiscussion(){

        $model = new ShareDiscussion;
        if(isset($_POST['ShareDiscussion'])){
            $model->attributes = $_POST['ShareDiscussion'];
        }
        $isPreview = true;
        $this->renderPartial('_preview_share_discussion', compact('model', 'isPreview'));
    }

    public function actionFeedback(){

        $hash = Yii::app()->request->getParam('hash');
        list($noteID, $email, $likeStatus) = explode('|', base64_decode($hash));
        $postDone = false;
        $model = FeedbackDiscussion::model()->find(sprintf("note_ref_id='%s'", $noteID));
        $model = $model ?: new FeedbackDiscussion;
        $model->setAttributes(['note_ref_id' => $noteID, 'like_status'=> $likeStatus, 'email'=>$email], false);
        if(!$likeStatus){
            if(Yii::app()->request->isAjaxRequest){
                $model->validatorList->add(
                    CValidator::createValidator('required', $model, 'feedback', ['message' => '<div class="holder"><p>Feedback is required</p></div>'])
                );
                echo CActiveForm::validate($model);
                Yii::app()->end();
            }
            if(Yii::app()->request->isPostRequest){
                $model->feedback = $_POST['FeedbackDiscussion']['feedback'];
                $model->save(false);
                $postDone = true;
            }
        }else{
            $model->feedback = new CDbExpression('NULL');
            $model->save(false);
        }
        $this->render('_feedback', compact('model', 'noteID', 'likeStatus', 'email', 'postDone'));
    }

    public function actionUpdateInterestingProduct(){

        $assignedStatus = Yii::app()->request->getParam('status', 0);
        $productID = Yii::app()->request->getParam('id');
        $uid = Yii::app()->request->getParam('uid', 0);

        $model = StudentInterestedProducts::model()->find('student_ref_id= :userid AND interesting_product_ref_id = :productid', [':userid'=>$uid, ':productid'=>$productID]);
        if(!$assignedStatus && $model){
            $model->delete();
        }
        if($assignedStatus && !$model){

            $model = new StudentInterestedProducts;
            $model->setAttributes([
                'student_ref_id' => $uid,
                'interesting_product_ref_id'=>$productID,
                'entered_by' => Yii::app()->user->sub_id
            ], false);
            $model->save(false);
            $this->_userDataUpdated($uid);
        }
    }

    public function actionLevel2Counselling(){

        $uid = Yii::app()->request->getParam('uid', 0);
        $model = StudentCounsellingRequest::model()->find('student_ref_id= :userid', [':userid'=>$uid]);
        if(!$model) {
            $model = new StudentCounsellingRequest;
            $model->setAttributes([
                'student_ref_id' => $uid,
                'entered_by' => Yii::app()->user->sub_id,
                'entered_on' => date('Y-m-d H:i:s')
            ], false);

        }
        if(Yii::app()->request->getParam('ajax')){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (Yii::app()->request->isPostRequest){
            $model->attributes = $_POST['StudentCounsellingRequest'];
            $model->schedule_date = DateTime::createFromFormat('d/m/Y', $model->schedule_date)->format('Y-m-d');
            $model->schedule_time = DateTime::createFromFormat('H:i', $model->schedule_time)->format('H:i:s');
            $model->entered_on = date('Y-m-d H:i:s');
            $model->save(false);
            $this->_userDataUpdated($uid);
            $dateString = sprintf('Date: %s | Time: %s',
                DateTime::createFromFormat('Y-m-d', $model->schedule_date)->format('d.m.Y'),
                DateTime::createFromFormat('H:i:s', $model->schedule_time)->format('g:i a')
            );
            echo json_encode(['date_string'=> $dateString]);
            Yii::app()->end();
        }

        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $this->renderPartial('_level2_counselling_form', compact('model', 'uid'), false, true);
    }

    public function actionRemoveL2counselling(){

        $uid = Yii::app()->request->getParam('uid', 0);
        $model = StudentCounsellingRequest::model()->find('student_ref_id= :userid', [':userid'=>$uid]);
        $model && $model->delete();
        $this->_userDataUpdated($uid);
        OfflineDeleteRecordLog::deleteRecordUpdateTime($uid, 'StudentCounsellingRequest');

    }

    public function actionSubjectHelp(){

        $uid = Yii::app()->request->getParam('uid', 0);
        $model = new StudentSubjectHelpForm;
        if(Yii::app()->request->getParam('ajax')){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
        if (Yii::app()->request->isPostRequest){
            $model->attributes = $_POST['StudentSubjectHelpForm'];
            $model->saveSubjects($uid);
            $this->_userDataUpdated($uid);
            $subjectsHelp = StudentSubjectHelp::model()->with('subjectRef')->findAll('student_ref_id= :userid', [':userid'=>$uid]);
            $subjectsAr=[];
            if($subjectsHelp){
                foreach($subjectsHelp as $subject)
                    $subjectsAr[] = $subject->subjectRef->subject_name;
            }
            echo json_encode(['data_string'=> implode(', ', $subjectsAr)]);
            Yii::app()->end();
        }

        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $userObj = TblUserMaster::model()->findByPk($uid);
        $lookUpBoard = LookupBoardEquivalent::model()->find("class_level = '$userObj->present_class' AND board_ref_id = :board_id", [':board_id'=>$userObj->present_board_ref_id]);
        $subjectsList = LookupStudentSubject::model()->findAll("board_ref_id = :board_ref_id", [':board_ref_id'=>$lookUpBoard->board_equivalent_id]);
        $subjectsHelp = StudentSubjectHelp::model()->with('subjectRef')->findAll('student_ref_id= :userid', [':userid'=>$uid]);
        $this->renderPartial('_subject_help_form', compact('model', 'subjectsList', 'subjectsHelp', 'uid'), false, true);
    }

    public function actionRemoveSubjects(){

        $uid = Yii::app()->request->getParam('uid', 0);
        StudentSubjectHelp::model()->deleteAll('student_ref_id= :userid', [':userid'=>$uid]);
        $this->_userDataUpdated($uid);
        OfflineDeleteRecordLog::deleteRecordUpdateTime($uid, 'StudentSubjectHelp');
    }

    public function actionShowProductComments(){

        $uid = Yii::app()->request->getParam('uid', 0);
        $model = new StudentProductComment;
        $model->setAttributes([
            'student_ref_id' => $uid,
            'entered_by' => Yii::app()->user->sub_id,
            'entered_on' => date('Y-m-d H:i:s')
        ], false);

        if(Yii::app()->request->getParam('ajax')){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (Yii::app()->request->isPostRequest){
            $model->attributes = $_POST['StudentProductComment'];
            $model->save(false);
            $this->_userDataUpdated($uid);
            Yii::app()->end();
        }

        Yii::app()->clientScript->scriptMap['*.js'] = false;
        $productComments = StudentProductComment::model()->with('enteredBy')->findAll(['condition'=>'student_ref_id= :userid', 'order'=>'t.entered_on DESC', 'params'=>[':userid'=>$uid]]);
        OfflineF2fCounsellor::localChange($uid);
        $this->renderPartial('_show_product_comments', compact('model', 'productComments', 'uid'), false, true);
    }

    public function _sendUmailToStudent($student, $message){

        if(!in_array(Yii::app()->user->RbacUserRole, ['SI', 'Advisor']))
            return false;

        $senderType = Yii::app()->user->RbacUserRole == 'SI' ? 4 : 2;
        $UmailHeader = new UmailHeader;
        $UmailHeader->setAttributes([
            'sender_type'           => $senderType,
            'sender_id'             => Yii::app()->user->sub_id,
            'recipient_type'        => 1,
            'recipient_id'          => $student->user_id,
            'querytype_id'          => 5,
            'added_on'              => date('Y-m-d H:i:s'),
            'last_replied_on'       => date('Y-m-d H:i:s'),
            'original_advisor_id'   => Yii::app()->user->sub_id,
            'current_advisor_id'    => Yii::app()->user->sub_id,
            'status'                => 'NEW',
        ], FALSE);
        $transaction = Yii::app()->db->beginTransaction();
        try {
            if(!$UmailHeader->save(FALSE)) throw new CDbException('umail header save failed');

            $UmailMessage = new UmailMessage;
            $UmailMessage->setAttributes([
                'header_ref_id'         => $UmailHeader->header_id,
                'sender_type'           => $UmailHeader->sender_type,
                'sender_id'             => $UmailHeader->sender_id,
                'recipient_type'        => $UmailHeader->recipient_type,
                'recipient_id'          => $UmailHeader->recipient_id,
                'added_on'              => $UmailHeader->added_on,
                'message'               => $message,
                'subject'               => 'Observation Notes',
            ], FALSE);

            if(!$UmailMessage->save(FALSE)){
                throw new CDbException('umail message saving failed');
            }
            $transaction->commit();
        } catch (Exception $exc) {
            $transaction->rollback();
            return false;
        }
    }

    public function _addInteraction($student, $model){

        $interactionModel = new TblInteractionDetails;
        $interactionModel->setAttributes([
            'user_ref_id' => $student->user_id,
            'interaction_ref_id' => $model->interaction_ref_id,
            'conversation_text' => $model->message,
            'added_on' => date('Y-m-d H:i:s'),
            'logged_by' => Yii::app()->user->FullName,
        ], false);

        $interactionModel->save(false);
        $this->_userDataUpdated($student->user_id);
    }

    public function actionUserNotes(){

        $userID = Yii::app()->request->getParam('uid', 0);
        Yii::import('application.modules.css.components.InteractionFormModel');
        $dataProvider = InteractionFormModel::StudentsInteractions($userID);
        $this->render("_interactions", array(
            'dataProvider' => $dataProvider,
            'uid' => $userID,
        ));
    }

    public function actionUserNotesByAdmin(){

        $userID = Yii::app()->request->getParam('uid', 0);
        $adminID = Yii::app()->request->getParam('adminid', 0);
        Yii::import('application.modules.css.components.InteractionFormModel');
        $interactions = InteractionFormModel::getNotesForUserByAdmin($userID, $adminID);
        $this->renderPartial('_user_notes_by_admin', compact('interactions'));
    }

    public function actionSendUmail() {

        $uid = Yii::app()->request->getParam('uid', 0);

        $model = new CUmailForm('compose');
        if (Yii::app()->request->getParam('ajax')) {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (Yii::app()->request->isPostRequest) {
            $model->attributes = $_POST['CUmailForm'];
            $User = TblUserMaster::model()->findByPk($uid);
            $isSent = $model->compose_and_send($User);
            echo json_encode(['success' => $isSent]);
        }
        OfflineF2fCounsellor::localChange($uid);
    }

    private function _userDataUpdated($uid){
        OfflineF2fCounsellor::localChange($uid);
        //TblUserMaster::updateUserActivityFlag($uid);
    }

    public function actionTrackTime(){

        $section = Yii::app()->request->getParam('section', 0);
        $studentID = Yii::app()->request->getParam('uid', 0);
        $adminRoleID = Yii::app()->session->get('admin_role_type_id', 0);
        $CurDateTime = date('Y-m-d H:i:s');
        $CurSessionID = session_id();

        $aMilestoneSectionIDs = [
            'countrySection'=>1, 'majorSection'=>2, 'testSection'=>3,
            'instituteSection'=>4, 'collegeSection'=>5, 'admissionSection'=>7, 'sessionComplete'=>7
        ];

        if($section && isset($aMilestoneSectionIDs[$section]) && $adminRoleID == '19'){
            $this->_userDataUpdated($studentID);
            $trackingData = [
                'session_id' => $CurSessionID,
                'student_ref_id' => $studentID,
                'milestone_ref_id' => $aMilestoneSectionIDs[$section],
                'counsellor_ref_id' => Yii::app()->user->sub_id,
            ];

            if(!MilestoneCounsellingTimetrack::model()->findByAttributes($trackingData)){
                $m = new MilestoneCounsellingTimetrack;
                $m->setAttributes($trackingData + ['start_time' => $CurDateTime ], false);
                $m->save(false);
            }

            switch($section){
                case 'majorSection':
                    // update country section endtime
                    $trackingData['milestone_ref_id'] = $aMilestoneSectionIDs['countrySection'];
                    if(($m = MilestoneCounsellingTimetrack::model()->findByAttributes($trackingData)) != null){
                        $m->setAttributes(['end_time' => $CurDateTime], false);
                        $m->save(false);
                    }
                    break;
                case 'testSection':
                    // update major section endtime
                    $trackingData['milestone_ref_id'] = $aMilestoneSectionIDs['majorSection'];
                    if(($m = MilestoneCounsellingTimetrack::model()->findByAttributes($trackingData)) != null){
                        $m->setAttributes(['end_time' => $CurDateTime], false);
                        $m->save(false);
                    }
                    break;
                case 'instituteSection':
                    // update test section endtime
                    $trackingData['milestone_ref_id'] = $aMilestoneSectionIDs['testSection'];
                    if(($m = MilestoneCounsellingTimetrack::model()->findByAttributes($trackingData)) != null){
                        $m->setAttributes(['end_time' => $CurDateTime], false);
                        $m->save(false);
                    }
                    break;
                case 'collegeSection':
                    // update institute section endtime
                    $trackingData['milestone_ref_id'] = $aMilestoneSectionIDs['instituteSection'];
                    if(($m = MilestoneCounsellingTimetrack::model()->findByAttributes($trackingData)) != null){
                        $m->setAttributes(['end_time' => $CurDateTime], false);
                        $m->save(false);
                    }
                    break;
                case 'admissionSection':
                    // update college section endtime
                    $trackingData['milestone_ref_id'] = $aMilestoneSectionIDs['collegeSection'];
                    if(($m = MilestoneCounsellingTimetrack::model()->findByAttributes($trackingData)) != null){
                        $m->setAttributes(['end_time' => $CurDateTime], false);
                        $m->save(false);
                    }
                    break;
                case 'sessionComplete':
                    // update admission section endtime
                    $trackingData['milestone_ref_id'] = $aMilestoneSectionIDs['admissionSection'];
                    if(($m = MilestoneCounsellingTimetrack::model()->findByAttributes($trackingData)) != null){
                        $m->setAttributes(['end_time' => $CurDateTime], false);
                        $m->save(false);
                    }
                    break;
            }
        }
    }
}