<?php
class ShareDiscussion extends CFormModel {

    public $message;
    public $email;
    public $interaction_ref_id;

    public function rules() {

        return array(
            array('message, email','required'),
            array('interaction_ref_id','required', 'message'=>'Mode of interaction cannot be blank.'),
            array('email','checkCommaSeparateEmail'),
            array('message, email, interaction_ref_id', 'safe'),
        );
    }

    public function _ce($error){
        return '<div class="holder"><p>'.$error.'</p></div>';
    }

    public function addError($attribute,$error) {
        parent::addError($attribute, $this->_ce($error));
    }

    public function checkCommaSeparateEmail() {
        $explodeString = explode(',', $this->email);
        foreach($explodeString as $email){
            if(!filter_var(trim($email), FILTER_VALIDATE_EMAIL)){
                $this->addError('email', "Email appears to be invalid");
                break;
            }
        }
    }

    static public function UserMilestonePDF($ID){

        // The URL to get your HTML
        $url = Yii::app()->getBaseUrl(true)."/milestoneprogress/default/index?bypass=1&uid=".$ID;

        // Name of your output image
        $fileName = "milestone_".$ID.".pdf";

        // Command to execute
        $command = "wkhtmltopdf --orientation Landscape --load-error-handling ignore";

        // Directory for the image to be saved
        $image_dir = $_SERVER['DOCUMENT_ROOT'] . '/uploads/milestone_brochure/'; //"/var/www/images/";

        if(file_exists($image_dir.$fileName)){
            if(filemtime($image_dir.$fileName) + 300 > time()){
                return array($fileName, "milestone_brochure/$fileName");
            }else{
                @unlink($image_dir.$fileName);
            }
        }

        $ex = "$command '$url' " . $image_dir . $fileName;
        exec($ex);
        return array($fileName, "milestone_brochure/$fileName");
    }
}

?>