<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMilestoneOfflineShare is autogenerate by UniModel generator
 *
 * This is the model class for table "milestone_offline_share".
 *
 * The followings are the available columns in table 'milestone_offline_share':
 * @property string $id
 * @property string $data
 * @property integer $user_id
 * @property string $added_on
 * @property string $synced_on
 */
class BaseMilestoneOfflineShare extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MilestoneOfflineShare the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'milestone_offline_share';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('data, user_id, added_on', 'required'),
			array('user_id', 'numerical', 'integerOnly'=>true),
			array('synced_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, data, user_id, added_on, synced_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'data' => 'Data',
			'user_id' => 'User',
			'added_on' => 'Added On',
			'synced_on' => 'Synced On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('data',$this->data,true);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('synced_on',$this->synced_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}