<?php
$userID = $uid;
$milestoneData = UserMilestoneTracking::model()->find(
    sprintf("user_ref_id = %d AND milestone_ref_id=1", $userID));
$countryPrefs  = StudentPreferredCountry::model()->with('countryRef')->findAll(array(
    'condition'=>sprintf("user_ref_id = %d AND not_sure != 1", $userID),
    'order'=>'t.preference_order ASC'
));

?>
<div>
    <style>
        li.token-input-token-facebook p, div.token-input-dropdown-facebook{
            font-size: 12px !important;
        }
        ul.token-input-list-facebook > li {
            padding: 2px 4px !important;
            line-height: 14px !important;
            font-size: 12px !important;
        }
        ul.token-input-list-facebook{
            width:auto;
        }
    </style>

    <div class="row multi_line small-gutter white gutter_vertical">
        <div class="clearfix">
            <div class="gutter_vertical left grid_6 small-right">
                <h4 class="left grid_3 small-right"><span class="link-button button-green small_gutter_r">1</span> Country Preferences</h4>
                <?php if($milestoneData && $milestoneData->completion_date){ ?>
                    <span class="color-green"><strong>
                            Completed ( <?php echo (new DateTime($milestoneData->completion_date))->format('jS M Y'); ?> )
                        </strong></span>
                <?php }else{ ?>
                    <span class="color-gray"><strong>
                            Pending ( <?php echo $milestoneData->deadline_date ?
                                (new DateTime($milestoneData->deadline_date))->format('jS M Y') : 'N/A'; ?> )
                        </strong></span>
                <?php } ?>

            </div>

        </div>
        <div class="gutter-left-35">
            <?php if($countryPrefs){
                $i=1;
                foreach($countryPrefs as $countryPref) { ?>
                    <?php echo $i; ?>.
                    <span class="small_gutter_r">
                        <?php
                        echo $countryPref->countryRef->country_name;
                        $locations = StudentPreferredLocation::studentPreferredLoc($userID, $countryPref->preferred_country_id);
                        if($locations){
                            $preflocations = array();
                            foreach($locations as $location){
                                $preflocations[] = $location->region_name ?: $location->name ?: $location->city_name;
                            }
                            ?> <span class="color-gray">( <?php echo implode(', ', $preflocations); ?> )</span> <?php
                        }
                        ?>
                    </span>
                    <?php if($i < count($countryPrefs)){ ?>
                        <span class="small_gutter_r">|</span>
                    <?php } ?>
                    <?php $i++;
                }
            }
            ?>
        </div>
        <?php if(!isset($_GET['bypass'])){ ?>
            <div class="clearfix gutter-verticle-auto grid_9 countryEditDiv">
            <?php
            $formModel = new CareerPlanFormModel;
            $form = $this->beginWidget('CActiveForm', array(
                'id'=>'countryForm',
                'action'=> Yii::app()->createUrl('student/careerplan/updatecountrypreferences?uid='.$userID),
                'enableClientValidation' => false,
                'enableAjaxValidation'=>true,
                'clientOptions' =>array(
                    'validateOnSubmit'=>true,
                    'beforeValidate'  => 'js:function(form){
                        return true;
                    }',
                    'afterValidate' => 'js:function(form, data, hasError){
                        if(!$.isEmptyObject(data)){
                            for(var i in data) {
                               var id = i, message = data[i][0];
                               $("#"+i+"_em_").html(message).show();
                            }
                            $("html, body").animate({ scrollTop: $("div.errorMessage:visible").first().offset().top - 250 }, 1000);
                            return false;
                        }else{
                            $(".submitBtn", form).attr("disabled", "disabled").text("...please wait");
                            $.post($(form).attr("action"), $(form).serialize() , function(r){
                                $.notification({class: r.msg_cls, notification:r.msg_notification, replaceKeys: r.replaceKeys, time:4E3});
                                if(r.msg_cls != "error_notify"){
                                    milestoneProgress.updateSection("countrysection", function(){
                                        goHash("majorSection");
                                    });
                                }
                            }, "json")
                        }
                    }',
                )
            ));
            echo $form->hiddenField($formModel,'hidden_temp');
            echo $form->error($formModel,'hidden_temp');

            $i = 1; $locationOptions = array();
            while($i <= 3){
                $index = uniqid();
                $chosenCountry = array_shift($countryPrefs);
                if($chosenCountry->country_ref_id) {
                    $locations = StudentPreferredLocation::studentPreferredLoc($userID, $chosenCountry->preferred_country_id);
                    $subOptions = array();
                    foreach($locations as $val) {
                        if($val->city_name)
                            $subOptions[] = array('id'=>'c'.$val->city_ref_id, 'name'=>$val->city_name); // c for city
                        if($val->name)
                            $subOptions[] = array('id'=>'s'.$val->state_ref_id, 'name'=>$val->name);     // s for state
                        if($val->region_name)
                            $subOptions[] = array('id'=>'r'.$val->region_ref_id, 'name'=>$val->region_name);  // r for region
                    }
                    $locationOptions[$chosenCountry->country_ref_id] = $subOptions;
                }
                ?>
                <div class="mainSection gutter_vertical clearfix">
                    <div class="grid_2 pull small_gutter_t">Preferred Country <?php echo $i; ?></div>
                    <div class="grid_3 left small-right relative">
                        <?php
                        echo $form->dropDownList(
                            $formModel,'country_of_interest['.$index.'][country_id]', $formModel->getCountriesList(),
                            array(
                                'empty' => 'Choose Country', 'class' => 'full-width countryInterest',
                                'options' => array( $chosenCountry->country_ref_id =>array('selected'=>true))
                            )
                        );
                        echo $form->error($formModel,'country_of_interest['.$index.'][country_id]',  array('class'=>'errorMessage popup'));
                        ?>
                    </div>
                    <div class="grid_4 pull relative">
                        <?php
                        echo $form->textField($formModel,'country_of_interest['.$index.'][location]', array('class' => 'full-width pref_location') );
                        echo $form->error($formModel, 'country_of_interest['.$index.'][location]', array('class'=>'popup errorMessage'));
                        ?>
                    </div>
                </div>
            <?php $i++; } ?>

            <div class="clearfix center">
                <button type="submit" class="submitBtn button-blue tny small_gutter_r">Save</button>
                <button type="button" onclick="goHash('majorSection', this.form)" class="button-default tny small_gutter_r">Skip</button>
            </div>
            <?php $this->endWidget(); ?>
        </div>
        <?php } ?>
    </div>
</div>
<?php if(!isset($_GET['bypass'])) { ?>
<script>
    $(function(){
        var CountryLocationOptions = <?php echo json_encode($locationOptions); ?>;
        window.initTokenInput = function(){
            $(".token-input-list-facebook").remove();
            $(".pref_location").each(function(){
                var $self = $(this), prefCountry = $self.closest('.mainSection').find('.countryInterest');
                $(this).tokenInput(
                    function(){ return ibase_url + 'myProfile/getPrefLocations?cid='+ prefCountry.val(); },
                    {   theme: "facebook",
                        placeholder: 'Enter city/state/zone',
                        preventDuplicates: true,
                        hintText: 'Type to search',
                        tokenLimit: 4,
                        prePopulate:CountryLocationOptions[prefCountry.val()]
                    }
                );
            });
        }
    })
</script>
<?php } ?>