<?php
class ProfileData extends CFormModel {

    public $user_id;

    public $country_pref = array();
    public $country_not_sure;
    public $dept_pref = array();
    public $dept_not_sure;
    public $sub_dept_pref = array();
    public $dept_others = array();
    public $is_location_entered;

    public $school_name_12;
    public $board_12;
    public $year_12;
    public $overall_marks_12;
    public $overall_marks_gpa_12;
    public $overall_points_12;
    public $overall_grade_12 = array();

    public $school_name_10;
    public $board_10;
    public $year_10;
    public $overall_marks_10;
    public $overall_marks_gpa_10;
    public $overall_points_10;
    public $overall_grade_10 = array();
    public $country_code;
    public $phone;
    public $address2;
    public $city;
    public $city_id;

    public function rules() {

        return array(
            array('user_id', 'required'),
            array('user_id', 'validateProfile', 'on' => 'profile'),
            array('user_id', 'ValidateCountryPhone', 'on' => 'contact'),
            array('user_id, country_pref, dept_pref, sub_dept_pref,
            country_not_sure, dept_not_sure, dept_others, pref_location, is_location_entered
            school_name_12, board_12, year_12, overall_marks_12, overall_marks_gpa_12, overall_points_12, overall_grade_12
            school_name_10, board_10, year_10, overall_marks_10, overall_marks_gpa_10, overall_points_10, overall_grade_10
            country_code, phone, city_id, city ', 'safe')
        );
    }

    public function attributeLabels() {

        return array(
            'phone' => 'Phone Number'
        );
    }

    public function validateProfile() {
        /** Country validation start here **/
        if ($this->country_not_sure) {
        } else {
            if (!$this->is_location_entered) {
                $this->addError('is_location_entered', 'Please select');
            }
            if (!$this->country_pref[0]['countryids'] && !$this->country_pref[1]['countryids']) {
                $this->addError("country_pref[0][countryids]", 'Select country');
            } else {
                $selected = array();
                foreach ($this->country_pref as $key=>$value) {
                    if ($value['countryids']) {
                        if (in_array($value['countryids'], $selected)) {
                            $this->addError('country_pref['.$key.'][countryids]', 'Select different country');
                        }
                        $user = TblUserMaster::model()->findByPk($this->user_id);
                        $error = ($user->country_ref_id != $value['countryids'] && $value['countryids']) ? 1 : 0;
                        $cites = TblCityMaster::model()->count(array('condition' => 'country_id=' . $value['countryids']. ''));

                        if(($this->is_location_entered == 'Y' && ($cites>1) && $this->country_pref[0]['pref_location'] == '' && $this->country_pref[0]['countryids']) || ($this->is_location_entered == 'Y' && ($cites>1) && $this->country_pref[0]['pref_location'] == '' && $this->country_pref[1]['countryids'])) {
                                $this->addError('country_pref[0][pref_location]', 'Enter preferred location');
                        }
                    }
                }
            }
        }
        /** Country validation End **/

        /** Department validation start here **/
        $selected = 0;$first = '';$k = 0;
        if ($this->dept_not_sure) {
        } else {
            foreach ($this->dept_pref as $key=>$value) {
                if ($k == 0) {
                    $first = $key;
                } $k++;
                if ($value) {
                    $selected = 1;
                }
            }
            if ($selected == 0) {
                $this->addError('dept_pref['.$first.']', 'Select department');
                $this->addError('dept_others['.$first.']', 'Choose course');
            } else {
                $selected_val = array();
                foreach ($this->dept_pref as $key=>$value) {
                    if ($value && $value == 'others') {
                        $this->addError('dept_others['.$key.']', 'Select a valid course');
                    }
                }
                foreach ($this->dept_pref as $key=>$value) {
                    if ($value && $this->sub_dept_pref[$key]) {
                        $val = $value.'=='.$this->sub_dept_pref[$key].'=='.$this->dept_others[$key];
                        if (in_array($val, $selected_val)) {
                            if ($this->dept_others[$key]) {
                                $this->addError('dept_others['.$key.']', 'Select different course');
                            } else {
                                if ($this->sub_dept_pref[$key] != 'others' && $this->dept_pref[$key] != 'others') {
                                    $this->addError('sub_dept_pref['.$key.']', 'Select different department');
                                }
                            }
                        }
                        $selected_val[] = $val;
                    }
                }
                $no_dept = array();
                foreach ($this->dept_pref as $key=>$value) {
                    $val = $value;
                    if ($value) {
                        if (in_array($val, $no_dept) && !$this->sub_dept_pref[$key]) {
                            if ($this->dept_others[$key]) {
                                $this->addError('dept_others['.$key.']', 'Select different course');
                            } else {
                                $this->addError('sub_dept_pref['.$key.']', 'Select different department');
                            }
                        }
                        $no_dept[] = $val;
                    }
                }
            }
        }
        /** Department validation End **/

        /** 12th Education validation start here **/
        $user = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
        if(in_array($user->present_class, array(11, 12)))
        {
            if (!trim($this->school_name_12)) {
                $this->addError('school_name_12', 'Enter School');
            }
            if (is_numeric(trim($this->school_name_12))) {
                $this->addError('school_name_12', 'Enter valid School');
            }
            if (!trim($this->year_12)) {
                $this->addError('year_12', 'Select Year');
            }
            if (!trim($this->board_12)) {
                $this->addError('board_12', 'Select Board');
            } else {
                $board_det = LookupBoardEquivalent::model()->findByPk($this->board_12);
                if ($board_det->overall_type == 'Marks') {
                    $this->checkNumericValues('overall_marks_12', $this->overall_marks_12);
                }
                if ($board_det->overall_type == 'Marks-GPA') {
                    $this->checkNumericValues('overall_marks_gpa_12', trim($this->overall_marks_gpa_12));
                }
                if ($board_det->overall_type == 'Grades') {
                    $flag = 0; $j = 0;
                    foreach ($this->overall_grade_12 as $key=>$value) {
                        if($value) {
                            $flag = 1;
                        }
                        if($j == 0){
                            $FirstKey = $key;
                        }
                        $j++;
                    }
                    if(!$flag){
                        $this->addError('overall_grade_12['.$FirstKey.']', 'Select Grades');
                    }
                } elseif ($board_det->overall_type == 'Points') {
                    if (!$this->overall_points_12) {
                        $this->addError('overall_points_12', 'Select Points');
                    }
                }
            }
        }

        if(!in_array($user->present_class, array(9)))
        {
            if (!trim($this->school_name_10)) {
                $this->addError('school_name_10', 'Enter School');
            }
            if (is_numeric(trim($this->school_name_10))) {
                $this->addError('school_name_10', 'Enter valid School');
            }
            if (!trim($this->year_10)) {
                $this->addError('year_10', 'Select Year');
            }
            if ($this->year_10 && $this->year_12) {
                if (($this->year_12 - $this->year_10) < 2) {
                    $this->addError('year_10', 'Atleast 2 years Less than 12th passout');
                }
            }

            if (!trim($this->board_10)) {
                $this->addError('board_10', 'Select Board');
            } else {
                $board_det = LookupBoardEquivalent::model()->findByPk($this->board_10);
                if ($board_det->overall_type == 'Marks') {
                    $this->checkNumericValues('overall_marks_10', $this->overall_marks_10);
                }
                if ($board_det->overall_type == 'Marks-GPA') {
                    $this->checkNumericValues('overall_marks_gpa_10', $this->overall_marks_gpa_10);
                }

                if (($board_det->overall_type == 'Marks')) {
                    $max = 100;
                    if ($this->overall_marks_10 && $this->overall_marks_10 <= 10) {
                        $max = 10;
                    }
                }
                elseif ($board_det->overall_type == 'Grades') {
                    $flag = 0; $j = 0;
                    foreach ($this->overall_grade_10 as $key=>$value) {
                        if($value) {
                            $flag = 1;
                        }
                        if($j == 0){
                            $FirstKey = $key;
                        }
                        $j++;
                    }
                    if(!$flag){
                        $this->addError('overall_grade_10['.$FirstKey.']', 'Select Grades');
                    }

                } elseif ($board_det->overall_type == 'Points') {
                    if (!$this->overall_points_10) {
                        $this->addError('overall_points_10', 'Select Points');
                    }
                }
            }
        }
        /** Education validation start here **/
    }

    public function checkNumericValues($attribute, $value, $max = 100) {
        if ($value) {
            if (!is_numeric($value)) {
                $this->addError($attribute, 'Enter numeric values');
            }
            if ($value > $max) {
                $this->addError($attribute, 'Enter marks between 1 to '.$max);
            }
            if ($value < 1 ) {
                $this->addError($attribute, 'Value should be greater than 1');
            }
        } else {
            $this->addError($attribute, 'Enter marks');
        }
    }

    public function ValidateCountryPhone()
    {
        $user = TblUserMaster::model()->findByPk($this->user_id);
        if($user->is_visited_school == 'N' || empty($user->city_ref_id) ) {
            if(!$this->city_id){
                $this->addError('city', 'Enter your City');
            }
        }
        if(!$this->country_code){
            $this->addError('country_code', 'Select your country code');
        }
        else if($this->country_code)
        {
            if ($this->country_code == 91) {
                if (strlen($this->phone) != 10 || !preg_match('/^[7-9]+[0-9]*$/',$this->phone) ) {
                    $this->addError('phone', 'Enter a valid phone number');
                }
            }
            if ($this->phone) {
                if (!(int)$this->phone) {
                    $this->addError('phone', 'Should contain numbers only');
                }

                if (strlen($this->phone) < 7 && $this->country_code != 91) {
                    $this->addError('phone', 'Enter a valid phone number');
                }
            }
            else if($this->country_code){
                if(!$this->phone){
                    $this->addError('phone', 'Phone number is required');
                }
            }
        }
    }

    public function _ce($error){

        return '<div class="holder"><p>'.$error.'</p></div>';
    }

    public function addError($attribute,$error) {

        parent::addError($attribute, $this->_ce($error));
    }
}