<?php
yii::import('zii.widgets.CPortlet');



class StudentProfileHeader extends CPortlet
{
    public $isUserImageAvailable;
    public $_isStudent = false;
    public $rbacRole = '';
    public $_hasEdit = false;
    public $_isDI = false;
    public $userData;

    public $userParams = array();
    public $defaultUserData = array('M' => array('gender' => 'Male', 'defaultImage' => 'user_img_male.jpg'), 'F' => array('gender' => 'Female', 'defaultImage' => 'user_img_female.jpg'));
    public $userImage = '';
	public $isFullVisibilty = true;
    public $pdfDownload = false;
    public $psychometricTestReport;

    public function init() {
        // pre-process if any
    }



    public function run() {
        $this->rbacRole = CommonUtils::getRbacUserRole(Yii::app()->user->id);


        $gender = $this->userData->gender;
        $userPic = $this->userData->user_photo;
        $userImageFolder = Yii::getPathOfAlias('webroot').'/../uploads/user/thumb/';
        $this->userImage = $userImageFolder .($gender == 'M' ? 'user_img_male.jpg' : 'user_img_female.jpg');
        if($userPic && file_exists($userImageFolder.$userPic)){
            $this->userImage = $userImageFolder . $userPic;
        }

        $expertVendor = Yii::app()->user->getState('isVendor');
        if($expertVendor){
            if(strtolower(Yii::app()->controller->action->id) != 'viewpdfdownload'){
                $this->isFullVisibilty = false;
                $expertID = Yii::app()->user->sub_id;
                $student_id = $this->userData->user_id;
                if(DiHelper::isVendorBoughtStudentProfile($expertID,$student_id)){
                    $this->isFullVisibilty = true;
                }
                $this->render('student_profile_header');
            }elseif(strtolower(Yii::app()->controller->action->id) == 'viewpdfdownload'){
                $this->pdfDownload = true;
                $this->render('student_profile_header_table_structure');
            }
        }



        if($this->_isDI && Yii::app()->controller->action->id == 'viewPdfDownload' ||($this->rbacRole == 'SuperAdmin' && Yii::app()->controller->action->id == 'viewPdfDownload') || ($this->rbacRole == 'Admin' && Yii::app()->controller->action->id == 'viewPdfDownload') || ($this->rbacRole == 'Advisor' && Yii::app()->controller->action->id == 'viewPdfDownload')){
            $this->pdfDownload = true;
            $this->render('student_profile_header_table_structure');
        }


		
		if($this->_isDI && strtolower(Yii::app()->controller->action->id) != 'viewpdfdownload'){
			// For Di User Default Visibilty will be false
			// But it can be tru only if di user Bought this profile
			$this->isFullVisibilty = false;
			$di_id = Yii::app()->user->di_id;
			$student_id = $this->userData->user_id;
			if(DiHelper::isDiBoughtStudentProfile($di_id,$student_id)){
			$this->isFullVisibilty = true;
			}
            $this->render('student_profile_header');
		}





         if(($this->rbacRole == 'Student' && strtolower(Yii::app()->controller->action->id) != 'viewpdfdownload') || ($this->rbacRole == 'SuperAdmin' && strtolower(Yii::app()->controller->action->id) != 'viewpdfdownload') || ($this->rbacRole == 'SI' && strtolower(Yii::app()->controller->action->id) != 'viewpdfdownload') || ($this->rbacRole == 'Admin' && strtolower(Yii::app()->controller->action->id) != 'viewpdfdownload') ||  ($this->rbacRole == 'Advisor' && strtolower(Yii::app()->controller->action->id) != 'viewpdfdownload')){
            $this->render('student_profile_header');
        }

    }

    public function printr($array=array()){
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }
}