<?php

/**
 * This is the model class for table "lookup_school".
 *
 * The followings are the available columns in table 'lookup_school':
 * @property string $first_name
 * @property string $last_name
 * @property string $username
 * @property string $pass_word
 * @property string $confirm_password
 * @property string $gender
 * @property string $present_school
 * @property integer $present_class
 * @property integer $present_board_ref_id
 * @property integer $passout_month
 * @property integer $passout_year
 * @property string $verifyCode
 *
 */
class StudentSignup extends CFormModel
{

    public $first_name;
    public $last_name;
    public $username;
    public $confirm_username;
    public $pass_word;
    public $confirm_password;
    public $gender;
    public $present_school;
    public $present_school_id;
    public $present_class;
    public $present_board_ref_id;
    public $present_board_ref_id_1;
    public $passout_month;
    public $passout_year;
    public $verifyCode;
    public $country_code;
    public $newsletter;
    public $emailExistsinMasterList;
    public $present_studylevel;

    public $country_list;
    public $country_pref1, $country_pref2, $country_pref3;
    public $career_pref1, $career_pref2, $career_pref3;
    public $subject_pref1, $subject_pref2, $subject_pref3;
    public $dept_pref, $dept_pref1, $dept_pref2, $dept_pref3;
    public $sub_dept_pref, $sub_dept_pref1, $sub_dept_pref2, $sub_dept_pref3;
    public $aspire_college;
    public $validateName;
    //public $validateLikelyStartPeriod;
    public $likely_start_period;
    public $likely_start_period_month;
    public $likely_start_period_year;
    public $country_preference;
    public $country_not_sure;
    public $department_not_sure;
    public $career_not_sure;

    public $course_level1;
    public $course_level2;
    public $course_level;

    public $study_duration1;
    public $study_duration2;
    public $study_duration;

    public $address1;
    public $address2;
    public $country;
    public $state;
    public $city;
    public $zip;
    public $alternate_email;
    public $alternate_phone_contry_code;
    public $alternate_phone;
    public $parent_first_name;
    public $parent_last_name;
    public $relation_type;
    public $parent_phone_country_code;
    public $parent_phone;
    public $parent_email;

    public $school_name;
    public $board;

    public $interests;

    //public $can_contact;


    public $change_school;
    public $change_school_not_sure;
    public $interested_stream;
    public $interested_stream_not_sure;
    public $cssStudentNames;



    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules()
    {
        return array(
            //array('cssStudentNames', 'required', 'on' => 'firstPage','message' => '<div class="holder"><p>Choose Name</p></div>'),
            array('username', 'required', 'on' => 'firstPage','message' => '<div class="holder"><p>Enter your email</p></div>'),
            array('username, first_name, last_name', 'required', 'on' => 'firstPage','message' => '<div class="holder"><p>{attribute} can\'t be blank</p></div>'),            array('first_name, last_name', 'match', 'pattern' => '/^[a-zA-Z][a-zA-Z\s]+$/', 'message' => '<div class="holder"><p>No special characters allowed.</p></div>', 'on' => 'firstPage'),
            array('confirm_username', 'required', 'on' => 'firstPage','message' => '<div class="holder"><p>Confirm your email</p></div>'),
            array('pass_word', 'required', 'on' => 'firstPage','message' => '<div class="holder"><p>Enter your password</p></div>'),
			//array('pass_word', 'length', 'min' => 6, 'max' => 20,'on' => 'firstPage', 'tooShort' => '<div class="holder"><p>Password should be atleast 6 characters </p></div>', 'tooLong' =>'<div class="holder"><p>Password shouldn\'t be more than 20 characters</p></div>'),
			
            array('present_board_ref_id', 'required', 'on' => 'firstPage','message' => '<div class="holder"><p>Select your board</p></div>'),

            //array('first_name', 'required', 'on' => 'firstPage', 'message' => '<div class="holder"><p>First name can\'t be blank</p></div>', 'skipOnError'=>true),
            //array('first_name', 'match', 'pattern' => '/^[a-z ]*$/i', 'message' => '<div class="holder"><p>Strange name ! Check again</p></div>', 'skipOnError'=>true),

            //array('last_name', 'required', 'on' => 'firstPage', 'message' => '<div class="holder"><p>Last name can\'t be blank</p></div>', 'skipOnError'=>true),
            //array('last_name', 'match', 'pattern' => '/^[a-z ]*$/i', 'message' => '<div class="holder"><p>Strange name ! Check again</p></div>', 'skipOnError'=>true),


            array('gender', 'required', 'message' => '<div class="holder"><p>Select your gender</p></div>', 'on' => 'firstPage'),
            array('present_studylevel', 'required', 'message' => '<div class="holder"><p>Select your current study level</p></div>', 'on' => 'firstPage'),

            array('username', 'unique', 'className' => 'LoginMaster', 'message' => '<div class="holder"><p>Email address already registered. <a href="'.Yii::app()->createUrl('login').'">Sign In</a></p></div>', 'on' => 'firstPage'),
            array('username', 'unique', 'className' => 'LoginMaster', 'message' => '<div class="holder"><p>You have already entered this email as primary email. Please provide an alternate email address.</p></div>', 'on' => 'cssContactInfo, cssContactInfo10'),

            //array('username', 'unique', 'className' => 'LoginMaster', 'message' => '<div class="holder"><p>Please enter different email address.</p></div>', 'on' => 'cssContactInfo10'),
            //array('username, confirm_username, alternate_email, parent_email', 'match', 'pattern' => '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>', 'on' => 'firstPage, cssContactInfo'),
            array('username, confirm_username, alternate_email, parent_email', 'match', 'pattern' => '/^[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>', 'on' => 'firstPage, cssContactInfo, cssContactInfo10'),
            //array('username, confirm_username, alternate_email, parent_email', 'match', 'pattern' => '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>', 'on' => 'firstPage, cssContactInfo10'),

            //array('username', 'unique', 'className' => 'LoginMaster', 'message' => '<div class="holder"><p>Please enter different email address.</p></div>', 'on' => 'cssContactInfo10'),
            //array('username, confirm_username, alternate_email, parent_email', 'match', 'pattern' => '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>', 'on' => 'firstPage, cssContactInfo'),

            //array('username, confirm_username, alternate_email, parent_email', 'match', 'pattern' => '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/', 'message' => '<div class="holder"><p>Enter a valid email</p></div>', 'on' => 'firstPage, cssContactInfo10'),

            array('confirm_username', 'compare', 'compareAttribute' => 'username', 'message' => '<div class="holder"><p>Email doesn\'t match</p></div>', 'on' => 'firstPage'),

            array('pass_word', 'length', 'min' => 6, 'max' => 20, 'tooShort' => '<div class="holder"><p>Password should be atleast 6 characters </p></div>', 'tooLong' =>'<div class="holder"><p>Password shouldn\'t be more than 20 characters</p></div>', 'on' => 'firstPage'),
            array('country_code, user_id, country_pref1, country_pref2, country_pref3, dept_pref1, dept_pref2, dept_pref3', 'safe'),

            array('passout_month', 'required', 'message' => '<div class="holder"><p>Select completion month</p></div>', 'on' => 'cssBasicInfo, firstPage'),

            array('passout_year', 'required', 'message' => '<div class="holder"><p>Select completion year</p></div>', 'on' => 'cssBasicInfo, firstPage'),

            array('likely_start_period', 'likelyStartPeriodValidation', 'on' => 'b2cCountryPref'),
            array('country_preference', 'countryPrefValidation', 'on' => 'b2cCountryPref'),
            array('dept_pref', 'deptPrefValidation', 'on' => 'b2cDeptPref'),

            array('likely_start_period', 'likelyStartPeriodValidation', 'on' => 'b2cCountryPref10'),
            array('country_preference', 'countryPrefValidation10', 'on' => 'b2cCountryPref10'),

            array('career_preference', 'CareerPrefValidation10', 'on' => 'CareerPref10'),
            array('subject_preference', 'SubjectPrefValidation10', 'on' => 'CareerPref10'),

            array('school_change', 'schoolValidation10', 'on' => 'Education10'),
            array('interests', 'interestsValidation10', 'on' => 'interests10'),

            array('present_school, present_board_ref_id', 'required', 'message' => 'Please select {attribute}.', 'on' => 'cssBasicInfo'),
            array('aspire_college', 'validateAspireCollege', 'on' => 'b2cAspirationList'),

            array('course_level', 'validateCourseLevel', 'on' => 'cssPreferences'),
            array('likely_start_period_month', 'cssLikelyStartPeriodValidation', 'on' => 'cssPreferences'),
            array('country_preference', 'cssCountryPrefValidation', 'on' => 'cssPreferences'),
            //array('study_duration', 'validateStudyDuration', 'on' => 'cssPreferences'),
            array('dept_pref', 'cssDeptPrefValidation', 'on' => 'cssMajorPreferences'),
            //array('address1, address2, country, state, city, zip, alternate_phone_contry_code, alternate_phone, parent_first_name, parent_last_name, relation_type', 'required', 'message' => 'Please select {attribute}.', 'on' => 'cssContactInfo'),
            array('alternate_phone_contry_code, alternate_phone', 'required', 'message' => '<div class="holder"><p>Your {attribute} is required</p></div>', 'on' => 'cssContactInfo'),
            array('alternate_phone_contry_code, alternate_phone', 'required', 'message' => '<div class="holder"><p>Your {attribute} is required</p></div>', 'on' => 'cssContactInfo10'),
            //, parent_phone_country_code, parent_phone, parent_email
            //array('alternate_phone_contry_code, alternate_phone, parent_phone_country_code, parent_phone', 'match', 'pattern' => '/^[0-9]*$/', 'message' => 'Please enter valid phone number', 'on' => 'cssContactInfo'),
            array('alternate_phone_contry_code, parent_phone_country_code', 'numerical', 'integerOnly' => true, 'min'=>'1', 'tooSmall'=>'Country code is invalid.', 'message' => '<div class="holder"><p>Country code should only contain numbers</p></div>', 'on' => 'cssContactInfo'),
            array('alternate_phone, parent_phone', 'numerical', 'integerOnly' => true, 'message' => '<div class="holder"><p>Phone number should only contain numbers</p></div>', 'on' => 'cssContactInfo'),
            array('alternate_phone_contry_code, parent_phone_country_code', 'numerical', 'integerOnly' => true, 'min'=>'1', 'tooSmall'=>'Country code is invalid.', 'message' => '<div class="holder"><p>Country code should only contain numbers</p></div>', 'on' => 'cssContactInfo10'),

            array('alternate_phone, parent_phone', 'numerical', 'integerOnly' => true, 'message' => '<div class="holder"><p>Phone number should contain numbers only</p></div>', 'on' => 'cssContactInfo10'),
            array('alternate_phone, parent_phone', 'length', 'min' => '5', 'max' => '12', 'tooShort' => '<div class="holder"><p>Phone number cannot be less than 5 digits.</p></div>', 'tooLong' => 'Phone number cannot be more than 12 digits.', 'on' => 'cssContactInfo'),

            array('alternate_phone, parent_phone', 'match', 'pattern' => '/^[1-9]+[0-9]{0,12}$/i', 'message' => '<div class="holder"><p>Phone number is invalid</p></div>', 'on' => 'cssContactInfo'),
            array('alternate_phone, parent_phone', 'length', 'min' => '5', 'max' => '12', 'tooShort' => '<div class="holder"><p>Phone number cannot be less than 5 digits.</p></div>', 'tooLong' => '<div class="holder"><p>Phone number cannot be more than 12 digits.</p></div>', 'on' => 'cssContactInfo10'),

            array('alternate_phone, parent_phone, alternate_phone_contry_code', 'match', 'pattern' => '/^[1-9]+[0-9]{0,12}$/i', 'message' => '<div class="holder"><p>{attribute} should contain integers only</p></div>', 'on' => 'cssContactInfo10'),
            array('parent_phone_country_code', 'checkContactCountryCode', 'on' => 'cssContactInfo'),
            array('parent_phone_country_code', 'checkContactCountryCode10', 'on' => 'cssContactInfo10'),
            array('parent_email', 'checkParentEmail', 'on' => 'cssContactInfo'),
            array('parent_email', 'checkParentEmail10', 'on' => 'cssContactInfo10'),
            array('parent_first_name, parent_last_name', 'checkParentNameAndRelation', 'on' => 'cssContactInfo'),

            array('parent_first_name, parent_last_name', 'match', 'pattern' => '/^[a-zA-Z][a-zA-Z\s]+$/', 'message' => '<div class="holder"><p>Please enter valid name</p></div>', 'on' => 'cssContactInfo'),
            array('zip', 'match', 'pattern'=>'/^[a-zA-Z1-9]+[a-zA-Z0-9]{3,12}$/', 'message'=>'<div class="holder"><p>The Zipcode entered is not correct</p></div>', 'on' => 'cssContactInfo'),

            array('parent_last_name', 'checkParentNameAndRelation10', 'on' => 'cssContactInfo10'),
            array('alternate_phone', 'studentPhoneValidation', 'on' => 'cssContactInfo, finishPage'),

            //array('can_contact', 'required', 'message' => 'Select your preference', 'on' => 'finishPage'),
            array('alternate_phone', 'studentContactInfoValidation', 'on' => 'finishPage'),
            //array('alternate_phone_contry_code, alternate_phone', 'required', 'message' => 'Fields are mandatory', 'on' => 'finishPage'),
            //array('alternate_phone_contry_code, alternate_phone', 'match', 'pattern' => '/^[0-9]*$/', 'message' => 'Please enter valid phone number', 'on' => 'finishPage'),

            //array('school_name', 'required', 'message' => 'Please select {attribute}.', 'on' => 'cssEducation'),
            array('likely_start_period_month, likely_start_period_year, course_level, country_pref1, country_pref2, country_pref3, country_not_sure, study_duration, department_not_sure, dept_pref1, dept_pref2, dept_pref3, passout_month, passout_year board, country, state, city, zip, alternate_email, alternate_phone_contry_code, alternate_phone, parent_first_name, parent_last_name, relation_type, parent_phone_country_code, parent_phone, parent_email', 'safe'),

            //array('cssStudentNames', 'nameValidation'),


        );
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels()
    {
        return array(
            'username' => 'email',
            'confirm_username' => 'confirm email',
            'pass_word' => 'password',
            'gender' => 'gender',
            'first_name' => 'first name',
            'last_name' => 'last name',
            'present_school' => 'school name',
            'present_class' => 'current study lavel',
            'confirm_password' => 'confirm password',
            'present_board_ref_id' => 'Board',
            'passout_month' => 'month',
            'passout_year' => 'year',
            'verifyCode' => 'verification code',
            'present_studylevel' => 'current study lavel',
            'likely_start_period' => 'likely start period',
            'country_list' => 'country',
            'country_pref1' => 'country preference',
            'country_pref2' => 'country preference',
            'country_pref3' => 'country preference',

            'dept_pref' => 'department',
            'dept_pref1' => 'department preference',
            'dept_pref2' => 'department preference',
            'dept_pref3' => 'department preference',
            'aspire_college' => 'aspire college',

            'course_level' => 'study level',
            'study_duration' => 'study duration',
            'alternate_phone_contry_code' => 'country code',
            'alternate_phone' => 'phone number'
        );
    }

    public function studentPhoneValidation() {

        if ($this->alternate_phone) {
            if ($this->alternate_phone_contry_code == 91) {/*
                $res = file_get_contents('http://www.bmobile.in/'.$this->alternate_phone);

                $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
                $res_arr1 = explode('</tbdy>', $res_arr[1]);

                $count = 0;
                $count = substr_count($res_arr1[0], $this->alternate_phone); */

                if($this->alternate_phone[0] < 7){
                    $this->addError('alternate_phone', '<div class="holder"><p>Enter a valid mobile number</p></div>');
                }
            }
        } else {
            $this->addError('alternate_phone', '<div class="holder"><p>Enter a mobile number</p></div>');
        }
    }

    public function validateAspireCollege($attribute, $params){
        $this->addError($attribute, 'Your department preference should not be duplicate.');
    }

    public function deptPrefValidation($attribute, $params)
    {
        if ($this->dept_pref1 == '' && @$this->department_not_sure == '') {
            $this->addError('dept_pref1', '<div class="holder"><p>Your first major of study is required</p></div>');
        } elseif ($this->dept_pref1 != '' && $this->dept_pref1 == $this->dept_pref2) {
            $this->addError('dept_pref2', '<div class="holder"><p>Select a different major preference</p></div>');
        } elseif ($this->dept_pref1 != '' && $this->dept_pref1 == $this->dept_pref3) {
            $this->addError('dept_pref3', '<div class="holder"><p>Select a different major preference</p></div>');
        } elseif ($this->dept_pref2 != '' && $this->dept_pref2 == $this->dept_pref3) {
            $this->addError('dept_pref3', '<div class="holder"><p>Select a different major preference</p></div>');
        }
    }

    public function countryPrefValidation($attribute, $params)
    {
        if ($this->country_pref1 == '' &&
            $this->country_pref2 == '' &&
            $this->country_pref3 == ''
        ) {
            $this->addError('country_pref1', '<div class="holder"><p>Select a country of your preference</p></div>');
        } else
            if($this->country_pref1 != '' && $this->country_pref1 == $this->country_pref2){
                $this->addError('country_pref2', '<div class="holder"><p>You cannot select a country more than once</p></div>');
            }else if($this->country_pref1 != '' && $this->country_pref1 == $this->country_pref3){
                $this->addError('country_pref3', '<div class="holder"><p>You cannot select a country more than once</p></div>');
            }else if($this->country_pref2 != '' && $this->country_pref2 == $this->country_pref3){
                $this->addError('country_pref3', '<div class="holder"><p>You cannot select a country more than once</p></div>');
            }

        /*if($_POST['StudentSignup']['country_pref1'] == '' &&
            $_POST['StudentSignup']['country_pref2'] == '' &&
            $_POST['StudentSignup']['country_pref3'] == ''
        ){
            $this->addError($attribute, 'Please select your country preference.');
        }
        if($_POST['StudentSignup']['country_pref1'] == $_POST['StudentSignup']['country_pref2'] ||
            $_POST['StudentSignup']['country_pref1'] == $_POST['StudentSignup']['country_pref3'] ||
            $_POST['StudentSignup']['country_pref2'] == $_POST['StudentSignup']['country_pref3']
        ){
            $this->addError($attribute, 'Your country preference should not be duplicate.');
        }*/
    }

    public function countryPrefValidation10($attribute, $params)
    {

        if ($_POST['StudentSignup']['country_not_sure'] == 1) {

        } else {
            if ($_POST['StudentSignup']['country_pref1'] == '' &&
                $_POST['StudentSignup']['country_pref2'] == '' &&
                $_POST['StudentSignup']['country_pref3'] == ''
            ) {
                $this->addError('country_pref1', '<div class="holder"><p>Select a country of your preference</p></div>');
            } else if (($_POST['StudentSignup']['country_pref1'] != '' &&
                    (($_POST['StudentSignup']['country_pref1'] == $_POST['StudentSignup']['country_pref2']) ||
                        ($_POST['StudentSignup']['country_pref1'] == $_POST['StudentSignup']['country_pref3'])))) {
                $this->addError('country_pref1', '<div class="holder"><p>You cannot select a country more than once</p></div>');

            } else if (($_POST['StudentSignup']['country_pref2'] != '' &&
                        (($_POST['StudentSignup']['country_pref2'] == $_POST['StudentSignup']['country_pref3'])))) {
                $this->addError('country_pref2', '<div class="holder"><p>You cannot select a country more than once</p></div>');

            } else if ( ($_POST['StudentSignup']['country_pref3'] != '' &&
                        ($_POST['StudentSignup']['country_pref1'] == $_POST['StudentSignup']['country_pref3'])) ) {
                    $this->addError('country_pref3', '<div class="holder"><p>You cannot select a country more than once</p></div>');
            }
        }
    }

    public function CareerPrefValidation10() {
        if ($_POST['StudentSignup']['career_not_sure'] == 1) {

        } else {
            if ($_POST['StudentSignup']['career_pref1'] == '' &&
                $_POST['StudentSignup']['career_pref2'] == '' &&
                $_POST['StudentSignup']['career_pref3'] == ''
            ) {
                $this->addError('career_pref1', '<div class="holder"><p>Select a career of your preference</p></div>');
            } else if (($_POST['StudentSignup']['career_pref1'] != '' &&
                (($_POST['StudentSignup']['career_pref1'] == $_POST['StudentSignup']['career_pref2']) ||
                    ($_POST['StudentSignup']['career_pref1'] == $_POST['StudentSignup']['career_pref3'])))) {
                $this->addError('career_pref1', '<div class="holder"><p>You cannot select a career more than once</p></div>');

            } else if (($_POST['StudentSignup']['career_pref2'] != '' &&
                (($_POST['StudentSignup']['career_pref2'] == $_POST['StudentSignup']['career_pref3'])))) {
                $this->addError('career_pref2', '<div class="holder"><p>You cannot select a career more than once</p></div>');

            } else if ( ($_POST['StudentSignup']['career_pref3'] != '' &&
                ($_POST['StudentSignup']['career_pref1'] == $_POST['StudentSignup']['career_pref3'])) ) {
                $this->addError('career_pref3', '<div class="holder"><p>You cannot select a career more than once</p></div>');
            }
        }
    }

    public function SubjectPrefValidation10() {
        if ($_POST['StudentSignup']['present_board_ref_id'] == '') {
            $this->addError('present_board_ref_id', '<div class="holder"><p>Select your current board</p></div>');
        } else {
            if ($_POST['StudentSignup']['subject_pref1'] == '' &&
                $_POST['StudentSignup']['subject_pref2'] == '' &&
                $_POST['StudentSignup']['subject_pref3'] == ''
            ) {
                $this->addError('subject_pref1', '<div class="holder"><p>Select a subject of your preference</p></div>');
            } else if (($_POST['StudentSignup']['subject_pref1'] != '' &&
                (($_POST['StudentSignup']['subject_pref1'] == $_POST['StudentSignup']['subject_pref2']) ||
                    ($_POST['StudentSignup']['subject_pref1'] == $_POST['StudentSignup']['subject_pref3'])))) {
                $this->addError('subject_pref1', '<div class="holder"><p>You cannot select a subject more than once</p></div>');

            } else if (($_POST['StudentSignup']['subject_pref2'] != '' &&
                (($_POST['StudentSignup']['subject_pref2'] == $_POST['StudentSignup']['subject_pref3'])))) {
                $this->addError('subject_pref2', '<div class="holder"><p>You cannot select a subject more than once</p></div>');

            } else if ( ($_POST['StudentSignup']['subject_pref3'] != '' &&
                ($_POST['StudentSignup']['subject_pref1'] == $_POST['StudentSignup']['subject_pref3'])) ) {
                $this->addError('subject_pref3', '<div class="holder"><p>You cannot select a subject more than once</p></div>');
            }
        }
    }

    public function interestsValidation10 () {
         if ($_POST['StudentSignup']['interests'] != '') {
            if (trim($_POST['StudentSignup']['interests']) == '') {
                $this->addError('interests', '<div class="holder"><p>Tell us your interests & hobbies </p></div>');
            }
        } else {
            $this->addError('interests', '<div class="holder"><p>Tell us your interests & hobbies </p></div>');
        }
    }

    public function schoolValidation10() {
        if ($_POST['StudentSignup']['change_school_not_sure'] == 0) {
            if ($_POST['StudentSignup']['change_school'] == '') {
                $this->addError('change_school', '<div class="holder"><p>Select an option</p></div>');
            }
        }

        if ($_POST['StudentSignup']['interested_stream_not_sure'] == 0) {
            if ($_POST['StudentSignup']['interested_stream'] == '') {
                $this->addError('interested_stream', '<div class="holder"><p>Select stream/major</p></div>');
            }
        }

        if (trim($_POST['StudentSignup']['school_name']) == '') {
            if (trim($_POST['StudentSignup']['school_name']) == '') {
                $this->addError('school_name', '<div class="holder"><p>Please enter your school name</p></div>');
            }
        }

        if (trim($_POST['StudentSignup']['school_name']) != '') {
            if (preg_match('/^[0-9]+$/', trim($_POST['StudentSignup']['school_name']))) {
                $this->addError('school_name', '<div class="holder"><p>Please enter correct school name</p></div>');
            }
        }

        if ($_POST['StudentSignup']['passout_month'] == '') {
            if ($_POST['StudentSignup']['passout_month'] == '') {
                $this->addError('passout_month', '<div class="holder"><p>Select completion month</p></div>');
            }
        }

        if ($_POST['StudentSignup']['passout_year'] == '') {
            if ($_POST['StudentSignup']['passout_year'] == '') {
                $this->addError('passout_year', '<div class="holder"><p>Select completion year</p></div>');
            }
        }

        if ($_POST['StudentSignup']['present_board_ref_id'] == '') {
            if ($_POST['StudentSignup']['present_board_ref_id'] == '') {
                $this->addError('present_board_ref_id', '<div class="holder"><p>Select board</p></div>');
            }
        }
    }

    public function likelyStartPeriodValidation($attribute, $params)
    {
        if($_POST['StudentSignup']['likely_start_period_month'] == '' && $_POST['StudentSignup']['likely_start_period_year'] == ''){
            $this->addError($attribute, 'Please select likely start period');
        }else if(
            ($_POST['StudentSignup']['likely_start_period_month'] == '' && $_POST['StudentSignup']['likely_start_period_year'] != '') ||
            ($_POST['StudentSignup']['likely_start_period_month'] != '' && $_POST['StudentSignup']['likely_start_period_year'] == '')
        ){
            $this->addError($attribute, 'Please select likely start period');
        }
        //$this->addError($attribute, 'akdjfklajkldfjkajdfjklf'.print_r($_POST['StudentSignup'], true)."##");
        /*if (count($this->likely_start_period) > 2) {
            $this->addError($attribute, $this->attribute . ' only 2 options are allowed.');
        }*/

    }



    public function getBoardListBySchoolName($schoolName, $schoolHiddenId = '')
    {
        if ($schoolHiddenId == '') {
            $boardList = Yii::app()->db->createCommand()
                ->select('board_id,board_desc')
                ->from('lookup_school ls')
                ->join('tbl_si_di sd', 'sd.school_ref_id = ls.school_id')
                ->join('tbl_si_board tsb', 'sd.inst_id=tsb.si_ref_id')
                ->join('lookup_board lb', 'tsb.board_ref_id = lb.board_id')
                ->where('school_name=:name', array(':name' => $schoolName))
                ->queryAll();
            return $boardList;
        }
        $schoolNameByHidddenId = $this->getSchoolNameBySchoolid($schoolHiddenId);
        if ($schoolNameByHidddenId->school_name == $schoolName) {
            $boardList = Yii::app()->db->createCommand()
                ->select('board_id,board_desc')
                ->from('lookup_school ls')
                ->join('tbl_si_di sd', 'sd.school_ref_id = ls.school_id')
                ->join('tbl_si_board tsb', 'sd.inst_id=tsb.si_ref_id')
                ->join('lookup_board lb', 'tsb.board_ref_id = lb.board_id')
                ->where('school_id=:id', array(':id' => $schoolHiddenId))
                ->queryAll();
            return $boardList;
        }

        return null;
    }

    public function getSchoolNameBySchoolid($schoolHiddenId)
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'school_id,school_name';
        $criteria->condition = "school_id=:schoolId";
        $criteria->params = array(':schoolId' => $schoolHiddenId);
        $schoolRefId = LookupSchool::model()->find($criteria);
        return $schoolRefId;
    }

    // $cc = country code;
    // $ic = institute code;
    function generateUNO($cc, $ic)
    {
        $rand_no = $this->getUniqueIDNum();
        $fldUNO = $cc . $ic . "-" . date('y') . $rand_no;

        $IsUNOexists = Yii::app()->db->createCommand()
            ->select('user_id')
            ->from('tbl_user_master u')
            ->where("uno = '$fldUNO'")
            ->queryRow();
        print_r($IsUNOexists);
        if ($IsUNOexists['user_id'] != '') {
            $this->generateUNO($cc, $ic);
        } else
            return $fldUNO;

    }

    public function getUniqueIDNum()
    {

        $IDLEN = 8;
        srand((double)microtime() * 1000000);
        $tmpordID = "";
        while (strlen($tmpordID) < $IDLEN) {
            $r = rand(1, 3);
            if ($r == 1) {
                $rcode = rand(48, 57);
            }
            if ($r == 2) {
                $rcode = rand(48, 57);
            }
            if ($r == 3) {
                $rcode = rand(48, 57);
            }
            $tmpordID .= chr($rcode);
        }

        $transOrdID = $tmpordID;
        return $transOrdID;

    }

    public function generateUserUNO($cc)
    {

        $start = 00000001;
        $rand_no = rand(1, 9);
        $code = "ZA";

        $maxUnoData = Yii::app()->db->createCommand()
            ->select('max(uno) as uno')
            ->from('tbl_user_master u')
            ->where("uno LIKE '%Z%'")
            ->queryRow();
        $maxUno = $maxUnoData['uno'];
        if (!empty($maxUno)) {
            $maxNo = substr($maxUno, strlen($maxUno) - 4, strlen($maxUno));
            $code = $maxUno[2] . $maxUno[3];
            $newNo = $maxNo + $rand_no;
            if ($newNo > 9999) {
                ++$code;
                $newNo = $start + $rand_no;
            }
        } else {
            $newNo = $start + $rand_no;
        }
        $newNo = str_pad($newNo, 4, '0', STR_PAD_LEFT);
        $fldUNO = $cc . $code . "-" . date('y') . $newNo;

        $IsUNOexists = Yii::app()->db->createCommand()
            ->select('user_id')
            ->from('tbl_user_master u')
            ->where("uno = '$fldUNO'")
            ->queryRow();

        if (strlen($IsUNOexists['user_id']) > 1)
            $this->generateUserUNO($cc);
        else
            return $fldUNO;
    }

    public function  setRbacAssignment($item_name, $loginId)
    {
        $model = RbacAuthassignment::model()->find(array("condition" => "userid ='$loginId'"));
        if($model){
            return $command = Yii::app()->db->createCommand()->update('rbac_authassignment', array('itemname' => $item_name), "userid = '$loginId'");
            //$model->setAttributes(array('itemname' => $item_name, 'userid' => $loginId));
            //$model->save();
        }else{
            return $command = Yii::app()->db->createCommand()->insert('rbac_authassignment', array('itemname' => $item_name, 'userid' => $loginId));
            /*$model = new RbacAuthassignment();
            $model->itemname = $item_name;
            $model->userid = $loginId;
            $model->save(false);*/
        }
        //return $command = Yii::app()->db->createCommand()->insert('rbac_authassignment', array('itemname' => $item_name, 'userid' => $loginId));
    }

    public function  setEmailAlias($loginRefId, $emailId)
    {
        return $insertResult = Yii::app()->db->createCommand()->insert('email_alias', array('login_ref_id' => $loginRefId, 'email_id' => $emailId, 'added_on' => date('Y-m-d H:i:s')));
    }

    public function  setSiStudents($userId, $instId)
    {
        return $insertResult = Yii::app()->db->createCommand()->insert('tbl_si_students', array('user_ref_id' => $userId, 'inst_ref_id' => $instId, 'is_invitation_accepted' => 'N', 'added_on' => date('Y-m-d H:i:s')));
    }

    public function updateStudentUploadMatser($userId, $emailId)
    {
        Yii::app()->db->createCommand()->update(
            'student_upload_master_list', array('user_ref_id' => $userId, 'invitation_status' => 'Accepted'), 'email_id = :id', array(':id' => $emailId)
        );
    }

    public function user_login($tmp_useremail, $tmp_password, $hasCSSAccess = 0)
    {
        try {
            $tmp_password = md5($tmp_password);
            $criteria = new CDbCriteria();
            $criteria->select = '*';
            $criteria->condition = "username=:email and pass_word=:password";
            $criteria->params = array(':email' => $tmp_useremail, ':password' => $tmp_password);
            $loginData = LoginMaster::model()->find($criteria);

            if (count($loginData) > 0) {
                $criteria1 = new CDbCriteria();
                $criteria1->select = 'login_ref_id, user_id, email_id, passwd, first_name, last_name, user_type,institute_logo, profile_status_ref_id, new_password';
                $criteria1->condition = 'login_ref_id=:loginID';
                $criteria1->params = array(':loginID' => $loginData->login_id);
                $getUserData = TblUserMaster::model()->find($criteria1);

                if (count($getUserData) > 0) {
                    $userData = array();
                    $userId = $getUserData->user_id;
                    $userData['UserId'] = $getUserData->user_id;
                    //$this->userData['UserEmail']   	= $this->rowLogin["email_id"];
                    //SASTRI
                    $userData['UserEmail'] = $loginData->username;

                    $userData['UserFullName'] = $getUserData->first_name . " " . $getUserData->last_name;
                    $userData['UserType'] = $getUserData->user_type;
                    //$this->userData['NewPass']		= $this->rowLogin["new_password"];
                    $is_active = $getUserData->profile_status_ref_id;
                    //$is_confirm			   	= $this->rowLogin["is_confirm"];

                    $userData['fldUserEmail'] = $loginData->username;
                    $userData['fldUserPass'] = $loginData->pass_word;

                    $userData['institute_id'] = "";
                    $userData['institute_logo'] = "";
                    $userData['institute_name'] = "";
                    $userData['institute_profile_url'] = "";

                    //if($is_active == '1')
                    if ($is_active <> '2') {
                        $session_id = session_id();
                        // update all the user_ref_id from uni_analytic session id = current session id
                        Yii::app()->db->createCommand()->update(
                            'uni_analytic', array('user_ref_id' => $userId), 'session_id = :id and user_ref_id = 0', array(':id' => $session_id)
                        );
                        $InstData = Yii::app()->db->createCommand()
                            ->select('SI.inst_id, SI.inst_logo, SI.inst_name, SI.inst_slug_name, SS.is_invitation_accepted')
                            ->from('tbl_si_students SS')
                            ->leftJoin('tbl_si_di SI', 'SI.inst_id = SS.inst_ref_id')
                            ->where('SS.user_ref_id=:id', array(':id' => $userId))
                            ->queryRow();

                        if (count($InstData) > 0) {
                            $fldInstId = $InstData->inst_id;
                            $fldInstLogo = $InstData->inst_logo;
                            $fldInstName = $InstData->inst_name;
                            $fldInstSlugName = $InstData->inst_slug_name;
                            $fldInstProfileURL = $this->getInstituteProfileLink($fldInstId, $fldInstSlugName);
                            $IsStudAcceptInvitaton = $InstData->is_invitation_accepted;

                            $userData['institute_id'] = $fldInstId;
                            $userData['institute_logo'] = $fldInstLogo;
                            $userData['institute_name'] = $fldInstName;
                            $userData['institute_profile_url'] = $fldInstProfileURL;

                            if ($IsStudAcceptInvitaton == "N") {
                                Yii::app()->db->createCommand()->update(
                                    'tbl_si_students', array('is_invitation_accepted' => 'Y',
                                                             'user_ref_id = :userId and inst_ref_id = :instId',
                                                             array(':userId' => $userId, ':instId' => $fldInstId))
                                );
                            }
                        }

                        // set session
                        $this->set_session("sUserUnivariety", serialize($userData));
                        if ($hasCSSAccess != 1) {
                            $this->set_session('loginID', $getUserData->login_ref_id);
                        }
                        return 1;
                    }
                }
            } else {
                return 0;
            }
        } catch (Exception $e) {
            throw new Exception('Could not login because of wrong userid and password:', 0, $e);
        }
    }

    public function getInstituteProfileLink($fldInstId, $fldInstSlugName)
    {
        $siteUrl = Yii::app()->params['cbasepath'];
        $instDir = Yii::app()->params['instDir'];
        $InstProfileLink = $siteUrl . "/" . $instDir . "/" . $fldInstSlugName . "/" . $fldInstId;

        return $InstProfileLink;
    }


    public function set_session($param_name, $param_value)
    {
        $session = new CHttpSession;
        $session->open();
        $session[$param_name] = $param_value;
    }

    public function unserializeSession($sessionKey, $requiredSessionValue = '')
    {
        $unseriallizeSession = unserialize(Yii::app()->session->itemAt($sessionKey));
        if ($requiredSessionValue != '') {
            return $unseriallizeSession['rs'][0][$requiredSessionValue];
        }
        return $unseriallizeSession['rs'][0];
    }


    function getUserRefId()
    {
        $userRefId = Yii::app()->db->createCommand()
            ->select('user_type_id')
            ->from('lookup_user_type u')
            ->where('user_type=:name', array(':name' => 'Student'))
            ->queryRow();
        return $userRefId;

    }

    public function getSchoolNameBySubdomain($subDomainSlugName)
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'school_name,school_id';
        $criteria->condition = 'subdomain_slug_name=:name';
        $criteria->join = 'INNER JOIN tbl_si_di tsd on t.school_id = tsd.school_ref_id';
        $criteria->params = array(':name' => $subDomainSlugName);
        $getSchoolDetail = LookupSchool::model()->find($criteria);
        return $getSchoolDetail;
    }

    public function getSchoolRefId($presentSchool)
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'school_id';
        $criteria->condition = "school_name=:name and user_entered=false";
        $criteria->params = array(':name' => $presentSchool);
        $schoolRefId = LookupSchool::model()->find($criteria);
        return $schoolRefId->school_id;
    }

    public function getMembershipId($param)
    {
        $userMembershipRefId = Yii::app()->db->createCommand()
            ->select('membership_id')
            ->from('lookup_membership lm')
            ->where('membership_name=:name', array(':name' => $param))
            ->queryRow();
        return $userMembershipRefId;
    }

    public function getBoardEquivalentId($pClass, $presentBoardRefId)
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'board_equivalent_id';
        $criteria->condition = "class_level=:name and board_ref_id=:bid";
        $criteria->params = array(':name' => $pClass, ':bid' => $presentBoardRefId);
        $presentBoard = LookupBoardEquivalent::model()->find($criteria);
        return $presentBoard->board_equivalent_id;
    }

    public function getStudentDetailOfSI($instId, $email)
    {
        $userMembershipRefId = Yii::app()->db->createCommand()
            ->select('first_name,last_name,email_id as username,gender,board_ref_id as present_board_ref_id,concat(class,lower(substring(class_status,1,1))) as present_class,school_name as present_school,school_id')
            ->from('student_upload_master_list sml')
            ->join('tbl_si_di tsd', 'sml.inst_ref_id = tsd.inst_id')
            ->join('lookup_school ls', 'tsd.school_ref_id = ls.school_id and user_entered=false')
        //->join('lookup_board lb', 'sml.board_ref_id = lb.board_id')
            ->where("inst_ref_id = :instID and md5(email_id) = :email and invitation_status != 'Accepted'", array(':instID' => $instId, ':email' => $email))
            ->queryRow();
        $this->attributes = $userMembershipRefId;
        //$this->gender = 'F';
        //$this->username = 'er.rahul@yahoo.co.in';
        return $userMembershipRefId;
        //print_r($userMembershipRefId);
        //exit('cxc');

    }

    public function deleteStudentFromStudentMaster($emailId)
    {

        $result = Yii::app()->db->createCommand()
            ->delete('student_upload_master_list', 'email_id=:emailId', array(':emailId' => $emailId));
        return $result;
    }

    public function getLookupUrl($label = '')
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'url';
        $criteria->condition = "label = :label";
        $criteria->params = array(':label' => $label);
        $urlData = LookupUrl::model()->find($criteria);
        return $urlData->url;
    }

    public function getLimitCountOfCSS($instId)
    {
        $criteria = new CDbCriteria();
        $criteria->condition = "inst_ref_id=:id";
        $criteria->params = array(':id' => $instId);
        $count = TblSiStudents::model()->count($criteria);
        return $count;
    }


    function redirect_url($loginId, $userTypeId = false, $subDomain = false)
    {
        $siteURL = Yii::app()->params['cbasepath'];
        $secureURL = Yii::app()->params['cbasepath'];
        $USER_DIR = Yii::app()->params['userDir'];
        $INSTITUTES_DIR = Yii::app()->params['instDir'];
        $actualHost = Yii::app()->params['actualHost'];
        $protocol = Yii::app()->params['protocol'];
        $wwwHost = Yii::app()->params['wwwHost'];
        $rootDomain = '.' . $actualHost;
        ;
        $subDomainSlugName = CommonUtils::getSubdomain();
        $mainHost = Yii::app()->params['mainHost'];
        $userLink = '';
        $result = Yii::app()->db->createCommand()
            ->select('cp.school_name,tsd.subdomain_slug_name,tsd.inst_id,tsd.inst_logo, tsd.business_model,tsd.inst_name,tsd.css_access')
            ->from('login_master lm')
            ->leftJoin('tbl_user_master um', 'um.login_ref_id = lm.login_id')
            ->leftJoin('tbl_user_prof_critical_completion cp', 'cp.user_ref_id = um.user_id')
            ->leftJoin('tbl_si_students tss', 'tss.user_ref_id = um.user_id')
            ->leftJoin('tbl_si_di tsd', 'tsd.inst_id = tss.inst_ref_id')
            ->where("um.login_ref_id=:loginId", array(':loginId' => $loginId))
            ->queryRow();

        // updatiing spartnersslug
        $sPartnersSlugInstituteID = $result['inst_id'];
        $sPartnersSlugInstituteLogo = $result["inst_logo"];
        $sPartnersSlugSubDomainSlugName = $result["subdomain_slug_name"];
        $sPartnersSlugAccountType = $result["business_model"];
        $sPartnersSlugInstituteName = $result["inst_name"];
        $sPartnersSlugCSSAccess = $result["css_access"];

        $PartnersSlug1['instituteID'] = $sPartnersSlugInstituteID;
        $PartnersSlug1['instituteLogo'] = $sPartnersSlugInstituteLogo;
        $PartnersSlug1['subDomainSlugName'] = $sPartnersSlugSubDomainSlugName;
        $PartnersSlug1['accountType'] = $sPartnersSlugAccountType;
        $PartnersSlug1['instituteName'] = $sPartnersSlugInstituteName;
        $PartnersSlug1['hasCSSAccess'] = $sPartnersSlugCSSAccess;
        $this->set_session("sPartnersSlug", serialize($PartnersSlug1));
        // end spartnersslug

        if (count($result) > 0) {
            $flagAskQuestion = $result['school_name'];
            if ($flagAskQuestion == 1) {
                if ($userTypeId == 2) {
                    $userLink = $siteURL . "/" . $INSTITUTES_DIR . "/dashboard.php";
                } else {

                    if ($sPartnersSlugCSSAccess == '1') {

                        if ($sPartnersSlugSubDomainSlugName != '' && $subDomainSlugName == '') {

                            $actualHost = $sPartnersSlugSubDomainSlugName . '.' . $actualHost;
                            $secureURL = $protocol . $wwwHost . $actualHost;

                        } else if ($sPartnersSlugSubDomainSlugName != '' && $subDomainSlugName != '' && ($sPartnersSlugSubDomainSlugName != $subDomainSlugName)) {
                            /* echo "<br>\one:".$actualHost;
                             echo   "<br>\one:".$siteURL;
                              echo   "<br>\one:".$secureURL;*/
                            $actualHost = $sPartnersSlugSubDomainSlugName . '.' . $actualHost;
                            $secureURL = $protocol . $wwwHost . $sPartnersSlugSubDomainSlugName . '.' . $mainHost;


                        } else {
                            /*echo "###".$protocol;
                            echo "<br>\siteURL:".$wwwHost;
                            echo "<br>\actualHost:".$actualHost;
                            echo "<br>\secureURL:".$secureURL = $protocol.$wwwHost.$actualHost;
                            exit;*/
                            $secureURL = $protocol . $wwwHost . $actualHost;

                        }
                        // $userLink = $secureURL . "/" . $USER_DIR . "/dashboard.php";
                        $userLink = $secureURL . "/app/dashboard";
                    } else {

                        //$userLink = $protocol . $wwwHost . $rootDomain . "/" . $USER_DIR . "/dashboard.php";
                        $userLink = $protocol . $wwwHost . $rootDomain . "/app/dashboard";

                    }
                }
            } else {
                $userLink = $this->getLookupUrl("profile_controller");

            }

        }
        $PartnersSlug1['latestUrlForRedirection'] = $secureURL;
        $this->set_session("sPartnersSlug", serialize($PartnersSlug1));
        return $userLink;
    }

    function getUniqueID($tmpPass)
    {

        $IDLEN = 5;
        $transOrdID = $tmpPass;
        $date = strtotime(date("Y-m-d H:i:s"));
        srand((double)microtime() * 1000000);

        $tmpordID = "";
        while (strlen($tmpordID) < $IDLEN) {
            $r = rand(1, 3);
            if ($r == 1) {
                $rcode = rand(48, 57);
            }
            if ($r == 2) {
                $rcode = rand(48, 57);
            }
            if ($r == 3) {
                $rcode = rand(48, 57);
            }
            $tmpordID .= chr($rcode);
        }
        $transOrdID = $transOrdID . $tmpordID . $date;

        return $transOrdID;
    }


    /*
     * to get students basic information using invited student's hash key
     */
    public function getInvitedStudentsBasicInfo($hash = '')
    {
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->condition = "'".$hash."' = MD5(email_id)";
        $result = studentUploadMasterList::model()->find($cdbCriteria);
        return $result;
    }

    public function validateCourseLevel($attribute, $params){
        if($_POST['StudentSignup']['course_level'][0] == '' && $_POST['StudentSignup']['course_level'][1] == ''){
            $this->addError($attribute, 'Please select study level');
        }else if($_POST['StudentSignup']['course_level'][0] == $_POST['StudentSignup']['course_level'][1]){
            $this->addError($attribute, 'Study level should not be duplicated');
        }
    }

    public function validateStudyDuration($attribute, $params){
        if($_POST['StudentSignup']['study_duration'][0] == '' && $_POST['StudentSignup']['study_duration'][1] == ''){
            $this->addError($attribute, 'Please select study duration');
        }else if($_POST['StudentSignup']['study_duration'][0] == $_POST['StudentSignup']['study_duration'][1]){
            $this->addError($attribute, 'Study duration should not be duplicated');
        }
    }

    public function cssLikelyStartPeriodValidation($attribute, $params)
    {
        if($this->likely_start_period_month == '') {
            $this->addError('likely_start_period_month', '<div class="holder"><p>Select a starting session month</p></div>');
        }
        if( $this->likely_start_period_year == ''){
            $this->addError('likely_start_period_year', '<div class="holder"><p>Select a starting session year</p></div>');
        }
    }

    public function cssCountryPrefValidation($attribute, $params) {
        if ($this->country_pref1 == '' && @$this->country_not_sure == '') {
            $this->addError('country_pref1', '<div class="holder"><p>Your first country preference is required</p></div>');
        } elseif ($this->country_pref1 != '' && $this->country_pref1 == $this->country_pref2) {
            $this->addError('country_pref2', '<div class="holder"><p>You selected the same country again</p></div>');
        } elseif ($this->country_pref1 != '' && $this->country_pref1 == $this->country_pref3) {
            $this->addError('country_pref3', '<div class="holder"><p>You selected the same country again</p></div>');
        } elseif ($this->country_pref2 != '' && $this->country_pref2 == $this->country_pref3) {
            $this->addError('country_pref3', '<div class="holder"><p>You selected the same country again</p></div>');
        }
    }

    public function cssDeptPrefValidation($attribute, $params) {
        if ($this->dept_pref1 == '' && @$this->department_not_sure == '') {
            $this->addError('dept_pref1', '<div class="holder"><p>Your first major of study is required</p></div>');
        } elseif ($this->dept_pref1 != '' && $this->dept_pref1 == $this->dept_pref2) {
            $this->addError('dept_pref2', '<div class="holder"><p>Select a different major preference</p></div>');
        } elseif ($this->dept_pref1 != '' && $this->dept_pref1 == $this->dept_pref3) {
            $this->addError('dept_pref3', '<div class="holder"><p>Select a different major preference</p></div>');
        } elseif ($this->dept_pref2 != '' && $this->dept_pref2 == $this->dept_pref3) {
            $this->addError('dept_pref3', '<div class="holder"><p>Select a different major preference</p></div>');
        }
    }

    public function studentContactInfoValidation($attribute, $params){
        //if($this->can_contact){
            if($this->alternate_phone_contry_code != '' && $this->alternate_phone != ''){
                if(!preg_match("/^[0-9]*$/", $this->alternate_phone_contry_code)){
                    $this->addError('alternate_phone_contry_code', '<div class="holder"><p>Your country code should be number</p></div>');
                }
                if($this->alternate_phone_contry_code < 1){
                    $this->addError('alternate_phone_contry_code', '<div class="holder"><p>Your country code is invalid</p></div>');
                }
                if(!preg_match("/^[0-9]*$/", $this->alternate_phone)){
                    $this->addError($attribute, '<div class="holder"><p>Your phone number should be number</p></div>');
                }
                if(!preg_match("/^[1-9]+[0-9]{5,12}$/", $this->alternate_phone)){
                    $this->addError($attribute, '<div class="holder"><p>Your phone number is invalid</p></div>');
                }
            }elseif($this->alternate_phone_contry_code == ''){
                $this->addError('alternate_phone_contry_code', '<div class="holder"><p>Your country code is required</p></div>');
            }elseif($this->alternate_phone == ''){
                $this->addError($attribute, '<div class="holder"><p>Your phone number is required</p></div>');
            }
        //}


    }

    public function checkContactCountryCode($attribute, $params){
        if($this->parent_phone_country_code == '' && $this->parent_phone != ''){
            $this->addError($attribute, '<div class="holder"><p>Your country code is required</p></div>');
        }
        if( ($this->parent_phone_country_code == '' && $this->parent_phone != '') || ($this->parent_phone_country_code != '' && $this->parent_phone != '')){
            if($this->parent_first_name==''){
                $this->addError('parent_first_name', '<div class="holder"><p>Your parent first name is required</p></div>');
            }
            if($this->parent_last_name == ''){
                $this->addError('parent_last_name', '<div class="holder"><p>Your parent last name is required</p></div>');
            }
            if($this->relation_type == ''){
                $this->addError('relation_type', '<div class="holder"><p>Your relation is required</p></div>');
            }
        }
    }

    public function checkContactCountryCode10(){
        if (trim($_POST['StudentSignup']['alternate_phone_contry_code']) == '') {
            $this->addError('alternate_phone_contry_code', '<div class="holder"><p>Country code is required</p></div>');
        }

        if (trim($_POST['StudentSignup']['alternate_phone']) == '') {
            $this->addError('alternate_phone', '<div class="holder"><p>Phone number is required</p></div>');
        }

        if($this->parent_phone_country_code == '' && $this->parent_phone != ''){
            $this->addError('parent_phone_country_code', '<div class="holder"><p>Country code is required</p></div>');
        }

        if ($this->parent_phone != '') {
            if($this->parent_first_name==''){
                $this->addError('parent_first_name', '<div class="holder"><p>Your parent first name is required</p></div>');
            }

            if(trim($this->parent_first_name)==''){
                $this->addError('parent_first_name', '<div class="holder"><p>Enter valid first name</p></div>');
            }

            if(!preg_match('/^[a-zA-Z][a-zA-Z\s]+$/',$this->parent_first_name)){
                $this->addError('parent_first_name', '<div class="holder"><p>Enter valid first name</p></div>');
            }

            if($this->parent_last_name == ''){
                $this->addError('parent_last_name', '<div class="holder"><p>Your parent last name is required</p></div>');
            }

            if(trim($this->parent_last_name)==''){
                $this->addError('parent_last_name', '<div class="holder"><p>Enter valid last name</p></div>');
            }

            if(!preg_match('/^[a-zA-Z][a-zA-Z\s]+$/',$this->parent_last_name)){
                $this->addError('parent_last_name', '<div class="holder"><p>Enter valid last name</p></div>');
            }
            if($this->relation_type == ''){
                $this->addError('relation_type', '<div class="holder"><p>Your relation is required</p></div>');
            }
        }

        if (trim($this->parent_phone_country_code) != '' && $this->parent_phone != '') {
            if (!preg_match('/^[1-9]+[0-9]{0,12}$/i', $this->parent_phone_country_code)) {
                $this->addError('parent_phone_country_code', '<div class="holder"><p>Country code should contain numbers only</p></div>');
            }
        }

    }

    public function checkParentEmail10($attribute, $params){
        if($this->parent_email != ''){
            if($this->parent_email == $this->username){
                $this->addError($attribute, '<div class="holder"><p>You have already entered same email id</p></div>');
            }
            if($this->parent_first_name==''){
                $this->addError('parent_first_name', '<div class="holder"><p>Your parent first name is required</p></div>');
            }
            if($this->parent_last_name == ''){
                $this->addError('parent_last_name', '<div class="holder"><p>Your parent last name is required</p></div>');
            }
            if($this->relation_type == ''){
                $this->addError('relation_type', '<div class="holder"><p>Your relation is required</p></div>');
            }
        }
    }

    public function checkParentNameAndRelation10($attribute, $params){
        if((trim($this->parent_first_name)=='') && trim($this->parent_last_name) != ''){
            $this->addError('parent_first_name', '<div class="holder"><p>Your parent first name is required</p></div>');
        }
        if((!preg_match('/^[a-zA-Z][a-zA-Z\s]+$/',$this->parent_first_name)) && trim($this->parent_last_name) != ''){
            $this->addError('parent_first_name', '<div class="holder"><p>Enter valid first name</p></div>');
        }
        if(trim($this->parent_first_name)!='' && (trim($this->parent_last_name) == '')){
            $this->addError('parent_last_name', '<div class="holder"><p>Your parent last name is required</p></div>');
        }
        if(trim($this->parent_first_name)!='' && (!preg_match('/^[a-zA-Z][a-zA-Z\s]+$/',$this->parent_last_name))){
            $this->addError('parent_last_name', '<div class="holder"><p>Enter valid last name</p></div>');
        }
        if(trim($this->parent_first_name) !='' && $this->relation_type == '' || trim($this->parent_last_name) !='' && $this->relation_type == ''){
            $this->addError('relation_type', '<div class="holder"><p>Your relation is required</p></div>');
        }
    }

    public function checkParentEmail($attribute, $params){
        if($this->parent_email != ''){
            if($this->parent_email == $this->username){
                $this->addError($attribute, '<div class="holder"><p>Your have already entered same email id</p></div>');
            }
            if($this->parent_first_name==''){
                $this->addError('parent_first_name', '<div class="holder"><p>Your parent first name is required</p></div>');
            }
            if($this->parent_last_name == ''){
                $this->addError('parent_last_name', '<div class="holder"><p>Your parent last name is required</p></div>');
            }
            if($this->relation_type == ''){
                $this->addError('relation_type', '<div class="holder"><p>Your relation is required</p></div>');
            }
        }
    }

    public function checkParentNameAndRelation($attribute, $params){
            if($this->parent_first_name=='' && $this->parent_last_name != ''){
                $this->addError('parent_first_name', '<div class="holder"><p>Your parent first name is required</p></div>');
            }
            if($this->parent_first_name!='' && $this->parent_last_name == ''){
                $this->addError('parent_last_name', '<div class="holder"><p>Your parent last name is required</p></div>');
            }
            if($this->parent_first_name !='' && $this->relation_type == '' || $this->parent_last_name !='' && $this->relation_type == ''){
                $this->addError('relation_type', '<div class="holder"><p>Your relation is required</p></div>');
            }
    }

    public function nameValidation(){
        die('<pre>'.print_r($_POST));
    }



}

?>
