<?php


class StudentSignupB2CMobile extends StudentSignupB2C
{

    public function addError($attribute,$error) {

        parent::addError($attribute, $this->_ce($error));
    }

    public function _ce($error){

        return '<div class="holder"><p>'.$error.'</p></div>';
    }

    public function rules()
    {
        return array(
            array('first_name, last_name, username, password', 'required', 'on' => 'firstPage'),
            array('first_name, last_name', 'match', 'pattern' => '/^[a-zA-Z][a-zA-Z\s]+$/', 'message' => 'No special characters allowed.', 'on' => 'firstPage'),
            array('username', 'unique', 'className' => 'LoginMaster', 'message' => 'Email address already registered. <a href="'.Yii::app()->createUrl('login').'">Sign In</a> to your account', 'on' => 'firstPage'),
            array('username', 'match', 'pattern' => '/^[ a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+\/=?^_`{|}~-]+)*@(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9 ])?$/', 'message' => 'Enter a valid email', 'on' => 'firstPage'),
            array('password', 'length', 'min' => 6, 'max' => 20, 'tooShort' => 'Password should be atleast 6 characters', 'tooLong' =>'Password shouldn\'t be more than 20 characters', 'on' => 'firstPage'),

            array('country, department', 'required', 'on' => 'secondPage','message' => 'Select {attribute}'),
            array('board', 'required', 'on' => 'secondPage','message' => 'Select {attribute}'),
            array('board', 'validateEducation', 'on' => 'secondPage'),
            array('gender', 'required', 'message' => 'Select your gender', 'on' => 'secondPage'),
            array('present_class', 'required', 'message' => 'Select your a current study level', 'on' => 'secondPage'),

            array('phone', 'validatePhone', 'on' => 'thirdPage'),


            array('first_name, last_name, username, password, gender, present_class, country, country_code, department, phone, board, overall_marks, overall_aa, overall_a, overall_b, overall_c, overall_d, overall_points, overall_type, overall_max, overall_marks_gpa', 'safe'),
        );
    }

    public function validatePhone() {

        if (!$this->country_code) {
            $this->addError('country_code', 'Select country code');
        }
        if (!$this->phone) {
            $this->addError('phone', 'Enter mobile number');
            return;
        }


        if ($this->country_code == 91) {/*
            $res = file_get_contents('http://www.bmobile.in/'.$this->phone);
            $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
            $res_arr1 = explode('</tbdy>', $res_arr[1]);

            $count = 0;
            $count = substr_count($res_arr1[0], $this->phone);*/
            if ($this->phone[0] > 6) {

            } else {
                $this->addError('phone', 'Enter a valid phone number');
            }
        }

        if ($this->phone) {
            if (!(int)$this->phone) {
                $this->addError('phone', 'Should contain numbers only');
            }

            if (strlen($this->phone) < 7) {
                $this->addError('phone', 'Enter a valid phone number');
            }
        }
    }

    public function getCountryCodes() {
        $result = TblCountryMaster::model()->findAll('is_active= "Y" AND country_code <> "" ORDER BY country_code ASC ');
        return CHtml::listData($result, 'phone_code', function($country) { return $country->country_name." (+".$country->phone_code.")"; } );
    }
}