<?php

$cs = Yii::app()->clientScript;
$cs->scriptMap['jquery-1.7.1.min.js'] = false;
$cs->scriptMap['jquery-ui.js'] = false;


?>
<section class="section" id="section1">
    <style>
        .colapse .arrow{left: auto; right: 5px; top: 15px;}
        .colapse .row.multi_line.small-gutter{padding-left: 0px !important}
        .colapse.child{cursor: inherit}
        .row.white.link:hover a {color: #83CDF2}
    </style>

    <div class="div-inner-gutter-space relative">
        <div class="row gutter_vertical">
            <div class="clearfix">
                <?php $this->widget('StudentProfileHeader', array('userData' => $this->userData, '_hasEdit' => $this->_hasEdit, '_isDI' => $this->_isDI)); ?>
            </div>
        </div>
        <div class="row gutter_vertical">
            <?php
            if ($this->rbacRole == 'SI' || $this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin') {
                $this->renderPartial('_cssAdvisorNavigation', array('tab' => 'notes', 'profileMonetizationAccess' => $this->profileValidationAccess));
            }
            ?>
        </div>
        <div class="row grid_12 clearfix">
            <div class="grid_3 pull  gutter_vertical">
                <div class="row">
                    <?php $this->widget('BasicInformation', array('userData' => $this->userData, '_hasEdit' => $this->_hasEdit, '_isDI' => $this->_isDI, 'userParams' => $this->userParams, 'profileValidationAccess' => $this->profileValidationAccess)); ?>
                </div>
            </div>

            <div class="grid_9 right no-gutter">
                <div class="multi_line row no-gutter gutter_vertical" id="student-profile">
                    <h4 class="row border-bottom gutter_vertical">Notes <a class="right createNote" href="javascript:void(0);">Create a new note</a></h4>
                    <div class="row visible relative" id="addNotes" style="display: none;">
                        <div class="row visible clearfix gutter_vertical visible relative">
                            <?php echo CHtml::textArea('StudentEditProfile_note', $reminder, array("maxlength" => "500","class"=>"input full-width","rows"=>"8","placeholder"=>"Enter your text here", 'id' => 'StudentEditProfile_note', "onkeyup" => "countChar(this, 500);")); ?>
                            <div class="errorMessage popup" id="error" style="display:none; "><p class="holder">Please enter note.</p></div>
                            <span class="relative normal small" id="charNum">500</span>
                            <span class="color-gray">&nbsp; Characters left</span>

                        </div>
                        <div class="row gutter_vertical center">
                            <?php ?>
                                <button class="button-blue tny small_gutter_r" id="save" type="button" name="save" onClick="addNotes();" value="Save Note">Save Note</button>
                                <button class="button-default tny reset" type="reset" name="cancel" value="Cancel">Cancel</button>
                        </div>
                    </div>
                    <div class="row border-bottom gutter_vertical">
                        <div class="row gray gutter_vertical">
                            <div class="grid_5 pull gutter-left-35"><small>Note</small></div>
                            <div class="grid_2 pull center"><small>Created by</small></div>
                            <div class="grid_2 pull center"><small>Created on</small></div>
                        </div>
                      <?php

                      //print_r($userDataPoints);exit;
                      if($userDataPoints){
                      foreach($userDataPoints as $key => $value) {

                          $notesId = $value['user_data_point_id'];
                          $comment = CHtml::decode($value['comments']);
                          $created = date("M d, Y", strtotime($value['added_on']));
                          $adminName = $value['admin_name'];
                          $addedBy = $value['added_by'];
                          ?>

                          <div class="row white gutter_vertical visible relative clearfix link hover colapse parent" id="firstRow_<?php echo $notesId; ?>">
                              <div class="grid_5 pull gutter-left-35" id="comment1_<?php echo $notesId; ?>"><?php echo strtolower(UniversityHelper::chopString($comment, 50)); ?></div>
                              <div class="grid_2 pull center color-gray"><?php echo $adminName; ?></div>
                              <div class="grid_2 pull center color-gray"><?php echo $created; ?></div>
                              <div class="grid_0 missedContent"><span class="arrow on">&nbsp;</span></div>
                          </div>

                          <div class="row white gutter_vertical relative clearfix hover colapse invisible child" id="fullTextRow_<?php echo $notesId; ?>">
                              <div class="grid_7 pull gutter-left-35">
                                  <div class="row multi_line small-gutter preContent" id="comment2_<?php echo $notesId; ?>"><?php echo $comment; ?></div>
                                  <div class="row multi_line small-gutter editContent invisible">

                                      <textarea class="input full-width" rows="5" maxlength= "500" id="StudentEditProfile_note_<?php echo $notesId; ?>" placeholder="Enter your text here" onkeyup="countCharEdit(<?php echo $notesId; ?>, this, 500);"><?php echo CHtml::decode($comment); ?></textarea>
                                      <div id="error_<?php echo $notesId; ?>" class="errorMessage popup" style="display:none;"><p class="holder">Please enter notes</p></div>
                                      <span class="relative normal small" id="charNum_<?php echo $notesId; ?>"><?php echo 500 - strlen($comment); ?></span>
                                      <span class="color-gray">Charecters left</span>

                                  </div>
                                  <div class="row"><a href="javascript:void(0);" class="gutter-right-35 editLink"  onclick="editNotes(<?php echo $notesId; ?>);">Edit Note</a>
                                      <a href="javascript:void(0);" id="save_<?php echo $notesId; ?>" class="gutter-right-35 saveLink invisible" onclick="saveNotes(<?php echo $notesId; ?>);">Save Note</a>
                                      <a href="javascript:void(0);" class="deleteLink" onclick="DeleteNotes(<?php echo $notesId; ?>);">Delete Note</a>
                                  </div>
                              </div>
                              <div class="grid_2 pull">
                                  <div class="row multi_line small-gutter"><span class="color-gray clearfix">Created by</span><?php echo $adminName; ?></div>
                                  <div class="row multi_line small-gutter"><span class="color-gray clearfix">Created on</span><?php echo $created; ?></div>
                              </div>
                              <div class="grid_0 missedContent"><span class="arrow">&nbsp;</span></div>
                          </div>
                      <?php }
                      } else { ?>

                              <div class="center">
                                  No notes available
                              </div>

                     <?php } ?>

                    </div>

                </div>
            </div>
        </div>

    </div>
</section>

<script>

    $("body").on('focus', 'input, select,textarea',function(){
        $(this).next('div.errorMessage').hide('slow');
    })

    function DeleteNotes(nId){
        var result = confirm("Do you want to delete this note?");
        if (result==true) {
            $('#loading_'+nId).show();
            if(nId) {
                $.ajax({
                    type: 'POST',
                    url: '<?php echo Yii::app()->createUrl('student/profile/deleteNotes'); ?>',
                    data: 'nId='+nId+'&uid=<?php echo $this->userId; ?>',
                    success: function (data){
                        $('#firstRow_'+nId).hide();
                        $('#editRow_'+nId).hide();
                        $('#fullTextRow_'+nId).hide();
                        $('#loading_'+nId).hide();
                        $.notification({class:'error_notify', notification:'NotesDelete'});
                    }
                });
            }
        }
    }

    function saveNotes(nId){
        var $self = $("#save_"+nId);
        var $self_parent = $self.closest('#fullTextRow_'+nId);
        var editContent=$self_parent.find('.editContent');
        var preContent=$self_parent.find('.preContent');

        $self_parent.find('.saveLink').addClass('invisible');
        $self_parent.find('.editLink').removeClass('invisible');
        if(nId) {
            if($.trim($('#StudentEditProfile_note_'+nId).val()) != ''){
                $.ajax({
                    type: 'POST',
                    url: '<?php echo Yii::app()->createUrl('student/profile/editNotes'); ?>',
                    data: 'StudentEditProfile[note]='+encodeURIComponent($('#StudentEditProfile_note_'+nId).val())+'&nId='+nId+'&uid=<?php echo $this->userId; ?>',
                    success: function (data){
                        $('#comment1_'+nId).html(data);
                        $('#comment2_'+nId).html($('#StudentEditProfile_note_'+nId).val());
                        $self_parent.prev().addClass('visible').removeClass('invisible');
                        $self_parent.removeClass('visible').addClass('invisible');
                        $self_parent.find('.preContent').removeClass('invisible');
                        editContent.removeClass('.visible').addClass('invisible');
                        $.notification({class:'success_notify', notification:'NotesUpdate'});
                    }
                });
            } else {
                $('#error_'+nId).show();
                return false;
            }
        }
    }

    function addNotes(){
        if($.trim($('#StudentEditProfile_note').val()) != ''){

            $('#save').removeAttr('onClick');
            $.ajax({
                type: 'POST',
                url: '<?php echo Yii::app()->createUrl('student/profile/addNotes'); ?>',
                data: 'StudentEditProfile[note]='+encodeURIComponent($('#StudentEditProfile_note').val())+'&uid=<?php echo $this->userId; ?>',
                success: function (data){
                    $('#loading').hide();
                    parent.location.reload();

                }
            });
        } else {
            $('#error').show();
            return false;
        }
    }
    function countChar(val, maxLen) {
        var len = val.value.length;
        if (len > maxLen) {
            val.value = val.value.substring(0, maxLen-1);
        } else {
            var value = maxLen - len ;
            $('#charNum').text(value);
        }
    }

    function countCharEdit(nId, val, maxLen) {
        var len = val.value.length;
        if (len > maxLen) {
            val.value = val.value.substring(0, maxLen-1);
        } else {
            $('#charNum_'+nId).text(maxLen - len);
        }
    }

    function enableChild(){
        var $self = $(this);
        $self.next().addClass('visible').removeClass('invisible');
        $self.removeClass('visible').addClass('invisible');
    }
    function disableChild(){
        var $self = $(this);
        var $closest = $self.closest('.child');
        var $editor = $closest.find('.editContent');

        $closest.prev().addClass('visible').removeClass('invisible');
        $closest.removeClass('visible').addClass('invisible');
        $closest.find('.preContent').removeClass('invisible');

        $closest.find('.saveLink').addClass('invisible');
        $closest.find('.editLink').removeClass('invisible');

        $editor.addClass('invisible');
        $editor.find('textarea').val('');
    }
    function createNote(e){
        e.preventDefault();
        $('#addNotes').slideDown('slow');
        $(this).hide();
    }

    function editNotes(e){


        var $self = $(this);

        var $self_parent = $self.closest('.grid_7');
        $self_parent.find('.editContent').removeClass('invisible');
        $self_parent.find('.preContent').addClass('invisible');
        $self_parent.find('.saveLink').removeClass('invisible');
        $self.addClass('invisible');
    }



    function resetFields(e){
        var $self = $('#addNotes');
        $self.slideUp('fast');
        $self.find('textarea').val('');
        $('.createNote').show();
    }

    $('.parent').on('click', enableChild);
    $('.arrow').on('click', disableChild);
    $('.createNote').on('click', createNote);
    $('.editLink').on('click', editNotes);
    $(':reset').on('click', resetFields);

    $('.child').find('.arrow').hover(function(){
            $(this).append(
                '<div class="popup right" style="width: auto; right: 0px;"><div class="holder"><p>Click to Colapse</p></div></div>'
            );
        },
        function(){
            $(this).children().remove();
        }
    );
    $('.parent').find('.arrow').hover(function(){
            $(this).append(
                '<div class="popup right" style="width: auto; right: 0px;"><div class="holder"><p>Click to Expand</p></div></div>'
            );
        },
        function(){
            $(this).children().remove();
        }
    );

</script>

