<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseVendorCentreCourse');

class VendorCentreCourse extends BaseVendorCentreCourse
{
    

    public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('course_name,course_description,course_medium', 'required','message'=>'<div class="holder" >{attribute} can\'t be blank</div>'),
            array('duration_count, duration_hours, currency_ref_id,course_fee', 'numerical', 'integerOnly'=>true,'message'=>'<div class="holder" >{attribute} should be integer</div>'),
            array('vendor_centre_ref_id, course_fee, added_by, modified_by', 'length', 'max'=>10),
            array('course_description','length', 'max' => 1000,'tooLong' => '<div class="holder"><p>{attribute} is too long (maximum is 1000 characters)</p></div>'),
            array('course_name', 'length', 'max'=>255),
            array('duration_type', 'length', 'max'=>5),
            array('course_medium', 'length', 'max'=>16),
            array('is_validated', 'length', 'max'=>1),
            array('course_image, modified_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('vendor_centre_course_id, vendor_centre_ref_id, course_name, duration_count, duration_type, duration_hours, course_fee, currency_ref_id, course_description, course_medium, course_image, is_validated, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
        );
    }

    public function upload_file($attribute, $upload_path){
        
        $uploaded_file = CUploadedFile::getInstance($this,$attribute);
        $upload_path = trim(preg_replace('!/+$!','',  $upload_path));
        if(!is_dir($upload_path)) mkdir($upload_path, 0777, TRUE);
        
        if(!empty($uploaded_file)){
            if(!strlen($this->$attribute)){
                $extension = pathinfo($uploaded_file->name, PATHINFO_EXTENSION);
                $file_name = __CLASS__.'_'.uniqid().'_'.$attribute.'.'.$extension;
                $this->$attribute = $file_name;
            }
            $uploaded_file->saveAs($upload_path.DIRECTORY_SEPARATOR.$this->$attribute, TRUE);
        }
        return true;
    }
    
    
    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('vendor_centre_course_id',$this->vendor_centre_course_id,true);
        $criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
        $criteria->compare('course_name',$this->course_name,true);
        $criteria->compare('duration_count',$this->duration_count);
        $criteria->compare('duration_type',$this->duration_type,true);
        $criteria->compare('duration_hours',$this->duration_hours);
        $criteria->compare('course_fee',$this->course_fee,true);
        $criteria->compare('currency_ref_id',$this->currency_ref_id);
        $criteria->compare('course_description',$this->course_description,true);
        $criteria->compare('course_medium',$this->course_medium,true);
        $criteria->compare('course_image',$this->course_image,true);
        $criteria->compare('is_validated',$this->is_validated,true);
        $criteria->compare('added_by',$this->added_by,true);
        $criteria->compare('added_on',$this->added_on,true);
        $criteria->compare('modified_by',$this->modified_by,true);
        $criteria->compare('modified_on',$this->modified_on,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }


    public function attributeLabels()
    {
        return array(
            'vendor_centre_course_id' => 'Vendor Centre Course',
            'vendor_centre_ref_id' => 'Vendor Centre Ref',
            'course_name' => 'Course Name',
            'duration_count' => 'Duration Count',
            'duration_type' => 'Duration Type',
            'duration_hours' => 'Duration Hours',
            'course_fee' => 'Course Fee',
            'currency_ref_id' => 'Currency Ref',
            'course_description' => 'Course Description',
            'course_medium' => 'Course Medium',
            'course_image' => 'Course Image',
            'is_validated' => 'Is Validated',
            'added_by' => 'Added By',
            'added_on' => 'Added On',
            'modified_by' => 'Modified By',
            'modified_on' => 'Modified On',
        );
    }

    public static function getVendorList($searchTerm, $limit = 20, $status = '') {
        $searchTerm = mysql_escape_string($searchTerm);

        $rawData=Yii::app()->db->createCommand('
SELECT  DISTINCT ll.locality_name, v.vendor_id,v.name ,vc.centre_name,vc.city_ref_id,v.is_active
FROM vendor v
LEFT JOIN vendor_centre vc ON vc.vendor_ref_id = v.vendor_id
LEFT JOIN vendor_centre_course vcc ON vcc.vendor_centre_ref_id = vc.vendor_centre_id
LEFT JOIN vendor_centre_course_test vcct ON vcct.vendor_centre_course_ref_id = vcc.vendor_centre_course_id
LEFT JOIN lookup_locality ll ON ll.locality_id = vc.locality_ref_id
WHERE v.name LIKE "%'.$searchTerm.'%"  AND  v.is_active = '.$status.'
ORDER BY (CASE WHEN v.name LIKE "mahe%" THEN 0 ELSE 1 END ), v.name
')->queryAll();
        return $dataProvider = new CArrayDataProvider($rawData, array(
            'id'=>'vendor',
            //'caseSensitiveSort'=>false,
            'sort'=>array(
                'attributes'=>array(
                    'name',
                ),
            ),
            'pagination'=>array(
                'pageSize'=>$limit,
            ),
        ));
    }



    public static function getCourseList($searchTerm, $limit = 20, $status = '',$centreId) {
        $searchTerm = mysql_escape_string($searchTerm);

        $rawData=Yii::app()->db->createCommand('
                       SELECT course_name,vendor_centre_course_id,duration_count,duration_type,duration_hours,is_validated
                       FROM vendor_centre_course
                        WHERE vendor_centre_ref_id='.$centreId.'')->queryAll();
        return $dataProvider = new CArrayDataProvider($rawData, array(
            'id'=>'vendor',
            //'caseSensitiveSort'=>false,
            'sort'=>array(
                'attributes'=>array(
                    'name',
                ),
            ),
            'pagination'=>array(
                'pageSize'=>$limit,
            ),
        ));
    }

    public static function getCoursesList($searchTerm, $limit = 20, $status = '',$centreId) {
        $searchTerm = mysql_escape_string($searchTerm);

        $rawData=Yii::app()->db->createCommand('
                       SELECT course_name,vendor_centre_course_id,duration_count,duration_type,duration_hours,is_validated
                       FROM vendor_centre_course
                       WHERE vendor_centre_ref_id='.$centreId.'
                       AND course_name LIKE "%'.$searchTerm.'%" 
                       ORDER BY (CASE WHEN course_name LIKE "mahe%" THEN 0 ELSE 1 END ), course_name')->queryAll();
        return $dataProvider = new CArrayDataProvider($rawData, array(
            'id'=>'vendor',
            //'caseSensitiveSort'=>false,
            'sort'=>array(
                'attributes'=>array(
                    'name',
                ),
            ),
            'pagination'=>array(
                'pageSize'=>$limit,
            ),
        ));
    }

    public static function getCoursesListByCityAndTest($test,$department, $limit = 20, $centreId) {

        
        $rawData = Yii::app()->db->createCommand()
                ->select('vcc.*')
                ->from('vendor_centre_course vcc');

        $where = array('AND','vcc.vendor_centre_ref_id=:center_id');
        $params = array(':center_id' => $centreId);
        
        if($test){
            $rawData->join('vendor_centre_course_test vcct', 'vcc.vendor_centre_course_id=vcct.vendor_centre_course_ref_id');
            array_push($where, 'vcct.entrance_ref_id=:test_id');
            $params[':test_id'] = $test;
        }elseif($department){
            $rawData->join('vendor_centre_course_department vccd', 'vcc.vendor_centre_course_id=vccd.vendor_centre_course_ref_id');
            array_push($where, 'vccd.department_ref_id=:dept_id');
            $params[':dept_id'] = $department;
        }
        
        $rawData->where($where, $params);
        
        return $dataProvider = new CArrayDataProvider($rawData->queryAll(), array(
            'id'=>'vendor',
            //'caseSensitiveSort'=>false,
            'sort'=>array(
                'attributes'=>array(
                    'name',
                ),
            ),
            'pagination'=>array(
                'pageSize'=>$limit,
            ),
        ));
    }

    public static function get_courses($vendor_centre_ref_id,$filters = array()){
        if(!self::model()->exists('vendor_centre_ref_id = :id',array(':id' => $vendor_centre_ref_id))) return array();
        
        $criteria = new CDbCriteria();
        
        $with = array(
            'vendorCentreBatches',
            'currencyRef' =>  array('select' => 'currencyRef.html_entity'),
            'vendorCentreCourseAttachments',
            'vendorCentreCourseCountries.countryRef' => array('select' => 'countryRef.country_name'),
            'vendorCentreCourseDepartments.departmentRef' => array('select' => 'departmentRef.department_name'),
            'vendorCentreCourseGrades',
            //'vendorCentreCourseTests.entranceRef' => array('select' => 'entranceRef.entrance_short_name,entranceRef.entrance_full_name','group' => 'entranceRef.entrance_full_name'),
            'vendorCentreCourseTests',
        );
        
        if(isset($filters['sort']) && $filters['sort']['column'] == 'duration'){
            $criteria->select = array('t.*','t.duration_count * (CASE t.duration_type WHEN "Week" THEN 7 WHEN "Month" THEN 30 WHEN "Year" THEN 365 ELSE 1 END)  as duration');
        }
        
        if(isset($filters['sort'])) $criteria->order = $filters['sort']['column'].' '.$filters['sort']['order'];
        
        if(isset($filters['entrance_id'])){
            $criteria->addCondition('vendorCentreCourseTests.entrance_ref_id = '.$filters['entrance_id']);
        }
        
        if(isset($filters['department_ref_id'])) $criteria->addCondition('vendorCentreCourseDepartments.department_ref_id = '.$filters['department_ref_id']);
        
        $criteria->addCondition('t.vendor_centre_ref_id = '.$vendor_centre_ref_id);
        $criteria->with = $with;
        $results = self::model()->findAll($criteria);
        
        $courses = array();
        foreach($results as $key => $r){
            $courses[$key]['Course'] = $r->attributes;
            foreach($r->vendorCentreBatches as $batch){
                if($batch->batch_day_timing && $batch->batch_descrption) $courses[$key]['Batch'][] = $batch->attributes;
            }
            $courses[$key]['Currency'] = $r->currencyRef->attributes;
            $courses[$key]['Attachment'] = array();
            foreach($r->vendorCentreCourseAttachments as $attachment) $courses[$key]['Attachment'][] = $attachment->attributes;
            $courses[$key]['Country'] = array();
            foreach($r->vendorCentreCourseCountries as $country) $courses[$key]['Country'][] = $country->countryRef->attributes;
            $courses[$key]['Department'] = array();
            foreach($r->vendorCentreCourseDepartments as $department) $courses[$key]['Department'][] = $department->departmentRef->attributes;
            $courses[$key]['Grade'] = array();
            foreach($r->vendorCentreCourseGrades as $grade) $courses[$key]['Grade'][] = $grade->attributes;
            
            $courses[$key]['Test'] = array();
            $test_ids = CHtml::listData($r->vendorCentreCourseTests,'entrance_ref_id','entrance_ref_id');
            if($test_ids){
                $command = Yii::app()->db->createCommand()
                        ->select('entrance_short_name,entrance_full_name,entrance_id')
                        ->from(EntranceExam::model()->tableSchema->name)
                        ->group('entrance_full_name')
                        ->where('entrance_id IN ('.implode(",",$test_ids).') AND is_active = 1');
                $courses[$key]['Test'] = $command->queryAll();
            }else{
                $courses[$key]['Test'] = array();
            }
            //foreach($r->vendorCentreCourseTests as $test)  $courses[$key]['Test'][] = $test->entranceRef->attributes;
        }
        
        return $courses;
        
    }
    
    public static function get_price_range($vendor_centre_ref_id){
        
        $result = Yii::app()->db->createCommand()
                ->from(self::model()->tableSchema->name)
                ->select('MIN(course_fee) AS min_fee, MAX(course_fee) AS max_fee')
                ->where('vendor_centre_ref_id = :vendor_centre_ref_id',array(':vendor_centre_ref_id' => $vendor_centre_ref_id))
                ->queryRow();
        return array_merge(array('min_fee' => 0,'max_fee' => 0),$result?$result:array());
    }
    
    
}