<?php

class CheckValidDomain extends CBehavior {

    public  $_validDomainsCache;

    public function attach($owner) {

        $owner->attachEventHandler('onBeginRequest', array($this, 'handleBeginRequest'));

    }

    public function handleBeginRequest($event) {

        $fullUrl = Yii::app()->createAbsoluteUrl(str_replace("app/","",Yii::app()->request->url));
        $subDomain = $this->getSubDomainFromUrl($fullUrl);

        if($subDomain){

            //Yii::app()->setComponents(array('validDomainsCache' => array('class' => 'system.caching.CFileCache', 'cachePath' => Yii::app()->runtimePath . '/subdomains', 'cacheFileSuffix' => '')), false);

            $this->_validDomainsCache = Yii::app()->getComponent('validDomainsCache');
            if(!$validDomains = $this->_validDomainsCache ->get('validDomains'))
                $validDomains = $this->setValidDomains();

            if(!in_array(strtolower($subDomain), $validDomains)){
                //Yii::app()->request->redirect(str_replace($subDomain.'.', '', $fullUrl));
		throw new CHttpException(404);
            }
        }
    }

    public function setValidDomains(){

        $models = TblSiDi::model()->findAll(array(
            'select'=> 'subdomain_slug_name',
            'distinct'=> true,
            'condition' => "css_access='1'"
        ));

        $validDomains = array();
        if($models) {
            foreach($models as $model)
                $validDomains[] = strtolower($model->subdomain_slug_name);
        }
        $this->_validDomainsCache->set('validDomains', $validDomains);
        return $this->_validDomainsCache->get('validDomains');
    }

    public function getSubDomainFromUrl($fullUrl =''){

        $url = str_replace("www.","",parse_url($fullUrl, PHP_URL_HOST));
        $aUrl = explode('.', $url);
        return count($aUrl) > 2 ? $aUrl[0] : false;
    }
}
?>
