<?php

/**
 * Controller is the customized base controller class.
 * All controller classes for this application should extend from this base class.
 */
class Controller extends RController {

    public $hideNavigation = false;
    public $canonicalUrl;
    public $activeLink;
    public $metaKeyword;
    public $metaDesc;
    public $isMobile;

    private function _isMobile() {

        $mobile = Yii::app()->mobileDetect;
        return $this->isMobile = $mobile->isMobile();
    }

    public function getViewFile($viewName) {

        $viewName = parent::getViewFile($viewName);
        if ($this->_isMobile() && preg_match('/\/mobile\//', $viewName) && file_exists($viewName)) {
            Yii::app()->theme = 'mobile';
            $this->layout = '//layouts/mobileLayout';
        } else {
            $viewName = str_replace('mobile' . DIRECTORY_SEPARATOR, '', $viewName);
        }
        return $viewName;
    }

    public function getViewPath() {

        $viewPath = parent::getViewPath();
        $mobilePath = $viewPath . DIRECTORY_SEPARATOR . 'mobile';
        if ($this->_isMobile() && is_dir($mobilePath)) {
            Yii::log('mobile view');
            return $mobilePath;
        }
        return $viewPath;
    }

    /**
     * @var string the default layout for the controller view. Defaults to '//layouts/column1',
     * meaning using a single column layout. See 'protected/views/layouts/column1.php'.
     */
    public function init() {

        if ($this->_isMobile()) {
            //Yii::app()->clientScript->registerCoreScript('jquery', CClientScript::POS_END);
            //Yii::app()->clientScript->registerCssFile(Yii::app()->clientScript->getCoreScriptUrl() . '/jui/css/base/jquery-ui.css');
            //Yii::app()->clientScript->registerCoreScript('jquery.ui');
        } else {
            //$this->_registerGlobalScripts();
            Yii::app()->theme = 'univariety';
            //$this->redirectConfirmationUrl();
        }
    }

    protected function afterRender($view, &$output) {
        parent::afterRender($view, $output);
        //Yii::app()->facebook->addJsCallback($js); // use this if you are registering any $js code you want to run asyc
        //Yii::app()->facebook->initJs($output); // this initializes the Facebook JS SDK on all pages
        //Yii::app()->facebook->renderOGMetaTags(); // this renders the OG tags
        return true;
    }

    public $layout = '//layouts/column1';

    /**
     * @var array context menu items. This property will be assigned to {@link CMenu::items}.
     */
    public $menu = array();

    /**
     * @var array the breadcrumbs of the current page. The value of this property will
     * be assigned to {@link CBreadcrumbs::links}. Please refer to {@link CBreadcrumbs::links}
     * for more details on how to specify this property.
     */
    public $breadcrumbs = array();

    public function filters() {
        return array(
                //'rights',
        );
    }

    //To check the path name.
    public function autoVer($url) {
        $path = pathinfo($url);
        if (!is_file($_SERVER['DOCUMENT_ROOT'] . $url))
            return NULL;
        $ver = '.' . filemtime($_SERVER['DOCUMENT_ROOT'] . $url) . '.';
        //echo $path['dirname'].'/'.str_replace('.', $ver, $path['basename']);
        echo $path['dirname'] . '/' . $path['filename'] . $ver . $path['extension'];
    }

    public function redirectConfirmationUrl() {
        return true;
        $controllerName = Yii::app()->controller->id;
        $actionName = Yii::app()->controller->action->id;
        $moduleName = Yii::app()->controller->module->id;

        if (Yii::app()->session['sUserUnivariety'] != '') {
            $userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
            $result = LoginMaster::getUserDetails($userSession['UserEmail']);

            if (($userSession['isConfirmedEmail'] == 0 && $result['is_email_confirmed'] == 0) && $controllerName != "signup" && $moduleName != "student" && $controllerName != "login" && Yii::app()->controller->id != 'email' && Yii::app()->controller->module->id != 'sms' && empty(Yii::app()->session['signupProcess']) && $controllerName != "confirmation") {
                $this->redirect('/app/student/signup/confirmationEmail');
                exit;
            }
        }
    }

    private function _registerGlobalScripts() {

        if (Yii::app()->request->isAjaxRequest)
            return;

        if ((strtolower(Yii::app()->controller->id) == strtolower('createprofile') && strtolower(Yii::app()->controller->action->id) == 'popupsignup') || (strtolower(Yii::app()->controller->id) == strtolower('login') && strtolower(Yii::app()->controller->action->id) == 'popuplogin')) {
            return;
        }

        // Register jquery, jquery UI js & css files globally
        Yii::app()->clientScript->registerCoreScript('jquery');        // ads plugin
        Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/univariety-ads.js");

        // if(Yii::app()->controller->id != 'home') {
        Yii::app()->clientScript->registerCssFile(Yii::app()->clientScript->getCoreScriptUrl() . '/jui/css/base/jquery-ui.css');
        Yii::app()->clientScript->registerCoreScript('jquery.ui');

        Yii::app()->clientScript->registerScript('ibase_url', 'var ibase_url = "' . Yii::app()->baseUrl . '/";', 0);

        if (Yii::app()->theme == 'uni_avada') {
            Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/themes/uni_avada/views/layouts/css/all.css");
        }
        //Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/themes/uni_avada/views/layouts/js/jquery.isotope.min.js');
        //Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl .'/themes/uni_avada/views/layouts/js/main.js');
        //}
        // Notifications Code Start
        Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/jquery.bar.css");
        Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/jquery.bar.js");

        $notificationsFolder = Yii::app()->basePath . '/messages/' . Yii::app()->language . '/notifications/';
        $notificationFile = Yii::app()->controller->id . 'controller.php';
        if ($moduleName = Yii::app()->controller->module->id)
            $notificationFile = $moduleName . '_' . $notificationFile;

        $controllerNotifications = strtolower($notificationsFolder . $notificationFile);
        $globalNotifications = strtolower($notificationsFolder . 'globalnotifications.php');

        Yii::app()->clientScript->registerScript('UniNotifications', 'var UniNotifications = ' . json_encode(
                        CMap::mergeArray(
                                file_exists($globalNotifications) ? require($globalNotifications) : array('' => ''), file_exists($controllerNotifications) ? require($controllerNotifications) : array('' => '')
                        )
                ) . ';', 0);
        // Notifications Code End
    }

    public function beforeAction() {
        $this->_registerGlobalScripts();
        return true;
    }

    public function afterAction() {
        //echo '<h1 class="center" style="background:red">Page Time '.sprintf('%0.5f',Yii::getLogger()->getExecutionTime()).'</h1>';


        return true;
    }

}
