<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Naresh Revoori
 * Date: 4/3/13
 * Time: 6:04 PM
 * To change this template use File | Settings | File Templates.
 */

// Student Shortlist status Constants
define('SHORTLIST_MIGHTAPPLY', 'MightApply');
define('SHORTLIST_REJECT', 'Reject');
define('SHORTLIST_WILLAPPLY', 'WillApply');
define('SHORTLIST_APPLIED', 'Applied');

class ShortListEngine extends CComponent{

    public $hotLeadEligibleCriteria = array(
        'EMAIL_CONFIRMATION_CHECK' => true,
        'VALID_COUNTRY_CHECK' => true,
        'VALID_DEPT/COURSE_CHECK' => true,
        'OVERALL_12TH_MARKS_CHECK' => false,
        'STUDY_LEVEL_UG_CHECK' => true,
    );

    public $studentId;
    public $studentLoginId;

    public function getShortList($byIntent = ''){

        if($sID = $this->isLoggedIn()){

            $filters = array('user_ref_id' => $sID);
            if($byIntent) $filters['shortlist_status'] = $byIntent;

            $criteria = new CDbCriteria(array('order'=>'t.added_on DESC'));

            $sData = StudentShortlistUniversity::model()->with(array('uniRef'=>array('select'=>'uni_name, country_ref_id, is_active')))->findAllByAttributes($filters, $criteria);
            $shortListData = array();
            if($sData == null) return $shortListData;

            foreach($sData as $objData){
                if ($objData->uniRef->is_active == 'Y') {
                    $shortListData[$objData->uni_ref_id] = array(
                        'intent' => $objData->shortlist_status,
                        'uniName'=> $objData->uniRef->uni_name,
                        'uniCountry'=> $objData->uniRef->country_ref_id,
                        'addedOn' => $objData->added_on,
                        'addedBy' => $objData->added_by,
                        'modifiedOn' => $objData->modified_on,
                        'modifiedBy' => $objData->modified_by,
                    );
                }
            }

            return $shortListData;

        }else{

            return $this->getShortListFromSession($byIntent);
        }
    }

    public function getShortListCountByCountry($byIntent = array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY) ){
        if($sID = $this->isLoggedIn()){
            $byIntent = implode('", "', $byIntent);
            $sData = Yii::app()->db->createCommand()
                            ->select('tum.country_ref_id, country_name,sp.preference_order, COUNT(tum.country_ref_id) as cnt')
                            ->from('student_shortlist_university AS ssu')
                            ->join('tbl_university_master tum', 'tum.uni_id = ssu.uni_ref_id')
                            ->join('tbl_country_master tcm', 'tcm.country_id = tum.country_ref_id')
                            ->join('student_preferred_country sp', 'sp.country_ref_id=tum.country_ref_id')
                            ->where('ssu.user_ref_id=:sID AND shortlist_status IN ("'. $byIntent .'") ', array(':sID'=>$sID))
                            ->group('tum.country_ref_id')
                            ->order('sp.preference_order ASC')
                            ->queryAll();
            
            $shortListData = array();
            if($sData == null) return $shortListData;
			
			$user=TblUserMaster::model()->findByPk($sID);
			$prefCountires = $user->getPreferredCountries();            
				foreach($prefCountires as $key=>$pf){
					foreach($sData as $arrData){
					if($key==$arrData['country_ref_id']) {
						$shortListData[$arrData['country_ref_id']] = array(
							'country_ref_id' => $arrData['country_ref_id'],
							'country_name'=> $arrData['country_name'],
							'count'=> $arrData['cnt'],
							'preference_order'=> $arrData['preference_order'],
						);
					}
				}
            }
				
            return $shortListData;
       }
    }

    public function getShortListUniversityCourses($country_id = 0) {
        $byIntent = array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY);
        if($sID = $this->isLoggedIn()){
            $country_cond = ($country_id > 0) ? " AND tum.country_ref_id = $country_id " : '';
            $byIntent = implode('", "', $byIntent);
            $sData = Yii::app()->db->createCommand()
                ->select('DISTINCT(main_dept_id)')
                ->from('student_shortlist_university AS ssu')
                ->join('tbl_university_master tum', 'tum.uni_id = ssu.uni_ref_id')
                ->join('tbl_uni_courses as  tuc', 'tuc.uni_ref_id = ssu.uni_ref_id')
                ->join('lookup_department as ld', 'ld.department_id = tuc.department_ref_id')
                ->where('user_ref_id=:sID AND shortlist_status IN ("'. $byIntent .'") '.$country_cond, array(':sID'=>$sID))
                ->queryAll();

            $dept_data = $dept_ids = $shortListData = array();
            if($sData == null) return $shortListData;

            foreach($sData as $value) {
                $dept_ids[] = $value['main_dept_id'];
            }

            if (count($dept_ids) > 0) {
                $data = Yii::app()->db->createCommand()
                    ->select('department_id, department_name')
                    ->from('lookup_department')
                    ->where('department_id IN ('.implode(', ', $dept_ids).')')
                    ->queryAll();

                if ($data) {
                    foreach ($data as $value) {
                        $dept_data[$value['department_id']] = $value['department_name'];
                    }
                }
            }

            return $dept_data;
        }
    }
    
    public function getStudentShortList($cId = 0, $dept = 0, $byIntent = array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY) ) {
        if($sID = $this->isLoggedIn()){

            $filters = array('user_ref_id' => $sID);
            $dept_cond = $status_cond = $cid_cond = '';

            if($byIntent) {
                $status_cond = " AND shortlist_status IN ('".implode("','", $byIntent)."') ";
            }

            if ($cId > 0) {
                $cid_cond = " AND tum.country_ref_id = $cId";
            }

            $cdbCriteria = new CDbCriteria();
            $cdbCriteria->select = "DISTINCT(t.uni_ref_id), t.shortlist_status, tum.uni_name, tum.country_ref_id";
            $cdbCriteria->join = "INNER JOIN tbl_university_master as tum ON tum.uni_id = t.uni_ref_id";
            if ($dept > 0) {
                $cdbCriteria->join .= " INNER JOIN tbl_uni_courses as tuc ON tuc.uni_ref_id = t.uni_ref_id";
                $cdbCriteria->join .= " INNER JOIN lookup_department as lp ON lp.department_id = tuc.department_ref_id";

                $dept_cond = " AND lp.main_dept_id = $dept ";
            }
            $cdbCriteria->addCondition("t.user_ref_id = '{$sID}' $cid_cond $status_cond $dept_cond AND tum.is_active = 'Y' ");
            $cdbCriteria->order = " t.added_on DESC ";
            $result = StudentShortlistUniversity::model()->findAll($cdbCriteria);

            foreach($result as $objData){
                $shortListData[$objData->uni_ref_id] = array(
                    'intent' => $objData->shortlist_status,
                    'uniName'=> $objData->uniRef->uni_name,
                    'uniCountry'=> $objData->uniRef->country_ref_id
                );
            }

            return $shortListData;

        }
    }

    public function getShortListByCountry($cId, $byIntent = array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY) ) {
        if($sID = $this->isLoggedIn()){
            $byIntent = implode('", "', $byIntent);
            $sData = Yii::app()->db->createCommand()
                            ->select('student_shortlist_university_id, shortlist_status,tum.state_ref_id,ts.name, uni_ref_id, uni_id, url_primary_key, uni_name, city_name, tum.country_ref_id, country_name')
                            ->from('student_shortlist_university AS ssu')
                            ->join('tbl_university_master tum', 'tum.uni_id = ssu.uni_ref_id')
                            ->join('tbl_country_master tcm', 'tcm.country_id = tum.country_ref_id')
                            ->leftjoin('tbl_state ts','ts.id = tum.state_ref_id')
                            ->leftJoin('tbl_city_master tcitym', 'tum.city_ref_id = tcitym.city_id')
                            ->where('user_ref_id=:sID AND tum.country_ref_id = :cId AND shortlist_status IN ("'. $byIntent .'") ', array(':sID'=>$sID, 'cId' => $cId))
                            ->queryAll();

            $shortListData = array();
            if($sData == null) return $shortListData;
            foreach($sData as $arrData){
                $shortListData[$arrData['student_shortlist_university_id']] = array(
                    'shortlist_status' => $arrData['shortlist_status'],
                    'uni_id' => $arrData['uni_id'],
                    'url_primary_key' => $arrData['url_primary_key'], //This is needed for logo info
                    'uni_name' => $arrData['uni_name'],
                    'country_ref_id' => $arrData['country_ref_id'],
                    'country_name' => $arrData['country_name'],
                    'city_name' => $arrData['city_name'],
                    'name' => $arrData['name'],
                    'state_ref_id' => $arrData['state_ref_id'],
                );
            }
            return $shortListData;
       }
    }
      public function getShortListWithIntakes($byIntent = array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY) ) {
        if($sID = $this->isLoggedIn()){
            $byIntent = implode('", "', $byIntent);
            $sData = Yii::app()->db->createCommand()
                            ->select('student_shortlist_university_id, shortlist_status, ssu.uni_ref_id, uni_name, city_name, country_name,ts.name,udi.no_of_intake,count(university_date_intake_description_id) as deadline')
                            ->from('student_shortlist_university AS ssu')
                            ->join('tbl_university_master tum', 'tum.uni_id = ssu.uni_ref_id')
                            ->join('tbl_country_master tcm', 'tcm.country_id = tum.country_ref_id')
                            ->join('university_date_intake udi', 'ssu.uni_ref_id = udi.uni_ref_id')
                            ->join('university_date_intake_description uds', 'uds.university_date_intake_ref_id = udi.university_date_intake_id')
                            //->join('university_date_label udl', 'udl.university_date_section_ref_id = uds.university_date_section_id')
                            ->leftJoin('tbl_city_master tcitym', 'tum.city_ref_id = tcitym.city_id')
                            ->leftJoin('tbl_state ts', 'tum.state_ref_id = ts.id')
                            ->where('user_ref_id=:sID  AND shortlist_status IN ("'. $byIntent .'") ', array(':sID'=>$sID))
                            ->group('ssu.uni_ref_id')
                            ->order('uni_name')
                            ->queryAll();
            
            $shortListData = array();
            if($sData == null) return $shortListData;

            foreach($sData as $arrData){
                $shortListData[$arrData['student_shortlist_university_id']] = array(
                    'uni_ref_id' => $arrData['uni_ref_id'],
                    'shortlist_status' => $arrData['shortlist_status'],
                    'uni_name' => $arrData['uni_name'],
                    'country_name' => $arrData['country_name'],
                    'city_name' => $arrData['city_name'],
                    'state_name' => $arrData['name'],
                    'no_of_intake' => $arrData['no_of_intake'],
                    'deadline' => $arrData['deadline'],
                );
            }
            return $shortListData;
       }
    }

    
    public function getShortListByUniId($uniID){
        if($sID = $this->isLoggedIn()){			
            if(($model = StudentShortlistUniversity::model()->with('uniRef')->findByAttributes(array(
                'user_ref_id' => $sID, 'uni_ref_id' => $uniID))) !== null){
                $shortListUniData = array(
                    'shortlist_status' => $model->shortlist_status,
                    'uni_id' => $model->uni_ref_id,
                    'url_primary_key' => $model->uniRef->url_primary_key,
                    'uni_name' => $model->uniRef->uni_name,
                    'country_ref_id' => $model->uniRef->country_ref_id,
                    'country_name' => $model->uniRef->countryRef->country_name,
                    'city_name' => $model->uniRef->cityRef->city_name,
                    'state_name' => $model->uniRef->stateRef->name,
                );
                return $shortListUniData;
            }
        } else {
            $aShortList = $this->getShortListFromSession();
            return $aShortList[$uniID];
        }
    }
    
    public function saveToShortList($uniID = 0, $sIntent = SHORTLIST_MIGHTAPPLY){

        if($sID = $this->isLoggedIn()){

            if(($model = StudentShortlistUniversity::model()->findByAttributes(array(
                'user_ref_id' => $sID, 'uni_ref_id' => $uniID))) === null){

                $model = new StudentShortlistUniversity();
                $model->attributes = array(
                    'user_ref_id' => $sID, 'uni_ref_id' => $uniID, 'shortlist_status' => $sIntent,
                    'added_on' => date('Y-m-d H:i:s'), 'added_by' => Yii::app()->session->get('loginID')
                );
            }else{

                $model->attributes = array(
                    'shortlist_status' => $sIntent, 'modified_on' => date('Y-m-d H:i:s'), 'modified_by' => Yii::app()->session->get('loginID')
                );
            }

            $model->save(false);

            if($sIntent != SHORTLIST_REJECT ){
                // share shortlisting on facebook
                //$this->shareShortlistFB($sID, $uniID);
            }
            $this->processHotLeadsEvaluation($uniID);

        }else{

            $aShortList = $this->getShortListFromSession();
            $aShortList[$uniID] = array('intent' => $sIntent);
            $this->setShortListToSession($aShortList);
        }
    }

    private function shareShortlistFB($userID, $uniID){

        $userModel = TblUserMaster::model()->findByPk($userID);
        $fbUser = FbUsers::model()->findByAttributes(array('login_ref_id' => $userModel->login_ref_id));
        if($fbUser){

            $nameSpace  = Yii::app()->params['FBAppNameSpace'];
            $appURL     = Yii::app()->getBaseUrl(true);
            $baseURL    = str_replace('/app', '', $appURL);
            $uniUrl     = $baseURL.UniversityHelper::getUniversityUrl($uniID);
            try{
                $fb = Yii::app()->facebook;
                $fb->setAccessToken($fbUser->fb_access_token);
                $fb->api("me/{$nameSpace}:shortlist", 'post', array( 'university' => $uniUrl, ));

            }catch (FacebookApiException $e) {

            }
        }
    }

    /*public function cancelShortList($uniID = 0, $sIntent = SHORTLIST_REJECT){

        if($sID = $this->isLoggedIn()){
            // perform action in DB
        }else{

            $aShortList = $this->getShortListFromSession();
            unset($aShortList[$uniID]);
            $this->setShortListToSession($aShortList);
        }

    }*/

    static public function isProfileUpdatedIn30Days($userID = 0){

        $userModel = TblUserMaster::model()->find("user_id = '".$userID."' AND modified_on > NOW() - INTERVAL 30 DAY");
        return $userModel ? true : false;
    }

    public function saveProfileLastUpdated(){

        if(!$sID = $this->isLoggedIn()) return;
        $userModel = TblUserMaster::model()->findByPk($sID);
        $userModel->modified_on = new CDbExpression('NOW()');
        $userModel->save(false);
    }

    public function profileUpdated(){

        //$this->processHotLeadsEvaluation();
        if(!$sID = $this->isLoggedIn()) return;

        // profile last updated time storing
        $this->saveProfileLastUpdated();

        // update 12th overall score in percent
        $converter = new OverallMarksConverter;
        $converter->studentID = $sID;
        $converter->updateOverallMarksInPercent();

        // remove from stored admission chance table
        UserUniversityAdmissionScore::model()->deleteAll("user_ref_id = '".$sID."'");

        // remove from criteria match
        //DiUserCriteriaMatch::model()->deleteAll("user_ref_id = '".$sID."'");
    }
	


    public function saveShortListFromSession(){

        if($sID = $this->isLoggedIn()){

            // perform action in DB and clear short list session
            $aShortList = $this->getShortListFromSession();
            if(count($aShortList)){

                foreach($aShortList as $uniID => $sData){
                   $this->saveToShortList($uniID, $sData['intent']);
                }
                $this->processHotLeadsEvaluation();
            }
        }
        $this->clearShortListFromSession();
    }

    private function processHotLeadsEvaluation($shortlistUniId = 0){

        if(!$sID = $this->isLoggedIn()) return;
		
        $aShortList = $this->getShortList();
        foreach($aShortList as $uniID => $aData){
            if($shortlistUniId && $shortlistUniId != $uniID) { continue; } // condition add for logged in user
			
			$EligibilityEngineObj = new StudentEligibilityUpdatesHandlerEngine();
			$EligibilityEngineObj->type = "hotlead";
			$EligibilityEngineObj->studentId 	= $sID;
			$EligibilityEngineObj->universityId = $uniID;
			
			// find this student_university_shortlist in student_hotlead
			/*$model = StudentHotlead::model()->findByAttributes(array('user_ref_id' => $sID, 'uni_ref_id' => $uniID));
			
			// if student_hotlead does not exist
			if($model===null){
				// Insert only if Eligible
				if($EligibilityEngineObj->isValidationFlagsEligible() && $EligibilityEngineObj->isPereferenceEligible())
				{
					$model = new StudentHotlead();
					$model->attributes = array(
						'user_ref_id' => $sID, 'uni_ref_id' => $uniID, 'status' => $aData['intent'],
						'added_on' => date('Y-m-d H:i:s'), 'added_by' => Yii::app()->session->get('loginID')
					);
					$model->save(false);
				} // if Eligible
				
			} else{
			   $model->attributes = array(
					'status' => $aData['intent'], 
					'modified_on' => date('Y-m-d H:i:s'), 
					'modified_by' => Yii::app()->session->get('loginID')
				);
				$model->save(false);
			} */
			
        }//foreach
		
    }

    private function getDepartmentsByUniID($uniID = 0, $level = 'ug'){

        $departments = array();
        $uniDepts = TblUniCourses::getDepartmentListByUniId($uniID, $level);
        if($uniDepts){
            foreach($uniDepts as $Depts)
                $departments[] = $Depts['id'];
        }
        return $departments;
    }

    private function clearShortListFromSession(){

        Yii::app()->session->add('shortListData', array());
    }


    public function isEligibleForHotLeads(){

        //Student email must be confirmed
        //Student has valid country preference(s)
        //Student has valid department/course preference
        //Student overall marks for 12th grade are available
        //Student study level must be UG
        if($sID = $this->isLoggedIn()){
            $this->studentLoginId = $this->studentLoginId ? $this->studentLoginId :Yii::app()->session->get('loginID');
            if($this->hotLeadEligibleCriteria['EMAIL_CONFIRMATION_CHECK']){
                $sData = LoginMaster::model()->exists("login_id = '".$this->studentLoginId."' AND is_email_confirmed = 1 AND is_class_status_confirmed = 1 AND is_preference_confirmed = 1 " );
                if(!$sData) return false;
            }

            if($this->hotLeadEligibleCriteria['VALID_COUNTRY_CHECK']){
                $sData = StudentPreferredCountry::model()->exists("user_ref_id = '{$sID}' AND country_ref_id IS NOT NULL");
                if(!$sData) return false;
            }

            if($this->hotLeadEligibleCriteria['VALID_DEPT/COURSE_CHECK']){
                $sData = StudentPreferredDepartment::model()->exists("user_ref_id = '{$sID}' AND main_dept_ref_id IS NOT NULL");
                if(!$sData) return false;
            }

            if($this->hotLeadEligibleCriteria['OVERALL_12TH_MARKS_CHECK']){
                $sData = StudentEducation::model()->exists("user_ref_id = '{$sID}' AND class_level ='12'");
                if(!$sData) return false;
            }

            if($this->hotLeadEligibleCriteria['STUDY_LEVEL_UG_CHECK']){

                $cdbCriteria = new CDbCriteria();
                $cdbCriteria->join = "INNER JOIN lookup_course_level lcl ON lcl.level_id = t.course_level_ref_id";
                $cdbCriteria->addCondition("t.user_ref_id = '{$sID}' AND (lcl.level_id = '5' OR lcl.parent_ref_id = '5')");
                $result = StudentPreferredStudyLevel::model()->count($cdbCriteria);
                 if(!$result) return false;
            }
            return true;
        }

        return false;
    }

    private function isLoggedIn(){
        if (!isset($_SERVER['SERVER_NAME'])) {
            return $this->studentId;
    
        }

        if(Yii::app()->session->get('user_type_ref_id') == 1) {
        return Yii::app()->session->get('sub_id');
       } elseif ($this->studentId) {
           return $this->studentId;
       }

       return false;
    }

    private function setShortListToSession($aData = array()){

        return Yii::app()->session->add('shortListData', $aData);
    }

    private function getShortListFromSession($byIntent = ''){

        $aData = Yii::app()->session->get('shortListData');
        if($aData && $byIntent){
            foreach($aData as $uniID => $Data){
                if($Data['intent'] != $byIntent)
                    unset($aData[$uniID]);
            }
        }
        return $aData ? $aData : array();
    }
}
