<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Naresh Revoori
 * Date: 4/3/13
 * Time: 6:04 PM
 * To change this template use File | Settings | File Templates.
 */

// Student Shortlist status Constants
define('SHORTLIST_PLANNED', 'Planned');
define('SHORTLIST_REJECT', 'Reject');
define('SHORTLIST_COMPLETED', 'Completed');

class ShortListTestEngine extends CComponent{

    public $hotLeadEligibleCriteria = array(
        'EMAIL_CONFIRMATION_CHECK' => true,
        'VALID_COUNTRY_CHECK' => true,
        'VALID_DEPT/COURSE_CHECK' => true,
        'OVERALL_12TH_MARKS_CHECK' => false,
        'STUDY_LEVEL_UG_CHECK' => true,
    );

    public $studentId;
    public $studentLoginId;

    public function getTestShortList($byIntent = ''){

        if($sID = $this->isLoggedIn()){


            $filters = array('user_ref_id' => $sID);
            if($byIntent) $filters['shortlist_status'] = $byIntent;

            $criteria = new CDbCriteria(array('order'=>'t.added_on DESC'));

            $sData = UserEntranceExam::model()->with(array('entranceExamRef'=>array('select'=>'entrance_full_name, is_active')))->findAllByAttributes($filters, $criteria);
            $shortListData = array();
            if($sData == null) return $shortListData;

            foreach($sData as $objData){
                if ($objData->entranceExamRef->is_active == 1) {
                    $shortListData[$objData->entrance_exam_ref_id] = array(
                        'intent' => $objData->exam_status,
                        'testName'=> $objData->entranceExamRef->entrance_full_name,
                        'shortlist_status'=> $objData->shortlist_status,
                        'addedOn' => $objData->added_on,
                        'addedBy' => $objData->added_by,
                        'modifiedOn' => $objData->modified_on,
                        'modifiedBy' => $objData->modified_by,
                    );
                }
            }

            return $shortListData;

        }else{

            return $this->getShortListFromSession($byIntent);
        }
    }





    public function saveToShortList($testID = 0, $sIntent = false){

        if($sID = $this->isLoggedIn()){

            if(($model = UserEntranceExam::model()->findByAttributes(array(
                'user_ref_id' => $sID, 'entrance_exam_ref_id' => $testID))) === null ){
                $model = new UserEntranceExam();
                $model->attributes = array(
                    'user_ref_id' => $sID, 'entrance_exam_ref_id' => $testID, 'shortlist_status' => $sIntent,
                    'added_on' => date('Y-m-d H:i:s'), 'added_by' => Yii::app()->session->get('loginID')
                );
            }else{
                //echo 'ddd'.$testID.'--'.$sID.'--'.$sIntent;
                $model->attributes = array(
                    'shortlist_status' => $sIntent, 'modified_on' => date('Y-m-d H:i:s'), 'modified_by' => Yii::app()->session->get('loginID')
                );
                //UserEntranceExam::model()->deleteAll(
                    //"user_ref_id = :user_ref_id AND entrance_exam_ref_id = :entrance_exam_ref_id AND exam_year IS NULL",
                   // array(':user_ref_id' => $sID, ':entrance_exam_ref_id' => $testID)
                //);
            }
            $model->save(false);


        }else{

            $aShortList = $this->getShortListFromSession();
            $aShortList[$testID] = array('intent' => $sIntent);
            $this->setShortListToSession($aShortList);
        }
    }



    public function saveShortListFromSession(){

        if($sID = $this->isLoggedIn()){

            // perform action in DB and clear short list session
            $aShortList = $this->getShortListFromSession();
            if(count($aShortList)){

                foreach($aShortList as $testId => $sData){
                    $this->saveToShortList($testId, $sData['intent']);
                }
               // $this->processHotLeadsEvaluation();
            }
        }
        $this->clearShortListFromSession();
    }





    private function clearShortListFromSession(){

        Yii::app()->session->add('shortListTestData', array());
    }



    private function isLoggedIn(){
        if (!isset($_SERVER['SERVER_NAME'])) {
            return $this->studentId;
    
        }

        if(Yii::app()->session->get('user_type_ref_id') == 1) {
        return Yii::app()->session->get('sub_id');
       } elseif ($this->studentId) {
           return $this->studentId;
       }

       return false;
    }

    private function setShortListToSession($aData = array()){

        return Yii::app()->session->add('shortListTestData', $aData);
    }

    private function getShortListFromSession($byIntent = ''){

        $aData = Yii::app()->session->get('shortListTestData');
        if($aData && $byIntent){
            foreach($aData as $testId => $Data){
                if($Data['intent'] != $byIntent)
                    unset($aData[$testId]);
            }
        }
        return $aData ? $aData : array();
    }
}
