<?php
class TextAdServer extends BannerAdServer{

    public $countryID;
    public $departmentID;
    public $searchTerm;
    public $bannerForEntries = array('DASHBOARD_PAGE', 'SEARCH_PAGE', 'COLLEGE_TOOLS' );

    public function __construct($bannerFor = false){

        if($bannerFor && !in_array($bannerFor, $this->bannerForEntries))
            die('Ad Requested for unknown page.');

        $this->bannerFor = $bannerFor;
    }

    public function serveTextAd(){

        // serve only for not logged-in users OR logged-in students
        if(!Yii::app()->user->isGuest && Yii::app()->user->user_type_ref_id != '1')
            return false;

        switch($this->bannerFor){

            case "DASHBOARD_PAGE":
                return $this->serveDashboardPageAd();
                break;

            case "SEARCH_PAGE":
                return $this->serveSearchPageAd();
                break;

            case "COLLEGE_TOOLS":
                return $this->serveToolsPageAd();
                break;
        }
    }

    public function getActiveBannerAccounts($OnlyNotShown = false){

        $OnlyNotShown = $OnlyNotShown ? " AND is_shown='0'" : "";

        $diBannersSql = "SELECT dbc.*, di.uni_ref_id AS di_uni_id, tum.country_ref_id AS di_country_id,
        GROUP_CONCAT(DISTINCT tc.country_ref_id) AS di_target_countries,
        GROUP_CONCAT(DISTINCT td.dept_ref_id) AS di_target_departments,
        GROUP_CONCAT(DISTINCT te.exam_ref_id) AS di_target_tests,
        GROUP_CONCAT(DISTINCT ts.scholorship_ref_id) AS di_target_scholarships,
        GROUP_CONCAT(DISTINCT tkws.keyword) AS di_target_keywords,
        CASE WHEN dbc.campaign_type = 'Clicks' AND dbc.clicks_count < dbc.clicks_limit THEN 'Active'
         WHEN dbc.campaign_type = 'Impressions' AND dbc.impressions_count < dbc.impressions_limit THEN 'Active'
         WHEN dbc.campaign_type = 'Duration' AND CURDATE() BETWEEN dbc.duration_start_date AND
         dbc.duration_end_date THEN 'Active'
         ELSE 'InActive'
        END AS isActiveBanner
        FROM di_banner_campaign dbc
        INNER JOIN di ON di.di_id = dbc.di_ref_id
        INNER JOIN tbl_university_master tum ON tum.uni_id = di.uni_ref_id
        LEFT JOIN di_banner_campaign_target_country tc ON tc.banner_campaign_ref_id = dbc.di_banner_campaign_id
        LEFT JOIN di_banner_campaign_target_department td ON td.banner_campaign_ref_id = dbc.di_banner_campaign_id
        LEFT JOIN di_banner_campaign_target_exam te ON te.banner_campaign_ref_id = dbc.di_banner_campaign_id
        LEFT JOIN di_banner_campaign_target_scholorship ts ON ts.banner_campaign_ref_id = dbc.di_banner_campaign_id
        LEFT JOIN di_banner_campaign_target_keywords tkws ON tkws.banner_campaign_ref_id = dbc.di_banner_campaign_id
        WHERE dbc.is_active ='Y' AND dbc.campaign_ad_type !=1 ".$OnlyNotShown." GROUP BY dbc.di_banner_campaign_id
        HAVING (isActiveBanner) = 'Active'";

        $di_banners = Yii::app()->db->createCommand($diBannersSql)->setFetchMode(PDO::FETCH_OBJ)->queryAll();

        return $di_banners ? $di_banners : false;
    }


    public function getBannerToServe(){

        if(count($this->bannersToServe)){
            $servingBannerID = array_rand($this->bannersToServe);
            $this->updateImpressionORClick($servingBannerID, 3);
            $bannerInfo = $this->bannersToServe[$servingBannerID];
            $bannerInfo->adReferrerUrl = $this->adReferrerUrl;
            return $this->processBannerInfo($bannerInfo);
        }

        return false;
    }


    public function serveToolsPageAd(){

        if(!$this->countryID || !$this->departmentID)
            return false;

        if(!$activeBanners = $this->getActiveBanners())
            return false;

        foreach($activeBanners as $diBanner){

            $this->bannersToServe[$diBanner->di_banner_campaign_id] = $diBanner;
            $targetCountries = $diBanner->di_target_countries ? explode(',', $diBanner->di_target_countries) : array();
            $targetDepartments = $diBanner->di_target_departments ? explode(',', $diBanner->di_target_departments) : array();

            if(!in_array($this->countryID, $targetCountries) || !in_array($this->departmentID, $targetDepartments)){
                $this->unsetFromActiveBanners($diBanner->di_banner_campaign_id);
                continue;
            }
        }

        return $this->getBannerToServe();
    }

    public function serveDashboardPageAd(){

        if(!$sID = $this->isStudentLoggedIn())
            return false;

        if(!$activeBanners = $this->getActiveBanners())
            return false;

        list($prefCountries, $prefDepartments) = $this->getStudentPrefCountriesNDepartments($sID);

        foreach($activeBanners as $diBanner){

            $this->bannersToServe[$diBanner->di_banner_campaign_id] = $diBanner;
            $targetCountries = $diBanner->di_target_countries ? explode(',', $diBanner->di_target_countries) : array();
            $targetDepartments = $diBanner->di_target_departments ? explode(',', $diBanner->di_target_departments) : array();

            if(
                ($targetCountries && !count(array_intersect($targetCountries, $prefCountries)))
                ||
                ($targetDepartments && !count(array_intersect($targetDepartments, $prefDepartments)))
            ){
                // if target countries and depts exist but not matched in student pref.
                $this->unsetFromActiveBanners($diBanner->di_banner_campaign_id);
                continue;
            }
        }

        return $this->getBannerToServe();
    }


    public function serveSearchPageAd(){

        if(!$this->searchTerm)
            return false;

        $this->searchTerm  = strtolower(trim(str_replace("-"," ",$this->searchTerm)));
        if(!$activeBanners = $this->getActiveBanners())
            return false;

        foreach($activeBanners as $diBanner){

            $this->bannersToServe[$diBanner->di_banner_campaign_id] = $diBanner;
            $targetKeywords = $diBanner->di_target_keywords ? explode(',', $diBanner->di_target_keywords) : array();
            $matchFound = false;
            foreach ($targetKeywords as $word) {
                if (strpos($this->searchTerm, strtolower($word)) !== FALSE) {
                    $matchFound =  true;
                }
            }

            if(!$matchFound){
                $this->unsetFromActiveBanners($diBanner->di_banner_campaign_id);
                continue;
            }
        }

        return $this->getBannerToServe();
    }

    public function getStudentPrefCountriesNDepartments($userID = 0){

        $prefCountrySql = "SELECT GROUP_CONCAT(country_ref_id) AS countries FROM student_preferred_country
         WHERE user_ref_id='".$userID."'";
        $prefCountryRes = Yii::app()->db->createCommand($prefCountrySql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
        $prefCountries = $prefCountryRes && $prefCountryRes->countries ? explode(',', $prefCountryRes->countries) : false;

        $prefDeptSql = "SELECT GROUP_CONCAT(main_dept_ref_id) AS depts FROM student_preferred_department
         WHERE user_ref_id='".$userID."'";
        $prefDeptRes = Yii::app()->db->createCommand($prefDeptSql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
        $prefDepartments = $prefDeptRes && $prefDeptRes->depts ? explode(',', $prefDeptRes->depts) : false;

        $prefList =  array($prefCountries, $prefDepartments);
        return $prefList;
    }

    public function processBannerInfo($bannerInfo){

        $hasString  = base64_encode($bannerInfo->di_banner_campaign_id.'$|$'.$bannerInfo->adReferrerUrl);
        $diModel = Di::model()->with('uniRef.cityRef','uniRef.stateRef','uniRef.countryRef')->findByPk($bannerInfo->di_ref_id);
        $uniRef   = $diModel->uniRef;
        $uniCityName = $uniRef->cityRef->city_name;
        $uniStateName = $uniRef->stateRef->name;
        $uniDesc = stripslashes(CHtml::decode($uniRef->uni_profile));

        $uniAddress = array();
        if($uniCityName)
            $uniAddress[] = $uniCityName;
        if($uniStateName)
            $uniAddress[] = $uniStateName;

        $uniAddress[] = $uniRef->countryRef->country_name;

        $shortList = new ShortListEngine();
        $shortListData = $shortList->getShortList();

        return array(
            'ad_link' => Yii::app()->createUrl('di/ecrhandler/tracktextadclick/hash/'.$hasString),
            'ad_text' => $uniRef->uni_name,
            'ad_uni_id' => $uniRef->uni_id,
            'ad_uni_country' => $uniRef->country_ref_id,
            'ad_uni_desc' => (strlen($uniDesc) > 300) ? substr($uniDesc, 0, 300).'..' : $uniDesc,
            'ad_uni_shortlisted' => $shortListData[$uniRef->uni_id] && $shortListData[$uniRef->uni_id]['intent'] != "Reject",
            'ad_address' => implode(', ', $uniAddress),
            'ad_id' => $bannerInfo->di_banner_campaign_id,
        );
    }

}