<?php
/**
 * UmailHelper class file.
 * @author shiva dharana <shiva.dharana@univariety.com>
 * 
 */


/**
 * UmailHelper manages a set of functions which deal with the corresponding umail operations of legacy code.
 * Through these methods, various types umails can be sent/replied, which will invoke corresponding legacy code functions.
 * 
 * @see UserClass
 * @see UmailClass
 * @author shiva dharana <shiva.dharana@univariety.com>
 * @package application.components
 * @version 1.0
 */

class UmailHelper{

    static $_initialized = false;

    // constants for sender/recipient type
    const TYPE_STUDENT = 1;
    const TYPE_ADVISOR = 2;
    const TYPE_DI = 3;
    
    static $db, $dbh;


    /**
     * Method initialises, imports several files, db connections, types etc., of legacy code
     * @return bool
     */
    private static function init(){
        if(self::$_initialized){
            return true;
        }

        $legacyBasePath = realpath(Yii::app()->getBasePath() . '/../..');
        include_once($legacyBasePath . '/include/config.php');
        include_once($legacyBasePath . '/include/functions.php');
        include_once($legacyBasePath . '/classes/exceptionClass.php');
        include_once($legacyBasePath . '/classes/errorClass.php');

        include_once($legacyBasePath . '/classes/UserClass.php');
        include_once($legacyBasePath . '/classes/UmailClass.php');
        
        self::$db = $db;
        self::$dbh = $dbh;
        self::$_initialized = true;
        return true;
    }

    /**
     * Sends a user question as umail to the advisor.
     * @param int $studentId
     * @param string $question Content to be sent as umail body
     * @param int $queryType, Optional, default querytype will be "Others"
     * @return int, message id
     */
    public static function sendQuestion($studentId, $question, $queryType = 0){
    	$subject = 'Student Question';
        return self::sendUmail(self::TYPE_STUDENT, $studentId, self::TYPE_ADVISOR, self::getAdvisor($studentId), $subject, $question, $queryType);
    }

    /**
     * 
     * A generic static method to send umail from Yii code.
     * @param int $senderType
     * @param int $senderId
     * @param int $recipientType
     * @param int $recipientId
     * @param string $subject
     * @param string $mailContent
     * @param int $queryType
     * @return int, message id of the umail.
     */
    public static function sendUmail($senderType, $senderId, $recipientType, $recipientId, $subject, $mailContent, $queryType  = 0){
        self::init();
        // If no query type is passed, choose Others as default.
        if(empty($queryType)){
            $otherQueryType = QueryType::model()->findByAttributes(array('type_name' => 'Others'));
            if($otherQueryType)
            $queryType = $otherQueryType->type_id;
        }
        
        // Worst tweak to make global variables.
        global $db, $dbh;
        $db = self::$db;
        $dbh = self::$dbh;
        

        $ObjUser = new UserClass();
        $ObjUmail = new UmailClass();
        $ObjUmail->umailType = 'compose';

        $ObjUmail->fldSenderType = $senderType;
        $ObjUmail->fldSenderId = $senderId;

        $ObjUmail->fldRecipientType		= $recipientType;
        $ObjUmail->fldRecipientId = $recipientId;

        $ObjUmail->fldMessage	= $mailContent;
        $ObjUmail->fldQueryType	= $queryType;
        $ObjUmail->fldSubject = $subject;

        $ObjUmail->fldSentDate	= date('Y-m-d H:i:s');

        $ObjUmail->fldStatus			= 'New';
        $ObjUmail->fldUniRefId			= '';

        $ObjUmail->fldHeaderId			= $ObjUmail->add_umail_header();
        $ObjUmail->fldMessageId			= $ObjUmail->add_umail_message();

        $ObjUmail->fldActionType		= $ObjUmail->fldStatus;
        $ObjUmail->fldMessageId			= $ObjUmail->add_umail_log();
        return $ObjUmail->fldMessageId;

    }
    
    /**
     * Sends a umail to advisor requesting milestone change
     * @param TblUserMaster $student
     * @param int $milestoneId
     * @return int, messageid
     */
    public static function sendMilestoneChangeRequest($student, $milestoneId){
        
        $url = Yii::app()->createAbsoluteUrl('sms/milestone/Ms' . $milestoneId . 'Helper', array('studentId' => $student->user_id));
        $subject = 'Milestone change request';
        $message = <<<EOT
        <div>
        Hi,
        <p>{$student->first_name} {$student->last_name} has raised request to change milestone {$milestoneId}.
         <a href="{$url}" target="_blank">Click here</a> to take action.
        </p>
        
        <p>
        Regards,<br />
        Univariety.
        </p>
        </di>
EOT;
        return self::sendUmail(self::TYPE_STUDENT, $student->user_id, self::TYPE_ADVISOR, self::getAdvisor($student->user_id), $subject, $message, 0);
    }

    /**
     * returns the advisor/unassigned id of the student's associated institute
     * @param int $studentId
     * @return int, Advisor id or Unassigned admin id
     */
    public static function getAdvisor($studentId){
        $qry = "select t1.advisor_id from si_advisor t1 INNER JOIN (tbl_si_students t2) ON t1.si_id=t2.inst_ref_id INNER JOIN tbl_admin A ON A.admin_id = t1.advisor_id INNER JOIN tbl_admin_role AR ON AR.role_id = A.role_type_id WHERE t2.user_ref_id='".$studentId."' AND t1.is_primary = 'Y' AND A.is_active = 'Y' AND AR.role_name = 'Advisor' LIMIT 1";
        $cmd = Yii::app()->db->createCommand($qry);
        $row = $cmd->queryRow();
        if($row['advisor_id']){
            return $row['advisor_id'];
        }
        $unassigned = TblAdmin::model()->findByAttributes(array('admin_name' => 'Unassigned'));
        return $unassigned->admin_id;
    }
}