<?php

class HomeController extends Controller {

    private $no_cache = false;
    public $cache_life = 18000;

    public function init() {
        parent::init();
    }

    
    public function actionIndex(){
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/layout_review_home2";
        
        $this->pageTitle = 'College Admissions-College Scholarships to Study Abroad | Career Guidance';
        $this->metaKeyword = 'college admissions, college scholarships, scholarships to study abroad, study abroad , career guidance, college scholarship';
        $this->metaDesc = 'College admissions-college scholarships to study abroad or in India.  Get career guidance, admissions, earn college scholarship & get discovered by top colleges of India & abroad!';

        if(ACTUALHOST == 'univariety.com') {
            $PROTOCOL = 'https://';
            $domain = 'www.';
        } else {
            $PROTOCOL = 'http://';
        }
        $this->canonicalUrl = $PROTOCOL . $domain . ACTUALHOST;

        //check if the user is already loggedin
        if (Yii::app()->session->get('loginID')) {
            $this->redirect(Yii::app()->user->redirectUrl);
        }
        
        $this->render('review_home', compact('foo'));
    }
    
    
    public function actionIndexFoo(){
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/layout_review_home2two";
        
        $this->pageTitle = 'College Admissions-College Scholarships to Study Abroad | Career Guidance';
        $this->metaKeyword = 'college admissions, college scholarships, scholarships to study abroad, study abroad , career guidance, college scholarship';
        $this->metaDesc = 'College admissions-college scholarships to study abroad or in India.  Get career guidance, admissions, earn college scholarship & get discovered by top colleges of India & abroad!';

        if(ACTUALHOST == 'univariety.com') {
            $PROTOCOL = 'https://';
            $domain = 'www.';
        } else {
            $PROTOCOL = 'http://';
        }
        $this->canonicalUrl = $PROTOCOL . $domain . ACTUALHOST;

        //check if the user is already loggedin
        if (Yii::app()->session->get('loginID')) {
            $this->redirect(Yii::app()->user->redirectUrl);
        }
        
        $this->render('review_home2', compact('foo'));
    }
    
    public function actionReview() {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/layout_review_home";

        $this->pageTitle = 'College Admissions-College Scholarships to Study Abroad | Career Guidance';
        $this->metaKeyword = 'college admissions, college scholarships, scholarships to study abroad, study abroad , career guidance, college scholarship';
        $this->metaDesc = 'College admissions-college scholarships to study abroad or in India.  Get career guidance, admissions, earn college scholarship & get discovered by top colleges of India & abroad!';

        if (ACTUALHOST == 'univarit.com' || ACTUALHOST == 'univariety.com') {
            $PROTOCOL = 'https://';
            $domain = 'www.';
        } else {
            $PROTOCOL = 'http://';
        }
        $this->canonicalUrl = $PROTOCOL . $domain . ACTUALHOST;

        //check if the user is already loggedin
        if (Yii::app()->session->get('loginID')) {
            $this->redirect(Yii::app()->user->redirectUrl);
        }

        if (!Yii::app()->cache->get('review_count') || $this->no_cache) {
            $sql = "SELECT COUNT(*) AS offer_count
			FROM di_user_eoi_log duel
			LEFT JOIN di_user_eoi due ON due.di_user_eoi_id = duel.di_user_eoi_ref_id
			LEFT JOIN di_student_selection dss ON dss.di_student_selection_id = due.di_student_selection_ref_id
			LEFT JOIN di d ON d.di_id = dss.di_ref_id
			LEFT JOIN tbl_user_master um ON um.user_id = dss.user_ref_id
			WHERE 1=1
			AND um.is_test = 'N'
			AND d.is_test = 'N'";
            $result = Yii::app()->db->createCommand($sql)->queryAll();
            Yii::app()->cache->set('review_count', $result, $this->cache_life);
        } else {
            $result = Yii::app()->cache->get('review_count');
        }


        $this->render('index', compact('result'));
    }

    public function actionUniversityHomepage() {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/universite_home_page";

        //Yii::app()->session['source_page'] = 'University';
        $sql = "SELECT COUNT(*) AS offer_count
                FROM di_user_eoi_log duel
                LEFT JOIN di_user_eoi due ON due.di_user_eoi_id = duel.di_user_eoi_ref_id
                LEFT JOIN di_student_selection dss ON dss.di_student_selection_id = due.di_student_selection_ref_id
                LEFT JOIN di d ON d.di_id = dss.di_ref_id
                LEFT JOIN tbl_user_master um ON um.user_id = dss.user_ref_id
                WHERE 1=1
                AND um.is_test = 'N'
                AND d.is_test = 'N'";
        $result = Yii::app()->db->createCommand($sql)->queryAll();

        $this->render('universite-page', compact('result'));
    }

    //schools-home page//
    public function actionSchoolHomepage() {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/universite_home_page";
        $this->pageTitle = 'College and Career Planning Solutions for Schools - Univariety';
        $this->metaDesc = 'Univariety offers College and Career Planning solutions to Schools which include Profile Review, College Search, Course Search, Test Support and more…';
        $this->metaKeyword = 'Career Counseling, Career planning, Career Counselling, college planning, School Counseling, Student support, college readiness, School Placement, Student counselling, career readiness, School Counselling, Student counseling, School support, College Placement, Admission Guidance, School Guidance, Student Guidance';

        //Yii::app()->session['source_page'] = 'School';
        $sql = "SELECT COUNT(*) AS offer_count
                FROM di_user_eoi_log duel
                LEFT JOIN di_user_eoi due ON due.di_user_eoi_id = duel.di_user_eoi_ref_id
                LEFT JOIN di_student_selection dss ON dss.di_student_selection_id = due.di_student_selection_ref_id
                LEFT JOIN di d ON d.di_id = dss.di_ref_id
                LEFT JOIN tbl_user_master um ON um.user_id = dss.user_ref_id
                WHERE 1=1
                AND um.is_test = 'N'
                AND d.is_test = 'N'";
        $result = Yii::app()->db->createCommand($sql)->queryAll();

        $this->render('School-page', compact('result'));
    }

    //franchise-page
    public function actionFranchisePage() {
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/universite_home_page";

        $this->render('franchise-page');
    }

}
