<?php

class ShortlistCollegesController extends Controller
{
	
   public $layout = "//layouts/inner_page";
    public $breadCrumbIndexes;
    public $admChancesIndexes;
    public $scholarshipChancesIndexes;

   
    public function actionAddToShortList()
    {
        $uniId = Yii::app()->request->getParam('uniId');
        $idealListUniId = Yii::app()->request->getParam('idealListUniId');
        $status = Yii::app()->request->getParam('status');
        $obj = new ShortListEngine();
        $obj->saveToShortList($uniId, $status ? SHORTLIST_MIGHTAPPLY : SHORTLIST_REJECT);

        if(!$idealListUniId) return;
        // Creating log
        $idealListLog = new UserIdealListUniversityLog();
        $idealListLog->user_ideal_list_university_ref_id = $idealListUniId;
        if($status) {
            $idealListLog->action_status = 'Shortlist';
        } else {
            $idealListLog->action_status = 'Reject';
        }
        $idealListLog->added_on = date('Y-m-d H:i:s');
        $idealListLog->added_by = Yii::app()->user->id;
        $idealListLog->save();
    }
	
	
	public function actionIndex()
    {
		if(!Yii::app()->user->isGuest) {
		
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'Ideal List'=>array('/ideallist'),
            'Shortlisted Colleges View',
        );

        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
        $this->pageTitle =  Yii::app()->name .' - Shortlist Colleges';
        $userId = Yii::app()->user->sub_id;

        $country_id = $dept_id = 0;
		
        
        $objShortList = new ShortListEngine();
        //$departments = $objShortList->getShortListUniversityCourses();

        //$shortListCountByCountry = $objShortList->getShortListCountByCountry();
        /*if (!empty($_GET['country']) || !empty($_GET['major'])) {
            $country_id = $_GET['country'];
            $dept_id = $_GET['major'];
            $shortList = $objShortList->getStudentShortList($country_id, $dept_id);
        } else {
           
        }*/
		 $shortList = $objShortList->getShortList(array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY));
		
		//For recommended colleges (Start)
		$limit=6;
		$offset=0;
		$result_count=0;
		$aspirationList=array();
		if (!empty($_POST)) {
			$limit = $_POST['limit'];
			$offset = $_POST['offset'];
		}
		
		$user = TblUserMaster::model()->findByPk($userId);

		if($user->present_class > 10) { // If student full filling all eligibility cirteria
            //$prefCountries = $user->getPreferredCountries();
            //$prefCourses = $user->getPreferredCourses();
			$result_sql=" SELECT tum.uni_id FROM tbl_university_master tum
JOIN di ON di.uni_ref_id = tum.uni_id
JOIN `tbl_uni_courses` tuc ON tuc.uni_ref_id = tum.uni_id
JOIN lookup_department ld ON ld.department_id = tuc.department_ref_id
WHERE ld.main_dept_id IN (SELECT main_dept_ref_id FROM student_preferred_department WHERE user_ref_id = ".$userId.")
AND country_ref_id IN (SELECT country_ref_id FROM student_preferred_country WHERE user_ref_id = ".$userId.")
AND di.di_type_ref_id != 1 AND tum.is_active='Y' AND di.is_test = 'N' AND di.is_active = 1 AND tum.uni_id NOT IN 
(SELECT stdu.uni_ref_id FROM student_shortlist_university stdu WHERE stdu.user_ref_id=".$userId." AND stdu.shortlist_status!='Reject')
GROUP BY uni_id";

			$list= Yii::app()->db->createCommand($result_sql)->queryAll();			
			$result_count=count($list);			
			$aspirationList=$this->getRecomendedData($userId,$limit,$offset);
		}		
		//Recommended collges (End).		
		
        $this->render('shortlist_grid_theme_view', array('shortList'=>$shortList,'aspirationList'=>$aspirationList,'result_count'=>$result_count,'offset'=>$offset));
        //$this->render('shortlist-colleges', array('shortList'=>$shortList,'aspirationList'=>$aspirationList,'result_count'=>$result_count,'offset'=>$offset));
		}
		else {
			 $this->redirect(array('../app/login'));
		}
    }
	
	public function actionLoadmore()
	{
		try{
			//For recommended colleges (Start)
			$limit=6;
			$offset=1;
			if (!empty($_REQUEST)) {
				$limit = $_REQUEST['limit'];
				$offset = $_REQUEST['offset'];
			
			}
			$userId = Yii::app()->user->sub_id;
			$offset = $offset*6;	
			$aspirationList=$this->getRecomendedData($userId,$limit,$offset);
			$this->renderPartial('_loadmore',array('aspirationList'=>$aspirationList));
		}
		catch(Exception $ex)
		{
			echo $ex;
		}		
	}
	
	
	public function getDeptlist($dept)
	{
		try{	
			$where=" main_dept_id IN (".$dept." )";
			$sub_dept_list=0;
			$subdept_list=Yii::app()->db->createCommand()
				->select('department_id')
				->from('lookup_department')
				->where($where)
				->queryAll();
			foreach($subdept_list as $list)
			{
				$subdept_list.=" ,".$list['department_id'];	
			}
			return $subdept_list;
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}
		
	
	public function actionCollegesList()
    {
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        $gender = Yii::app()->getRequest()->getParam('gender', false);
        $val = $this->getUniversityListByTerm($term, 'uni_name', $gender);
        echo CJSON::encode($val);
        Yii::app()->end();
    }
	
	 public function getUniversityListByTerm($term = '', $returnField = 'uni_name', $gender = '')
    {
        $val = array();
        if ($term) {
            $res = TblUniversityMaster::getSuggestionList($term, 0, 10, $gender);
            if ($res) {
                foreach ($res as $r) {					
                    //$val[] = html_entity_decode($r->attributes[$returnField], ENT_QUOTES);
					
					$val[] = array(
                    'label' => html_entity_decode($r->attributes[$returnField], ENT_QUOTES),
                    'value'=> html_entity_decode($r->attributes[$returnField], ENT_QUOTES),
                    'id'=> html_entity_decode($r->attributes['uni_id'], ENT_QUOTES)
					);
					
                    //$val[] = html_entity_decode($r->attributes[$returnField], ENT_QUOTES);
                }
            }
        }
        return $val;
    }
	
	 public function actionShortListRejectOnly()
    {
        $uniId = Yii::app()->request->getParam('uniId');
        $status = Yii::app()->request->getParam('status');
        $uniName = Yii::app()->request->getParam('uniName');       
         $addBySearch = Yii::app()->request->getParam('addBySearch', 0);
		
        $obj = new ShortListEngine();
        
        if(is_numeric($status)) {
            $status = $status ? SHORTLIST_MIGHTAPPLY : SHORTLIST_REJECT;
        }
        
        if($addBySearch) {
            $uniData = $obj->getShortListByUniId($uniId);
            if($uniData === null || $uniData['shortlist_status'] == "Reject"){
                setFlashMessage('success_notify', 'globalnotifications.addedto_shortlist', array('UNI_NAME' => $uniName));
            }else{
				$status=SHORTLIST_REJECT;
                setFlashMessage('error_notify', 'globalnotifications.removefrom_shortlist', array('UNI_NAME' => $uniName));
            }
        }

        $obj->saveToShortList($uniId, $status);
    }

	public function actionGetAjaxdata()
	{
		try{
			if(!Yii::app()->user->isGuest) {
				$userId = Yii::app()->user->sub_id;
				$user = TblUserMaster::model()->findByPk($userId);
				//To get shortListed colleges
				$objShortList = new ShortListEngine();
				$shortList = $objShortList->getShortList(array(SHORTLIST_MIGHTAPPLY, SHORTLIST_APPLIED, SHORTLIST_WILLAPPLY));
				
				//To get Recommended colleges
				$limit=6;
				$offset=0;
				$result_count=0;
				$aspirationList=array();
				if($user->present_class > 10) { // If student full filling all eligibility cirteria							
					$result_sql=" SELECT tum.uni_id FROM tbl_university_master tum
					JOIN di ON di.uni_ref_id = tum.uni_id
					JOIN `tbl_uni_courses` tuc ON tuc.uni_ref_id = tum.uni_id
					JOIN lookup_department ld ON ld.department_id = tuc.department_ref_id
					WHERE ld.main_dept_id IN (SELECT main_dept_ref_id FROM student_preferred_department WHERE user_ref_id = ".$userId.")
					AND country_ref_id IN (SELECT country_ref_id FROM student_preferred_country WHERE user_ref_id = ".$userId.")
					AND di.di_type_ref_id != 1 AND tum.is_active='Y' AND di.is_test = 'N' AND di.is_active = 1 AND tum.uni_id NOT IN 
					(SELECT stdu.uni_ref_id FROM student_shortlist_university stdu WHERE stdu.user_ref_id=".$userId." AND stdu.shortlist_status!='Reject')
					GROUP BY uni_id";
					$list= Yii::app()->db->createCommand($result_sql)->queryAll();			
					$result_count=count($list);
					$aspirationList=$this->getRecomendedData($userId,$limit,$offset);
				}		
			}			
			$this->renderPartial('_load_ajax_data',array('shortList'=>$shortList,'aspirationList'=>$aspirationList,'result_count'=>$result_count,'offset'=>$offset),false,true);
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}
	
	public function getRecomendedData($userId,$limit,$offset, $not_guest_di = true){
		$criteria = new CDbCriteria;
		$criteria->select = 't.uni_id ';        
		$criteria->join = 'Inner JOIN di ON di.uni_ref_id = t.uni_id';
		$criteria->join .= ' Inner JOIN tbl_uni_courses uc ON uc.uni_ref_id=t.uni_id';
		$criteria->join .= ' Inner Join lookup_department ld ON ld.department_id = uc.department_ref_id';
		$criteria->join .= ' Inner Join student_preferred_department spd ON spd.main_dept_ref_id = ld.main_dept_id';
		$criteria->join .= ' Inner Join student_preferred_country spc ON spc.country_ref_id = t.country_ref_id';
		
		$criteria->condition ="spc.user_ref_id = ".$userId." AND spd.user_ref_id =".$userId." 
AND di.is_test = 'N' AND t.is_active='Y' AND di.is_active = 1 AND t.uni_id NOT IN 
(SELECT stdu.uni_ref_id FROM student_shortlist_university stdu WHERE stdu.user_ref_id=".$userId." AND stdu.shortlist_status!='Reject')";
                
                if($not_guest_di) $criteria->condition .= ' AND di.di_type_ref_id != 1 ';
                
		$criteria->limit = $limit;
		$criteria->offset = $offset;			
		$criteria->order = 'spc.preference_order ';
		$criteria->group = ' t.uni_id';
		$aspirationList=TblUniversityMaster::model()->findAll($criteria);
		return $aspirationList;
	}
	
    public function actionGetCollegeList() {

        $cId = Yii::app()->request->getParam('cId');
        $objShortList = new ShortListEngine();
        $universityData = $objShortList->getShortListByCountry($cId);

        $this->renderPartial('_collegeList', array('universityData' => $universityData, 'cId' => $cId, 'intentList' => $this->intentList()));
    }
	
	
    public function actionUniversityPopup() {
        $uniId = Yii::app()->request->getParam('uniId');
        $userId = Yii::app()->user->sub_id;

        $objShortList = new ShortListEngine();
        $universityData = $objShortList->getShortListByUniId($uniId);

        $admChanceDept = $this->getBestAdmissionChance($universityData['country_ref_id'], $uniId, 0);

        $universityDateSections = UniversityDateIntakeDescription::getUniversityDateIntakeNames(0, $universityData['uni_id']);

        $relatedScholarships = ScholarshipHostInstitute::getScholarshipCountByUniId($uniId, '', '', '1');
        $relatedScholarshipIds = $shortlistScholarshipIds = array();
        foreach($relatedScholarships as $relatedScholarship){
            $relatedScholarshipIds[] = $relatedScholarship['scholarship_ref_id'];
        }
        $shortListScholarships = UserScholarship::userAllScholarshipList($userId);
        foreach($shortListScholarships as $shortListScholarship) {
            $shortlistScholarshipIds[] = $shortListScholarship->scholarship_ref_id;
        }
        $noOfMatchedShortlistedScholarship = count(array_intersect($shortlistScholarshipIds, $relatedScholarshipIds));

        $this->renderPartial('_shortlist_university_popup', array('resUniversityDateSections' => $universityDateSections, 'admChanceDept' => $admChanceDept, 'universityData' => $universityData, 'intentList' => $this->intentList(), 'noOfMatchedShortlistedScholarship' => $noOfMatchedShortlistedScholarship));
    }
	
	//It will first save the university name in tbl_university_master and then shortlist the college.
	public function actionnewToShortListOnly()
	{
		try{
			$status = Yii::app()->request->getParam('status');
			$uniName = Yii::app()->request->getParam('uniName');
			$addBySearch = Yii::app()->request->getParam('addBySearch', 0);
			$sql="select uni_id from tbl_university_master where uni_name='".$uniName."' AND  is_user_entered='1' AND added_by =".Yii::app()->user->id." AND is_active='Y' ";
			$new_result=Yii::app()->db->createCommand($sql)->queryRow();
			if(empty($new_result))
			{
				$uni_model=new TblUniversityMaster();
				$uni_model->uni_name=$uniName;
				$uni_model->is_user_entered=1;
				$uni_model->added_on=date('Y-m-d h:i:s');
				$uni_model->added_by=Yii::app()->user->id;
				$uni_model->is_active='Y';
				$uni_model->save(false);
				$uniId=$uni_model->uni_id;
			}
			else {
				$uniId=$new_result['uni_id'];
			}		
						
			$obj = new ShortListEngine();
        
			if(is_numeric($status)) {
				$status = $status ? SHORTLIST_MIGHTAPPLY : SHORTLIST_REJECT;
			}
        
			//if($addBySearch) {
				$uniData = $obj->getShortListByUniId($uniId);
			if(!empty($uniData)){	
				
				if($uniData === null || $uniData['shortlist_status'] == "Reject"){
					$obj->saveToShortList($uniId, $status);					
					 echo json_encode(array('status' => '1'));exit;
				}else{					
					echo json_encode(array('status' => '0'));exit;
				}				
			}
			else{
				$obj->saveToShortList($uniId, $status);
				echo json_encode(array('status' => '1'));exit;
			}
			
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	}
	
	
    public function actionAddToShortListOnly()
    {
        $uniId = Yii::app()->request->getParam('uniId');
		
        $status = Yii::app()->request->getParam('status');
        $uniName = Yii::app()->request->getParam('uniName');
        $addBySearch = Yii::app()->request->getParam('addBySearch', 0);
        
		
        $obj = new ShortListEngine();
        
        if(is_numeric($status)) {
            $status = $status ? SHORTLIST_MIGHTAPPLY : SHORTLIST_REJECT;
        }
         
            $uniData = $obj->getShortListByUniId($uniId);
		if(!empty($uniData)){	
            if($uniData === null || $uniData['shortlist_status'] == "Reject"){
                //setFlashMessage('success_notify', 'globalnotifications.addedto_shortlist', array('UNI_NAME' => $uniName));
				$obj->saveToShortList($uniId, $status);	
				echo json_encode(array('status' => '1'));exit;
            }else{
               // setFlashMessage('info_notify', 'globalnotifications.already_exist_shortlist', array('UNI_NAME' => $uniName));
			   echo json_encode(array('status' => '0'));exit;
            }
        }
		else{
			$obj->saveToShortList($uniId, $status);		
			echo json_encode(array('status' => '1'));exit;
		}
    }
	
}