<?php

/*
 * @author Asif Ali M
 * @package application.models
 *
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseEntranceExamApplicable');

class EntranceExamApplicable extends BaseEntranceExamApplicable
{
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    
	/**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
			'entranceExam' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_ref_id'),
        );
    }
    
    /**
     * 
     * @param string $searchTerm
     * @param int $mainDepartmentId, Optional default 0
     * @param int $subDepartmentId, Optional default 0
     * @param int $limit, Optional default 10
     * @param array $exclude, array of primary keys to be excluded from the result set.
     * @return array
     */
    public static function getEntranceExamSuggestionListForDepartment($searchTerm, $mainDepartmentId = 0, $subDepartmentId = 0, $limit = 10, $exclude = array()){
        
        // Get main department if not given
        if(empty($mainDepartmentId) && $subDepartmentId > 0){
            $department = LookupDepartment::model()->findByPk($subDepartmentId);
            if($department){
                $mainDepartmentId = $department->main_dept_id;
            }
        }
        
        $criteria = new CDbCriteria;
        $criteria->alias = 'eea';
        
        // avoid duplicate, null, 0 values
        $exclude = array_flip($exclude);
        unset($exclude[0]);
        unset($exclude['']);
        $exclude = array_flip($exclude);
        
        if(count($exclude) > 0){
            $criteria->condition = 'eea.entrance_ref_id NOT IN (' . implode(', ', $exclude). ')';
        }
        $criteria->join = 'JOIN entrance_exam as ee on eea.entrance_ref_id = ee.entrance_id';
        
        //Search for the term
        if($searchTerm){
            $tCriteria = new CDbCriteria;
            $tCriteria->compare('ee.entrance_short_name', $searchTerm, true);
            $tCriteria->compare('ee.entrance_full_name', $searchTerm, true, 'OR');
        }
        $criteria->mergeWith($tCriteria);
        
        // match sub department or main department
        $tCriteria = new CDbCriteria;
        $tCriteria->compare('eea.main_dept_ref_id', $mainDepartmentId);
        if($subDepartmentId > 0){
            $tCriteria->compare('eea.sub_dept_ref_id', $subDepartmentId, false, 'OR');
        }
        $criteria->mergeWith($tCriteria);
        
        $criteria->group = 'eea.entrance_ref_id';
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN ee.entrance_short_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), ee.entrance_short_name";
        $criteria->limit = $limit;
        //self::model()->count();
        return self::model()->findAll($criteria);
    }
}