<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

/* echo "chaityanya";
 * 
 * echo "KUmari";
 */

Yii::import('application.models.base.BaseEntranceExamApplicableDepartment');

class EntranceExamApplicableDepartment extends BaseEntranceExamApplicableDepartment {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function hasDepartment($scholarshipId, $courseId, $deptId = 0, $subDeptId = 0) {
        $criteria = new CDbCriteria;
        //$criteria->compare('course_level_ref_id', $courseId);
        $criteria->compare('entrance_exam_ref_id', $scholarshipId);
        if ($deptId)
            $criteria->compare('main_department_ref_id', $deptId);
        if ($subDeptId)
            $criteria->compare('sub_department_ref_id', $subDeptId);
        $count = self::model()->count($criteria);
        return $count > 0 ? true : false;
    }

    public static function hasDepartmentCount($scholarshipId, $courseId, $deptId = 0, $subDeptId = 0) {
        $criteria = new CDbCriteria;
        //$criteria->compare('course_level_ref_id', $courseId);
        $criteria->compare('entrance_exam_ref_id', $scholarshipId);
        if ($deptId)
            $criteria->compare('main_department_ref_id', $deptId);
        if ($subDeptId)
            $criteria->compare('sub_department_ref_id', $subDeptId);
        $count = self::model()->count($criteria);
        return $count;
    }

    public function search($scholarshipId, $courseId, $deptId = 0, $subDeptId = 0) {
        $criteria = new CDbCriteria;
        //$criteria->compare('course_level_ref_id', $courseId);
        $criteria->compare('entrance_exam_ref_id', $scholarshipId);
        if ($deptId)
            $criteria->compare('main_department_ref_id', $deptId);
        if ($subDeptId)
            $criteria->compare('sub_department_ref_id', $subDeptId);
        $res = self::model()->find($criteria);
        return $res['entrance_applicable_department_id'];
    }

    public static function getDepartmentByTestId($id, $onlyId = 0, $concatSym = " / ") {

        $data = $modeArr = array();
        $criteria = new CDbCriteria();
        $criteria->select = 'main_department_ref_id';
        $criteria->with = array("mainDepartmentRef", array('select' => 'department_name'));
        $criteria->distinct = true;
        $criteria->condition = "entrance_exam_ref_id=:id";
        $criteria->params = array(':id' => $id);
        $criteria->order = 'department_name';

        $data = self::model()->findAll($criteria);
        if (!$onlyId) {
            foreach ($data as $key => $value) {
                $modeArr[] = $value['mainDepartmentRef']['department_name'];
            }
        } else {
            foreach ($data as $key => $value) {
                $modeArr[] = $value['main_department_ref_id'];
            }
        }
        $modeArr = array_unique($modeArr);
        //$mode = implode($concatSym, $modeArr);

        return $modeArr;
    }


    public static function getEntranceExamSuggestionListForDepartment($searchTerm, $mainDepartmentId = 0, $subDepartmentId = 0, $limit = 10, $exclude = array()){

        if(empty($mainDepartmentId) && $subDepartmentId > 0){
            $subDepartmentIds = explode(',', $subDepartmentId);
            foreach ($subDepartmentIds as $id) {
                $department = LookupDepartment::model()->findByPk($id);
                if($department){
                    $mainDepartmentIds[] = $department->main_dept_id;
                }
            }
        } else {
            $mainDepartmentIds = explode(',', $mainDepartmentId);
            $subDepartmentIds = explode(',', $subDepartmentId);
        }

        $condition = ' t.main_department_ref_id in ('.implode(',', $mainDepartmentIds).') ';

        if($subDepartmentId > 0){
            $condition .= ' and t.sub_department_ref_id in ('.implode(',', $subDepartmentIds).') ';
        }

        if (count($exclude) > 0) {
            $condition .= ' and entranceExamRef.entrance_id NOT IN (' . implode(', ', $exclude). ')';
        }

        $data = self::model()->with('entranceExamRef')->findAll($condition.' and (entranceExamRef.entrance_short_name like "%'.$searchTerm.'%" OR  entranceExamRef.entrance_short_name like "%'.$searchTerm.'%") ');
        $return = array();
        foreach($data as $dataPart) {
            $op = array(
                'id' => $dataPart->entranceExamRef->entrance_id,
                'value' => $dataPart->entranceExamRef->entrance_short_name,
                'fullName' => $dataPart->entranceExamRef->entrance_full_name,
            );
            $return[$dataPart->entranceExamRef->entrance_id] = $op;
        }

        return array_values($return);
    }

    public static function getDepartmentsForExam($country_id, $exam_id, $course_ids){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = 'DISTINCT (t.main_department_ref_id)';
        $cdbCriteria->join = "JOIN entrance_exam ee ON ee.entrance_id = t.entrance_exam_ref_id
        JOIN entrance_exam_applicable_location eeal ON eeal.entrance_exam_ref_id = t.entrance_exam_ref_id";
        $cdbCriteria->addCondition("eeal.country_ref_id = ".$country_id." ", "AND");
        $cdbCriteria->addCondition("t.entrance_exam_ref_id = ".$exam_id." ", "AND");
        $cdbCriteria->addCondition("t.main_department_ref_id IN (".implode(',', $course_ids).") ", "AND");

        //$cdbCriteria->addCondition("t.is_active = 1", "AND");

        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

}