<?php

/**
 * This is the model class for table "lookup_board_equivalent".
 *
 * The followings are the available columns in table 'lookup_board_equivalent':
 * @property integer $board_equivalent_id
 * @property string $class_level
 * @property string $board_name
 * @property integer $board_ref_id
 * @property string $overall_type
 * @property integer $overall_max
 * @property integer $subject_max
 *
 * The followings are the available model relations:
 * @property CourseEligibility[] $courseEligibilities
 * @property CutoffOverallGrades[] $cutoffOverallGrades
 * @property CutoffOverallMarks[] $cutoffOverallMarks
 * @property CutoffSubjectGrades[] $cutoffSubjectGrades
 * @property CutoffSubjectMapping[] $cutoffSubjectMappings
 * @property CutoffSubjectMarks[] $cutoffSubjectMarks
 * @property DiSearch[] $diSearches
 * @property LookupBoard $boardRef
 * @property LookupStudentSubject[] $lookupStudentSubjects
 * @property MdmNewCourseEligibility[] $mdmNewCourseEligibilities
 * @property StudentEducation[] $studentEducations
 */
class LookupBoardEquivalent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupBoardEquivalent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_board_equivalent';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
            		array('board_ref_id, overall_max, subject_max', 'numerical', 'integerOnly'=>true),
			array('class_level', 'length', 'max'=>2),
			array('board_name', 'length', 'max'=>45),
            		array('overall_type', 'length', 'max'=>6),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
            		array('board_equivalent_id, class_level, board_name, board_ref_id, overall_type, overall_max, subject_max', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            		'courseEligibilities' => array(self::HAS_MANY, 'CourseEligibility', 'board_equivalent_ref_id'),
			'cutoffOverallGrades' => array(self::HAS_MANY, 'CutoffOverallGrades', 'board_ref_id'),
			'cutoffOverallMarks' => array(self::HAS_MANY, 'CutoffOverallMarks', 'board_ref_id'),
			'cutoffSubjectGrades' => array(self::HAS_MANY, 'CutoffSubjectGrades', 'board_ref_id'),
			'cutoffSubjectMappings' => array(self::HAS_MANY, 'CutoffSubjectMapping', 'board_ref_id'),
			'cutoffSubjectMarks' => array(self::HAS_MANY, 'CutoffSubjectMarks', 'board_ref_id'),
			'diSearches' => array(self::HAS_MANY, 'DiSearch', 'board_ref_id'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
            		'lookupStudentSubjects' => array(self::HAS_MANY, 'LookupStudentSubject', 'board_ref_id'),
            		'mdmNewCourseEligibilities' => array(self::HAS_MANY, 'MdmNewCourseEligibility', 'board_equivalent_ref_id'),
            		'studentEducations' => array(self::HAS_MANY, 'StudentEducation', 'board_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'board_equivalent_id' => 'Board Equivalent',
			'class_level' => 'Class Level',
			'board_name' => 'Board Name',
			'board_ref_id' => 'Board Ref',
			'overall_type' => 'Overall Type',
			'overall_max' => 'Overall Max',
			'subject_max' => 'Subject Max',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('board_equivalent_id',$this->board_equivalent_id);
		$criteria->compare('class_level',$this->class_level,true);
		$criteria->compare('board_name',$this->board_name,true);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('overall_type',$this->overall_type,true);
		$criteria->compare('overall_max',$this->overall_max);
		$criteria->compare('subject_max',$this->subject_max);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
   public static function GetSchoolBoardEquivalentId($class,$board)
   {
    $result = self::model()->find('class_level=:class AND board_ref_id=:boardRefId', array(':class' => $class,':boardRefId' => $board));
	if($result)
	{
	  return $result;
	}
	else
	{
	  return false;	
	}
  }

    public static function GetSchoolBoardList($class)
    {
         $sql ="SELECT board_equivalent_id, lb.board_desc FROM lookup_board_equivalent t
                    INNER JOIN lookup_board lb ON lb.board_id = t.board_ref_id
                    WHERE t.class_level = '".$class."' ORDER BY lb.board_desc";
        $command =Yii::app()->db->createCommand($sql);
       // $command->bindValue(":class", $class, PDO::PARAM_INT);
        $res =$command->queryAll();
        return $res;
    }

    public static function GetBoardDetails($class=0, $board=0){
        $result = self::model()->find(array("condition" => "class_level = '$class' AND board_equivalent_id = '$board'"));
        return $result->attributes;
    }

    public static function GetBoardDetail($class=0, $board_ref_id=0){
        $result = self::model()->find(array("condition" => "class_level = '$class' AND board_ref_id = '$board_ref_id'"));
        return $result->attributes;
    }

    public static function getBoardDetailById($board){
        $result = self::model()->find(array("condition" => "board_equivalent_id = '$board'"));
        return $result->attributes;
    }
    
    public static function getBoardByClassLevel($class) {
        $criteria = new CDbCriteria;
        $criteria->select = 'board_equivalent_id, board_name, board_ref_id';
        $criteria->condition = "class_level = '". $class ."' ";
        $criteria->order = " boardRef.board_desc asc ";
        $boardsList = self::model()->with('boardRef')->findAll($criteria);
        return $boardsList;
    }

    public static function getBoardCategoryByClass($class, $isMainBoard = false, $isInternational = false) {
        /***
         * This function return All boards by category
         * If pass second param as true then it returns all main boards or else it returns equivalent boards
         * If User country india it returns category wise boards
         */
        $criteria = new CDbCriteria;
        if(Yii::app()->user->visitorCountry == 100 || $isInternational == false)
        {
            $criteria->condition = "class_level = '". $class ."' AND board_id != 3";
            $criteria->order = " boardRef.board_category,t.board_name asc ";
            $boards = self::model()->with('boardRef')->findAll($criteria);
            $boardList = array();
            foreach($boards as $board) {
                $boardList[$board->boardRef->board_category][$isMainBoard ? $board->boardRef->board_id : $board->board_equivalent_id] = $board->board_name;
            }
            // For Getting State board last
            $criteria->condition = "class_level = '". $class ."' AND  board_id = 3";
            $criteria->order = " boardRef.board_category,t.board_name asc ";
            $boards = self::model()->with('boardRef')->findAll($criteria);
            foreach($boards as $board) {
                $boardList[$board->boardRef->board_category][$isMainBoard ? $board->boardRef->board_id : $board->board_equivalent_id] = $board->board_name; //$board->boardRef->board_desc
            }
        }
        else
        {
            $criteria->condition = "class_level = '". $class ."' AND board_category = 'International' ";
            $criteria->order = " boardRef.board_category,t.board_name asc ";
            $boards = self::model()->with('boardRef')->findAll($criteria);
            $boardList = array();
            foreach($boards as $board) {
                $boardList[$isMainBoard ? $board->boardRef->board_id : $board->board_equivalent_id] = $board->board_name;
            }
        }
        return $boardList;
    }
}