<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseLookupCareer');

class LookupCareer extends BaseLookupCareer
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
    public function rules(){
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('career_name', 'required', 'on' => 'search'),
//            array('seo_keyword', 'match', 'pattern' => '/^([a-zA-Z])+$/', 'message' => 'Only alphabets is allowed.', 'on' => 'Basic'),
        );
    } 
    
    public static function getCareerListAuto($searchTerm, $limit = 10, $isActive = 0){
        $criteria = new CDbCriteria;
        $criteria->alias = 'c';
        $criteria->compare('c.career_name', $searchTerm, true);
        $criteria->group = 'c.career_id';
        $searchTerm = mysql_escape_string($searchTerm);
        if($isActive) {
            $criteria->condition = "is_active = 1";
        }
        $criteria->order = "(CASE WHEN c.career_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), c.career_name";
        $criteria->limit = $limit;
        return self::model()->findAll($criteria);
    }
    
    public static function getCareerId($careerName){
        $criteria = new CDbCriteria;
        $criteria->select = "career_id";
        $criteria->condition = "career_name = '".$careerName."'";
        $CareerData = self::model()->find($criteria);
        return $CareerData->attributes['career_id'];
    }
    
    public function getUniqueUrlPrimarykey($var1, $var2) {
         static $count = 0;
         $gereratedKey = hash('crc32b', $var1 . $var2);
         $rowData = self::model()->find('url_primary_key ="' . $gereratedKey . '"');
         $count++;
         if (!count($rowData)) {
             return $gereratedKey;
         } else {
             echo $var2 = $var2 . $count;
             return $this->getUniqueUrlPrimarykey($var1, $var2);
         }
     } 
     
    public static function getCareerIdFromHash($hashCareerId){
        $criteria = new CDbCriteria();
        $criteria->select = 'career_id, url_primary_key, career_name, is_active, main_dept_ref_id, banner_name, seo_keyword, career_intro';
        $criteria->condition = "url_primary_key=:id";
        $criteria->params = array(':id' => $hashCareerId);

        $data = self::model()->with('mainDeptRef')->find($criteria);
        $careerData['career_id'] = $data->career_id;
        $careerData['url_primary_key'] = $data->url_primary_key;
        $careerData['dept'] = $data->main_dept_ref_id;
        $careerData['dept_name'] = $data->mainDeptRef->department_name;
        $careerData['career_name'] = $data->career_name;
        $careerData['banner_name'] = $data->banner_name;
        $careerData['is_active'] = $data->is_active;
        $careerData['seo_keyword'] = $data->seo_keyword;
        $careerData['career_intro'] = $data->career_intro;

        return $careerData;
    }
    
     public static function getCareerUrlData($careerId, $byCareerHash = 0){
         
        $criteria = new CDbCriteria();
        $criteria->select = 'career_id, url_primary_key, career_name, seo_keyword';
        $criteria->with = array('mainDeptRef' => array('select' => array('department_name') ) );
         
        if($byCareerHash) {
            $criteria->condition = "url_primary_key=:id";
            $criteria->params = array(':id' => $careerId);
        } else {
            $criteria->condition = "career_id=:id";
            $criteria->params = array(':id' => $careerId);
        }

        $data = self::model()->find($criteria);

        $careerUrlData['career_id'] = $data->career_id;
        $careerUrlData['url_primary_key'] = $data->url_primary_key;
        $careerUrlData['dept'] = $data->mainDeptRef->department_name;
        $careerUrlData['career_name'] = $data->career_name;
        $careerUrlData['keyword'] = $data->seo_keyword;
        return $careerUrlData;
    }
    
    
    public function getCareetDeptName($cid){
        try{
            $name="";
            $sql='SELECT ld.dept_alias AS department_name  FROM lookup_department AS ld
                INNER JOIN `lookup_career` AS lc ON lc.main_dept_ref_id=ld.department_id
                WHERE career_id='.$cid;
            $res=Yii::app()->db->createCommand($sql)->queryRow();
            if(!empty($res))
            {
                $name="(".$res['department_name'].")"; 
            }
            return $name;
        } catch (Exception $ex) {
            echo $ex;
        }
    }
    /**
    * Retrieves a list of models based on the current search/filter conditions.
    * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
    */
    public function customSearch()
    {
           // Warning: Please modify the following code to remove attributes that
           // should not be searched.

           $criteria=new CDbCriteria;
           $criteria->compare('career_name',$this->career_name,true);
           
           return new CActiveDataProvider($this, array(
                   'criteria'=>$criteria,
                    'pagination'=>array(
                                'pageSize'=>25,
                            ),
           ));
    } 
    
    public static function getCareerList(){
        /*$criteria = new CDbCriteria;
        $criteria->select = 'career_id, career_name';
        $criteria->condition = "is_active = 1 ";
        $criteria->order = " career_name asc ";*/
        $criteria = new CDbCriteria;
        $criteria->select = 't.career_id, t.career_name';
        $criteria->join = " LEFT JOIN `career_country` cc ON cc.career_ref_id = t.career_id ";
        $criteria->condition = "is_active = 1 AND (cc.country_ref_id = '".Yii::app()->user->visitorCountry."' OR cc.country_ref_id IS NULL)";
        $criteria->group = "t.career_name";
        $criteria->order = "t.career_name ASC";

        $careers = LookupCareer::model()->findAll($criteria);
        $careerList = array();
        foreach ($careers as $career) {
            $careerList[$career->career_id] = $career->career_name;
        }
        return $careerList;
    }

    public static function getCareerListByIP($limit=0,$offset=0,$deptid=0){
        $dt="";
        if($deptid!=0 && $deptid !='NULL'){            
            $dept_values= explode(",",$deptid);  
            if(in_array('NULL',$dept_values)){
                $dt=" AND (t.main_dept_ref_id IN (".$deptid.") OR  t.main_dept_ref_id IS NULL) ";
            }
            else{
                $dt=" AND t.main_dept_ref_id IN (".$deptid.") ";
            }
        }
        else if($deptid ==='NULL')
        {            
            $dt=" AND  t.main_dept_ref_id IS NULL ";
        }
        $sqlSelect = "SELECT career_id, career_name,page_thumbnail,career_intro,main_dept_ref_id FROM lookup_career t
                    LEFT JOIN `career_country` cc ON cc.career_ref_id = t.career_id
                    WHERE is_active = 1 AND is_career_page = 1 AND (cc.country_ref_id IS NULL)".$dt." 
                    AND career_name NOT IN (
                    SELECT career_name FROM lookup_career t
                    LEFT JOIN `career_country` cc ON cc.career_ref_id = t.career_id
                    WHERE is_active = 1 AND is_career_page = 1 AND (cc.country_ref_id = '".Yii::app()->user->visitorCountry."')".$dt." 
                    )
                    UNION
                    SELECT career_id, career_name,page_thumbnail,career_intro,main_dept_ref_id FROM lookup_career t
                    LEFT JOIN `career_country` cc ON cc.career_ref_id = t.career_id
                    WHERE is_active = 1 AND is_career_page = 1 AND (cc.country_ref_id = '".Yii::app()->user->visitorCountry."')".$dt;
        
        $sqlSelect.=" ORDER BY main_dept_ref_id ";
        if($limit > 0) {
            $sqlSelect.=" limit ".$limit;
        }
        if($offset > 0) {
            $sqlSelect.=" offset ".$offset;
        }
       //echo $sqlSelect; exit;
        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();
        return $res;
        
    }
    public static function getCareerCount(){
        
        $sqlSelect = "SELECT career_id, career_name,page_thumbnail,career_intro,main_dept_ref_id FROM lookup_career t
                LEFT JOIN `career_country` cc ON cc.career_ref_id = t.career_id
                WHERE is_active = 1 AND is_career_page = 1 AND (cc.country_ref_id IS NULL) and main_dept_ref_id IS null
                AND career_name NOT IN (
                SELECT career_name FROM lookup_career t
                LEFT JOIN `career_country` cc ON cc.career_ref_id = t.career_id
                WHERE is_active = 1 AND is_career_page = 1 AND (cc.country_ref_id = '".Yii::app()->user->visitorCountry."') 
                    and main_dept_ref_id IS null  )
                UNION
                SELECT career_id, career_name,page_thumbnail,career_intro,main_dept_ref_id FROM lookup_career t
                LEFT JOIN `career_country` cc ON cc.career_ref_id = t.career_id
                WHERE is_active = 1 AND is_career_page = 1 AND (cc.country_ref_id = '".Yii::app()->user->visitorCountry."')"
                . " and main_dept_ref_id IS null";
        
       //echo $sqlSelect; exit;
        $cmd = Yii::app()->db->createCommand($sqlSelect);
        $res = $cmd->queryAll();
        return $res;
        
    }
    public static function getCareerDetailsByCareerName($careerName){
        $sql= "SELECT * FROM lookup_career lc
        LEFT JOIN career_country cc ON cc.career_ref_id = lc.career_id
        WHERE cc.country_ref_id = 100 AND lc.career_name = '".$careerName."' AND lc.is_active=1 AND lc.is_career_page=1";
        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        return $result;
    }

    public static function recommendedForYou($deptId,$careerId){
        if($careerId) {
            $career = LookupCareer::model()->findByPk($careerId);
        }
        if($deptId>0)
        {
            $sql = "SELECT 1 AS flag, career_id, career_name, page_thumbnail FROM `lookup_career` lc
                          WHERE lc.main_dept_ref_id = '".$deptId."' AND career_name != '".$career->career_name."' AND page_thumbnail IS NOT NULL AND lc.is_active=1 GROUP BY career_name LIMIT 4
                        UNION ALL
                            SELECT 0 AS flag, a.article_id, a.title, a.small_img_name FROM `article_departements` ad
                            INNER JOIN article a ON a.article_id = ad.article_ref_id
                            WHERE ad.department_ref_id = '".$deptId."' AND small_img_name IS NOT NULL
                            AND a.is_active = 'Y' AND (expires_on = '0000-00-00' OR expires_on>CURDATE()) AND a.category!='news'
                            ORDER BY flag DESC LIMIT 8";
        }
        else
        {
            $sql = "SELECT 1 AS flag, career_id, career_name, page_thumbnail FROM `lookup_career`
                      WHERE main_dept_ref_id IS NULL AND page_thumbnail IS NOT NULL AND career_name != '".$career->career_name."' AND is_active=1
                      GROUP BY career_name
                      ORDER BY career_name LIMIT 4";
        }
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getParentChoice(){
        $criteria = new CDbCriteria;
        $criteria->select  = " career_id,career_name ";
        $criteria->condition = "parent_choice = 'Y'";
        $criteria->order = "career_id";
        $CareerData = self::model()->findAll($criteria);
        return $CareerData;
    }
}