<?php

/**
 * This is the model class for table "lookup_duration".
 *
 * The followings are the available columns in table 'lookup_duration':
 * @property integer $duration_id
 * @property string $name
 *
 * The followings are the available model relations:
 * @property DiSearch[] $diSearches
 * @property StudentPreferredDuration[] $studentPreferredDurations
 */
class LookupDuration extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupDuration the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_duration';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name', 'required'),
			array('name', 'length', 'max'=>45),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('duration_id, name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diSearches' => array(self::HAS_MANY, 'DiSearch', 'duration_ref_id'),
			'studentPreferredDurations' => array(self::HAS_MANY, 'StudentPreferredDuration', 'duration_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'duration_id' => 'Duration',
			'name' => 'Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('duration_id',$this->duration_id);
		$criteria->compare('name',$this->name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    public function getDurations(){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->order = "t.name";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }
}