<?php

/**
 * This is the model class for table "lookup_popularcourse_subdept".
 *
 * The followings are the available columns in table 'lookup_popularcourse_subdept':
 * @property integer $popular_courses_ref_id
 * @property integer $sub_department_ref_id
 */
class LookupPopularcourseSubdept extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupPopularcourseSubdept the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_popularcourse_subdept';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('popular_courses_ref_id, sub_department_ref_id', 'required'),
			array('popular_courses_ref_id, sub_department_ref_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('popular_courses_ref_id, sub_department_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'popular_courses_ref_id' => 'Popular Courses Ref',
			'sub_department_ref_id' => 'Sub Department Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('popular_courses_ref_id',$this->popular_courses_ref_id);
		$criteria->compare('sub_department_ref_id',$this->sub_department_ref_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}