<?php

/**
 * This is the model class for table "profile_validation_score".
 *
 * The followings are the available columns in table 'profile_validation_score':
 * @property string $profile_validation_score_id
 * @property string $user_ref_id
 * @property string $profile_score
 * @property string $passout_year
 * @property string $board_10
 * @property string $board_12
 * @property string $marks_10
 * @property string $marks_12
 * @property string $marks_100
 * @property string $marks_above_95
 * @property string $marks_diff
 * @property string $subject_marks_10_100
 * @property string $subject_marks_12_100
 * @property string $pref_country
 * @property string $pref_country_score
 * @property string $pref_dept
 * @property string $pref_dept_score
 * @property string $contact_number
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class ProfileValidationScore extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'profile_validation_score';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, subject_marks_12_100, added_on', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('profile_score, passout_year, board_10, board_12, marks_10, marks_12, marks_100, marks_above_95, marks_diff, subject_marks_10_100, subject_marks_12_100, pref_country, pref_country_score, pref_dept, pref_dept_score, contact_number', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('profile_validation_score_id, user_ref_id, profile_score, passout_year, board_10, board_12, marks_10, marks_12, marks_100, marks_above_95, marks_diff, subject_marks_10_100, subject_marks_12_100, pref_country, pref_country_score, pref_dept, pref_dept_score, contact_number, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'profile_validation_score_id' => 'Profile Validation Score',
			'user_ref_id' => 'User Ref',
			'profile_score' => 'Profile Score',
			'passout_year' => 'Passout Year',
			'board_10' => 'Board 10',
			'board_12' => 'Board 12',
			'marks_10' => 'Marks 10',
			'marks_12' => 'Marks 12',
			'marks_100' => 'Marks 100',
			'marks_above_95' => 'Marks Above 95',
			'marks_diff' => 'Marks Diff',
			'subject_marks_10_100' => 'Subject Marks 10 100',
			'subject_marks_12_100' => 'Subject Marks 12 100',
			'pref_country' => 'Pref Country',
			'pref_country_score' => 'Pref Country Score',
			'pref_dept' => 'Pref Dept',
			'pref_dept_score' => 'Pref Dept Score',
			'contact_number' => 'Contact Number',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('profile_validation_score_id',$this->profile_validation_score_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('profile_score',$this->profile_score,true);
		$criteria->compare('passout_year',$this->passout_year,true);
		$criteria->compare('board_10',$this->board_10,true);
		$criteria->compare('board_12',$this->board_12,true);
		$criteria->compare('marks_10',$this->marks_10,true);
		$criteria->compare('marks_12',$this->marks_12,true);
		$criteria->compare('marks_100',$this->marks_100,true);
		$criteria->compare('marks_above_95',$this->marks_above_95,true);
		$criteria->compare('marks_diff',$this->marks_diff,true);
		$criteria->compare('subject_marks_10_100',$this->subject_marks_10_100,true);
		$criteria->compare('subject_marks_12_100',$this->subject_marks_12_100,true);
		$criteria->compare('pref_country',$this->pref_country,true);
		$criteria->compare('pref_country_score',$this->pref_country_score,true);
		$criteria->compare('pref_dept',$this->pref_dept,true);
		$criteria->compare('pref_dept_score',$this->pref_dept_score,true);
		$criteria->compare('contact_number',$this->contact_number,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ProfileValidationScore the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
