<?php

/**
 * This is the model class for table "student_education".
 *
 * The followings are the available columns in table 'student_education':
 * @property string $student_education_id
 * @property integer $user_ref_id
 * @property integer $board_ref_id
 * @property double $overall_marks
 * @property integer $overall_points
 * @property integer $year
 * @property integer $month
 * @property double $bestfour
 * @property string $class_level
 * @property string $status
 * @property string $school_name
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property StudentEducationDetail[] $studentEducationDetails
 * @property StudentGradeCount[] $studentGradeCounts
 */
class StudentEducation extends CActiveRecord
{
    
    
    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'overall_marks, board_ref_id, year, school_name, class_level' => 'class_level_user_function',
        );
    }
    
    public function class_level_user_function($attribute_name = NULL){
        
        $class_level_lookup = '';
        
        switch ($this->class_level) {
            case '10':
                $class_level_lookup = '10th_details';
                break;
            case '12':
                $class_level_lookup = '12th_details';
                break;
            default:
                $class_level_lookup = NULL;
                break;
        }
        
        return $class_level_lookup;
    }
    
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentEducation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_education';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, board_ref_id', 'required'),
			array('user_ref_id, board_ref_id, overall_points, year, month', 'numerical', 'integerOnly'=>true),
			array('overall_marks, bestfour', 'numerical'),
			array('class_level', 'length', 'max'=>2),
			array('status', 'length', 'max'=>9),
			array('school_name', 'length', 'max'=>100),
                        array('added_on, change_school, interested_stream', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_education_id, user_ref_id, board_ref_id, overall_marks, overall_points, year, month, bestfour, class_level, status, school_name, added_on, interested_stream', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'boardRef' => array(self::BELONGS_TO, 'LookupBoardEquivalent', 'board_ref_id'),
            'boardEquivalentRef' => array(self::BELONGS_TO, 'LookupBoardEquivalent', 'board_ref_id'),
            'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'studentEducationDetails' => array(self::HAS_MANY, 'StudentEducationDetail', 'student_education_ref_id'),
			'studentGradeCounts' => array(self::HAS_MANY, 'StudentGradeCount', 'student_education_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_education_id' => 'Student Education',
			'user_ref_id' => 'User Ref',
			'board_ref_id' => 'Board Ref',
			'overall_marks' => 'Overall Marks',
			'overall_points' => 'Overall Points',
			'year' => 'Year',
			'month' => 'Month',
			'bestfour' => 'Bestfour',
			'class_level' => 'Class Level',
			'status' => 'Status',
			'school_name' => 'School Name',
			'added_on' => 'Added On',
            'interested_stream'=>'Interested Stream',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_education_id',$this->student_education_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('overall_marks',$this->overall_marks);
		$criteria->compare('overall_points',$this->overall_points);
		$criteria->compare('year',$this->year);
		$criteria->compare('month',$this->month);
		$criteria->compare('bestfour',$this->bestfour);
		$criteria->compare('class_level',$this->class_level,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('school_name',$this->school_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    public static function createStudentEducationRecord($fields = array()){
        $model = new StudentEducation();
        $model->setAttributes($fields);
        $model->save(false);
    }

    public static function getStudentEducationDetails($userId = 0, $class = ''){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("user_ref_id = '".$userId."'", 'AND');
        if($class != ''){
            $cdbCriteria->addCondition("class_level = '".$class."'", 'AND');
        }
        $result = self::model()->find($cdbCriteria);
        //echo "<pre>";print_r($result->attributes);
        return $result;
    }

    protected function beforeSave(){
        if(parent::beforeSave()){
            if($this->isNewRecord){
                $this->added_on = date('Y-m-d H:i:s');
            }/*else{
                $this->modified_on = date('Y-m-d H:i:s');
            }*/
            return true;

        }
        return false;
    }

    public static function deleteStudentEducationDetails($userId=0, $class = 0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("user_ref_id = '".$userId."'", "AND");
        if($class != ''){
            $cdbCriteria->addCondition("class_level = '".$userId."'", "AND");
        }
        $result = self::model()->findAll($cdbCriteria);
        if(count($result) > 0){
            foreach($result as $studentSubject){
                StudentGradeCount::model()->deleteAll(array("condition" => "student_education_ref_id = '".$studentSubject->attributes['student_education_id']."'"));
                StudentEducationDetail::model()->deleteAll(array("condition" => "student_education_ref_id = '".$studentSubject->attributes['student_education_id']."'"));
                self::model()->deleteByPk($studentSubject->attributes['student_education_id']);
            }
        }
    }
    
    public static function getSubjectDetail($class,$userId){
        $criteria = new CDbCriteria;
        $criteria->with = 'studentEducationDetails';
        $criteria->condition = 'class_level="'.$class.'" AND user_ref_id='.$userId;
        $res = self::model()->findAll($criteria);
        return $res;
    }
    
    public static function getGradeDetail($class,$userId){
        $criteria = new CDbCriteria;
        $criteria->with = 'studentGradeCounts';
        $criteria->condition = 'class_level="'.$class.'" AND user_ref_id='.$userId;
        $res = self::model()->findAll($criteria);
        return $res;
    }
    
    public static function getSubjectDetailByClass($class,$userId){
        $criteria = new CDbCriteria;
        $criteria->join = 'INNER JOIN student_education_detail sed ON t.student_education_id = sed.student_education_ref_id';
        $criteria->condition = 'class_level="'.$class.'" AND user_ref_id='.$userId;
        $res = self::model()->findAll($criteria);
        return $res;
    }

    public static function getEductionDetail($userId){
        $criteria = new CDbCriteria;
        $criteria->select = 'interested_stream';
        $criteria->condition = 'user_ref_id='.$userId;
        $res = self::model()->find($criteria);
        return $res;
    }    
}