<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentPreferredUniversity');

class StudentPreferredUniversity extends BaseStudentPreferredUniversity
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

    public static function addStudentAspireCollege($fields = array(), $loginRefId=0, $departmentId=0){
        $status = false;
		
        $model = self::model()->findByAttributes($fields);
        if(!$model){
            //echo "NEW MODEL";
            $model = new StudentPreferredUniversity();
            $model->setAttributes($fields);
            $model->added_on = date('Y-m-d H:i:s');
            if($model->save(false)){
                if($departmentId > 0){
                    $status = StudentIdealList::addStudentIdealListAndCollege($fields['user_ref_id'], $departmentId, $fields['university_ref_id'], StudentIdealList::TYPE_ASPIRATIONAL);
                }else{
                    $result = self::checkStudentSelectedCollegeByDeptPref($fields['user_ref_id'], $fields['university_ref_id']);
                    //$result = self::checkStudentSelectedCollegeByDeptPref(947, 17);
                    if($fields['university_ref_id'] > 0 && count($result) > 0){
                        foreach($result as $deptArray){
                            $status = StudentIdealList::addStudentIdealListAndCollege($fields['user_ref_id'], $deptArray['main_dept_id'], $fields['university_ref_id'], StudentIdealList::TYPE_ASPIRATIONAL);
                            /*$studentIdealList = StudentIdealList::getRecord($fields['user_ref_id'], $deptArray['main_dept_id'], StudentIdealList::TYPE_ASPIRATIONAL);
                        //$studentIdealList = StudentIdealList::getRecord($fields['user_ref_id'], $deptArray['department_id'], StudentIdealList::TYPE_ASPIRATIONAL);

                            //creating student_ideal_list_country record
                            $studentIdealListCollege = new StudentIdealListCollege;
                            $studentIdealListCollege->uni_ref_id = $fields['university_ref_id'];
                            $studentIdealListCollege->suggest_type = StudentIdealListCollege::SUGGEST_TYPE_STUDENT;
                            $bl = $studentIdealListCollege->addUniversity($studentIdealList);
                            //echo "<br>UserID:".$fields['user_ref_id']."-DeptId:".$deptArray['main_dept_id'];
                        if($bl){
                                $status = true;
                            }else{
                                //var_dump($studentIdealListCollege->getErrors());
                                $status = false;
                            }*/
                        }
                    }
                }
                StudentHotlead::createStudentHotLead($fields['user_ref_id'], $loginRefId, $fields['university_ref_id']);
            }
        }
		
        return $status;
    }

    public static function checkStudentSelectedCollegeByDeptPref($userId=0, $uniId = 0){
        //todo: due to complex join unable to get required fields. try to remove createCommand()
        /*$cdbCriteria = new CDbCriteria();
        $cdbCriteria->select = "distinct(t.uni_id),  ld.department_id, ld.main_dept_id";
        $cdbCriteria->join = "LEFT JOIN tbl_uni_courses uc ON uc.uni_ref_id = t.uni_id
        LEFT JOIN lookup_department ld ON ld.department_id = uc.department_ref_id
        LEFT JOIN student_preferred_department spd ON ld.main_dept_id = spd.main_dept_ref_id";
        $cdbCriteria->addCondition("spd.user_ref_id = '93'");
        $cdbCriteria->group = "ld.main_dept_id";
        $result = TblUniversityMaster::model()->findAll($cdbCriteria);*/
        $condition = "spd.user_ref_id = '".$userId."'";
        if($uniId > 0){
            $condition .= " and t.uni_id = '".$uniId."'";
        }
        $sql = "SELECT DISTINCT(t.uni_id),  ld.department_id, ld.main_dept_id
                FROM tbl_university_master t
                LEFT JOIN tbl_uni_courses uc ON uc.uni_ref_id = t.uni_id
                LEFT JOIN lookup_department ld ON ld.department_id = uc.department_ref_id
                LEFT JOIN student_preferred_department spd ON ld.main_dept_id = spd.main_dept_ref_id
                WHERE ".$condition."
                GROUP BY ld.main_dept_id";
        $cmd = Yii::app()->db->createCommand($sql);
        //$cmd->bindValue(":siRefId", $siRefId, PDO::PARAM_INT);
        $result = $cmd->queryAll();
        return $result;
    }
    public static function addStudentsToIdealList($fields = array()){}

    public static function getStudentPreferredUniversities($userId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->join = "LEFT JOIN tbl_university_master um ON um.uni_id = t.university_ref_id
        LEFT JOIN tbl_country_master cm ON cm.country_id = um.country_ref_id
        LEFT JOIN tbl_state state ON state.id = um.state_ref_id
        LEFT JOIN tbl_city_master city ON city.city_id = um.city_ref_id";
        $cdbCriteria->compare('t.user_ref_id', $userId);
        $cdbCriteria->order = "t.preferred_university_id";
        $result = self::model()->findAll($cdbCriteria);
        $studentPreferences = array();
        foreach($result as $uniPref){

            $userPref = array();
            $userPref['university_ref_id'] = $uniPref->attributes['university_ref_id'];
            $userPref['preferred_university_id'] = $uniPref->attributes['preferred_university_id'];
            $userPref['university_name'] = ($uniPref->attributes['university_name'] == '' && $uniPref->attributes['university_ref_id'] != '')
                ? $uniPref->universityRef->attributes['uni_name']
                : $uniPref->attributes['university_name'];
                //'university_details' => $uniPref->universityRef->attributes['uni_name'].''
            //todo: need to join to get country, state and city details
            $userPref['country_id'] = $uniPref->universityRef->attributes['country_ref_id'];
            $userPref['country_name'] = $uniPref->universityRef->countryRef->attributes['country_name'];
            $userPref['state_id'] = $uniPref->universityRef->attributes['state_ref_id'];
            $userPref['state_name'] = $uniPref->universityRef->stateRef->attributes['name'];
            $userPref['city_id'] = $uniPref->universityRef->attributes['city_ref_id'];
            $userPref['city_name'] = $uniPref->universityRef->cityRef->attributes['city_name'];

            $studentPreferences[] = $userPref;
        }
        return $studentPreferences;
    }

    public static function deleteStudentIdealList($userId, $prefId){
        $studentPreferences = StudentPreferredUniversity::model()->findAll('preferred_university_id=:prefId AND user_ref_id=:userRefId', array(':prefId' => $prefId, ':userRefId' => $userId));
        foreach($studentPreferences as $pref){
            $uniId = $pref->attributes['university_ref_id'];
            if($uniId > 0 && $userId > 0){
                //Removing HotLead
                StudentHotlead::model()->deleteAll("user_ref_id = '" . $userId . "' AND uni_ref_id = '" . $uniId ."'");

                $result = StudentPreferredUniversity::checkStudentSelectedCollegeByDeptPref($userId, $uniId);
                foreach($result as $deptArray){
                    $studentIdealList = StudentIdealList::getRecord($userId, $deptArray['department_id'], StudentIdealList::TYPE_ASPIRATIONAL);
                    $studentIdealListId = $studentIdealList->attributes['student_ideal_list_id'];

                    //$studentIdealListCollege = StudentIdealListCollege::model()->find("student_ideal_list_ref_id='".$studentIdealListId."' AND uni_ref_id = '".$uniId."'");
                    //$studentIdealListCollegeId = $studentIdealListCollege->attributes['student_ideal_list_college_id'];

                    StudentIdealListCollegeLog::model()->deleteAll("student_ideal_list_ref_id='".$studentIdealListId."' AND uni_ref_id='".$uniId."'");
                    StudentIdealListCollege::model()->deleteAll("student_ideal_list_ref_id='".$studentIdealListId."' AND uni_ref_id='".$uniId."'");

                    StudentIdealList::model()->deleteAll("user_ref_id='".$userId."' AND department_ref_id='".$deptArray['department_id']."'");

                }

            }
            StudentPreferredUniversity::model()->deleteAll("preferred_university_id='".$prefId."' AND user_ref_id='".$userId."'");
        }
    }


    public function getStudentPreferredUniversityNamesOnly($user_id=0,$countryId=0,$departmentId=0)
    {
        $sql='SELECT ldl.department_name,ssu.uni_ref_id,tum.uni_name,tum.country_ref_id
              FROM student_shortlist_university ssu
              JOIN tbl_university_master tum ON tum.uni_id=ssu.uni_ref_id
              JOIN tbl_uni_courses tc ON tc.uni_ref_id=ssu.uni_ref_id
              JOIN lookup_department ld ON ld.department_id = tc.department_ref_id
              JOIN lookup_department ldl ON ld.main_dept_id = ldl.department_id
              WHERE ld.main_dept_id='.$departmentId.' AND ssu.user_ref_id='.$user_id.' AND tum.country_ref_id='.$countryId.' GROUP BY ssu.uni_ref_id';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        $universities=array();
        foreach($data as $result){
            $universities[$result['uni_ref_id']] = $result['uni_name'];
        }
        return $universities;

    }

}