<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentShortlistUniversity');

class StudentShortlistUniversity extends BaseStudentShortlistUniversity
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'uni_ref_id, shortlist_status, get_alert' => 'college_shortlisted',
        );
    }
  
  
  public static function addStudentShortListUniversity($userList = false,$loginRefId = false)
  {
        $status = false;
        $model  = StudentPreferredUniversity::model()->findByAttributes($userList);
        if(!$model){
            //echo "NEW MODEL";
			
            $model = new StudentPreferredUniversity();
            $model->setAttributes($userList);
            $model->added_on = date('Y-m-d H:i:s');
			$model->save();
		}	
		
			 $shortlistUniversity = self::model()->count('user_ref_id=:userId AND uni_ref_id=:uniRefId', array(':userId' => $userList['user_ref_id'],'uniRefId' => $userList['university_ref_id']));	  
			
			if($shortlistUniversity == 0)
			{
			  $studentShortlistModel = new StudentShortlistUniversity();
			  $studentShortlistModel->user_ref_id        = $userList['user_ref_id'];
			  $studentShortlistModel->uni_ref_id         = $userList['university_ref_id'];
			  $studentShortlistModel->shortlist_status   = 'WillApply';
			  $studentShortlistModel->added_on           = date('Y-m-d H:i:s');
			  $studentShortlistModel->added_by           = $loginRefId;
			
			  $test = $studentShortlistModel->save();	
			 
			 }
      }
	  
      public static function getUniversityDeadlines($userId = false){

        $dateResult   =  UniversityDateIntakeDescription::getUniversityLatestDate($userId,$day = true,$month = true);
        $monthResult  =  UniversityDateIntakeDescription::getUniversityLatestDate($userId,$day = true,$month = false);

        if($dateResult)
            $id =  $dateResult[0]['university_date_intake_description_id'];
        else
            $id =  $monthResult[0]['university_date_intake_description_id'];
          /* AND date_year IS NULL
						 AND date_month IS NOT NULL
						 AND date_day IS NOT NULL
						 AND `date_month` >= ".date('n')."	*/
	 
	  	$sql = "SELECT
     				DISTINCT 
					    tum.uni_name,tum.uni_id,uds.date_day,uds.date_month,uds.date_year,uds.date_description FROM 
						student_shortlist_university ssu
						JOIN tbl_university_master tum ON  ssu.uni_ref_id=tum.uni_id
						JOIN `university_date_intake` udi ON tum.uni_id = udi.uni_ref_id
						JOIN `university_date_intake_description` uds ON udi.university_date_intake_id = uds.university_date_intake_ref_id
					WHERE		
						 ssu.user_ref_id = '".$userId."'
						 AND shortlist_status != 'Reject'
						 AND uds.university_date_intake_description_id = '".$id."'
				    ORDER BY date_month ASC,date_day ASC LIMIT 1";
		 $result = Yii::app()->db->createCommand($sql)->queryAll();
		 
		 return $result;
	}

    public static function getLatestUniversityDeadlines($userId = false){

        $dateResult   =  UniversityDateIntakeDescription::getUniversityLatestThreeDates($userId,$day = true,$month = true);
        $monthResult  =  UniversityDateIntakeDescription::getUniversityLatestThreeDates($userId,$day = true,$month = false);

        //var_dump($dateResult); var_dump($monthResult) ; exit;

        $ids = array();
        if($dateResult) {
            foreach ($dateResult as $key) {
                $ids [] = $key['university_date_intake_description_id'];
            }
        }
            //$ids =  $dateResult[0]['university_date_intake_description_id'];
        else {
            foreach ($monthResult as $key) {
                $ids [] = $key['university_date_intake_description_id'];
            }
        }
        $result = '';
        if (count($ids) > 0) {
            $idsString = implode(",", $ids);
            $sql = "SELECT
                        DISTINCT
                            tum.uni_name,tum.uni_id,uds.date_day,uds.date_month,uds.date_year,uds.date_description FROM
                            student_shortlist_university ssu
                            JOIN tbl_university_master tum ON  ssu.uni_ref_id=tum.uni_id
                            JOIN `university_date_intake` udi ON tum.uni_id = udi.uni_ref_id
                            JOIN `university_date_intake_description` uds ON udi.university_date_intake_id = uds.university_date_intake_ref_id
                        WHERE
                             ssu.user_ref_id = '".$userId."'
                             AND shortlist_status != 'Reject'
                             AND uds.university_date_intake_description_id IN (".$idsString.")
                        ORDER BY date_month ASC,date_day ASC LIMIT 3";
            $result = Yii::app()->db->createCommand($sql)->queryAll();
        }
        return $result;
    }

    public static function getIndianUniversityDeadlines($userId = false){

        $sql = "SELECT DISTINCT ee.entrance_short_name,eedl.date_month,eedl.date_year,eedl.date_day,
					    spc.country_ref_id,eeds.section,eedl.label FROM
						student_shortlist_university ssu
                        LEFT JOIN uni_course_test uct ON ssu.uni_ref_id = uct.uni_ref_id
                        LEFT JOIN entrance_exam ee ON uct.entrance_ref_id = ee.entrance_id
                        LEFT JOIN entrance_exam_date_section eeds ON ee.entrance_id = eeds.entrance_exam_ref_id
                        LEFT JOIN entrance_exam_date_label eedl ON eeds.entrance_exam_date_section_id = eedl.entrance_exam_date_section_ref_id
                        LEFT JOIN student_preferred_country spc ON ssu.user_ref_id = spc.user_ref_id
					WHERE
						ssu.user_ref_id = '".$userId."'
                         AND date_year IS NULL
                         AND date_month IS NOT NULL
                         AND date_day IS NOT NULL
                         AND date_month >= ".date('n')."
                         AND shortlist_status != 'Reject'
                         AND spc.preference_order = 1
                         ORDER BY date_month ASC,date_day ASC LIMIT 1";
        $result = Yii::app()->db->createCommand($sql)->queryAll();
        return $result;//LEFT JOIN tbl_university_master tum ON ssu.uni_ref_id = tum.uni_id
    }

    public static function getStudentShortlistStatus($userId=0, $uniId=0){
        $result = self::model()->find(array('condition' => "user_ref_id = '$userId' AND uni_ref_id = '$uniId'"));
        return $result->shortlist_status;
    }

    public function getShortlistUniversityBasedOnCountryAndDept($country,$dept,$userId){

        $sql =" SELECT ssu.uni_ref_id,um.uni_name
                FROM student_shortlist_university ssu
                JOIN tbl_university_master um ON um.uni_id = ssu.uni_ref_id
                JOIN tbl_uni_courses uc ON uc.uni_ref_id = um.uni_id
                JOIN lookup_department ld ON ld.department_id = uc.department_ref_id
                LEFT JOIN lookup_department ld1 ON ld1.department_id = ld.main_dept_id
                WHERE um.is_active = 'Y'
                AND uc.is_active = 'Y'
                AND uc.course_level = 6
                AND um.country_ref_id = '".$country."'
                AND user_ref_id = '".$userId."'
                AND ld1.department_id = '".$dept."'
                GROUP BY ssu.uni_ref_id";

        $result = Yii::app()->db->createCommand($sql)->queryAll();
        //print_r($result);exit;

        return $result;
    }

    public static function getCollegesForAlerts($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = " user_ref_id = '".$userId."' AND shortlist_status <> 'Reject' AND get_alert = '1' ";
        $criteria->with = array('uniRef'=>array('select'=>'uniRef.uni_name', 'joinType'=>'INNER JOIN' ) );
        return self::model()->findAll($criteria);
    }

    public static function findshortListUniversityRecord($userId,$uniId){
       $sql = 'SELECT * FROM `student_shortlist_university` WHERE user_ref_id='.$userId.' AND uni_ref_id='.$uniId.' AND shortlist_status != \'Reject\'';
       $result = Yii::app()->db->createCommand($sql)->queryAll();
       return $result;
    }
}