<?php

/*
 * @author Asif Ali M
 * @package application.models
 *
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblCityMaster');

class TblCityMaster extends BaseTblCityMaster
{
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'country' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_id'),
			'tblUniversityMasters' => array(self::HAS_MANY, 'TblUniversityMaster', 'city_ref_id'),
			'vendorBranches' => array(self::HAS_MANY, 'VendorBranch', 'city_ref_id'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
		$criteria->order = 'city_name';
		$criteria->with = array('country');

		$criteria->compare('city_id',$this->city_id);
		if(!empty($this->country_id)){
			$criteria->compare('t.country_id', $this->country_id);
		}
		$criteria->compare('city_name',$this->city_name,true);
		$criteria->compare('t.is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
     * This method will return the city list
     * @param string $searchTerm
     * @return array
     */
    public static function getSuggestionList($searchTerm, $limit = 10){
        $criteria = new CDbCriteria;
        $criteria->alias = 'c';
        $criteria->compare('c.city_name', $searchTerm, true);
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN c.city_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), c.city_name";
        $criteria->limit = $limit;
        return self::model()->findAll($criteria);
    }

    public function getCityListByCountry($countryId){
        $criteria=New CDbCriteria;
        $criteria->select='city_id,city_name';
        $criteria->condition ='country_id=:id and is_active="Y"';
        $criteria->params= array(':id'=>$countryId);
        $criteria->order= 'city_name';
        $criteria->group='city_name';
        $data =  self::model()->findAll($criteria);
        if($data){
            foreach($data as $value){
                $cityList[$value->attributes['city_id']] = $value->attributes['city_name'];
            }
        }else{
            $cityList = array();
        }
        return $cityList;
    }

     public function getNameById($countryId,$cityId){
        $criteria=New CDbCriteria;
        $criteria->select='city_id,city_name';
        $criteria->condition ='country_id=:id and city_id =:cityId and is_active="Y"';
        $criteria->params= array(':id'=>$countryId,':cityId'=>$cityId);
        $data =  self::model()->find($criteria);
        $cityName['city_id'] = $data->city_id;
        $cityName['city_name'] = $data->city_name;
        return $cityName;
    }

    public function getCityListByState($stateId){
        $criteria=New CDbCriteria;
        $criteria->select='city_id,city_name';
        $criteria->condition ='state_ref_id=:id and is_active="Y"';
        $criteria->params= array(':id'=>$stateId);
        $criteria->order= 'city_name';
        $criteria->group='city_name';
        $data =  self::model()->findAll($criteria);
        foreach($data as $value){
            $cityList[$value->attributes['city_id']] = $value->attributes['city_name'];
        }
        return $cityList;
    }

    //TODO: #994 removed 'city' Fields
    public static function getCityName($cityId) {
        $criteria = new CDbCriteria;
        $criteria->compare('city_id', $cityId);
        $res = self::model()->find($criteria);
        return $res->city_name;
    }

    public function getCityListByCountryColleges($countryId=false){
        $criteria=New CDbCriteria;
        $criteria->join = ' INNER JOIN tbl_university_master tum on tum.city_ref_id = t.city_id';
        $criteria->select='city_id,city_name';

        $criteria->condition ='t.country_id=:id and t.is_active="Y" and tum.is_active = "Y"';
        $criteria->params= array(':id'=>$countryId);

        $criteria->order= 'city_name';
        $data =  self::model()->findAll($criteria);
        if($data){
            foreach($data as $value){
                $cityList[$value->attributes['city_id']] = $value->attributes['city_name'];
            }
        }else{
            $cityList = array();
        }
        return $cityList;
    }
    public static function getCityListOfIndiaOfMetro($countryId){

        $value=array();
        $sql=' SELECT DISTINCT t.city_id,t.city_name,lc.city_type FROM tbl_city_master t
               INNER JOIN tbl_university_master tum
               ON tum.city_ref_id = t.city_id
               JOIN lookup_city_type lc
               ON t.citytype_ref_id=lc.citytype_id
               WHERE t.country_id='.$countryId.' AND t.is_active="Y" AND tum.is_active = "Y" AND t.citytype_ref_id=1
               ORDER BY t.city_name';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
    //   echo "<pre>";print_r($data);
        if(count($data)>1)
        {
            $cityList=array();
            foreach($data as $value)
             {
                 $cityList[$value['city_id']] = $value['city_name'];
                    //$cityList['city_id']= $value['city_name'];
             }

        }

              //  echo "fherfheirfebve heh";
             //  echo  $value->attributes['city_name'];
                      // $cityList[$key->attributes['city_id']] = $key->attributes['city_name'];            //   echo  $cityList[$value->attributes['city_id']];
        else{
                $cityList=array();
        }
        return $cityList;
    }
    public static function getCityListOfIndiaOfTier1($countryId){

        $value=array();
        $sql='
            SELECT DISTINCT t.city_id,t.city_name,lc.city_type FROM tbl_city_master t
            INNER JOIN tbl_university_master tum
            ON tum.city_ref_id = t.city_id
            JOIN lookup_city_type lc
            ON t.citytype_ref_id=lc.citytype_id
            WHERE t.country_id='.$countryId.' AND t.is_active="Y" AND tum.is_active = "Y" AND t.citytype_ref_id=2
            ORDER BY t.city_name';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        //   echo "<pre>";print_r($data);
        if(count($data)>0)
        {
            $cityList=array();
            foreach($data as $value)
            {
                $cityList[$value['city_id']] = $value['city_name'];
                //$cityList['city_id']= $value['city_name'];
            }

        }

        //  echo "fherfheirfebve heh";
        //  echo  $value->attributes['city_name'];
        // $cityList[$key->attributes['city_id']] = $key->attributes['city_name'];            //   echo  $cityList[$value->attributes['city_id']];
        else{
            $cityList=array();
        }
        return $cityList;
    }
    public static function getCityListOfIndiaOfTier2($countryId){

        $value=array();
        $sql=' SELECT DISTINCT t.city_id,t.city_name,lc.city_type FROM tbl_city_master t
               INNER JOIN tbl_university_master tum
               ON tum.city_ref_id = t.city_id
               JOIN lookup_city_type lc
               ON t.citytype_ref_id=lc.citytype_id
               WHERE t.country_id='.$countryId.' AND t.is_active="Y" AND tum.is_active = "Y" AND t.citytype_ref_id=3
               ORDER BY t.city_name';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        //   echo "<pre>";print_r($data);
        if(count($data)>1)
        {
            $cityList=array();
            foreach($data as $value)
            {
                $cityList[$value['city_id']] = $value['city_name'];
                //$cityList['city_id']= $value['city_name'];
            }

        }

        //  echo "fherfheirfebve heh";
        //  echo  $value->attributes['city_name'];
        // $cityList[$key->attributes['city_id']] = $key->attributes['city_name'];            //   echo  $cityList[$value->attributes['city_id']];
        else{
            $cityList=array();
        }
        return $cityList;
    }
    public static function getCityListOfIndiaOfOthers($countryId){

        $value=array();
        $sql=' SELECT DISTINCT t.city_id,t.city_name,lc.city_type FROM tbl_city_master t
               INNER JOIN tbl_university_master tum
               ON tum.city_ref_id = t.city_id
               JOIN lookup_city_type lc
               ON t.citytype_ref_id=lc.citytype_id
               WHERE t.country_id='.$countryId.' AND t.is_active="Y" AND tum.is_active = "Y" AND t.citytype_ref_id=4
               ORDER BY t.city_name';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        //   echo "<pre>";print_r($data);
        if(count($data)>1)
        {
            $cityList=array();
            foreach($data as $value)
            {
                $cityList[$value['city_id']] = $value['city_name'];
                //$cityList['city_id']= $value['city_name'];
            }

        }

        //  echo "fherfheirfebve heh";
        //  echo  $value->attributes['city_name'];
        // $cityList[$key->attributes['city_id']] = $key->attributes['city_name'];            //   echo  $cityList[$value->attributes['city_id']];
        else{
            $cityList=array();
        }
        return $cityList;
    }
    public function getCityListByStateColleges($stateId){
        $criteria=New CDbCriteria;
        $criteria->join = ' INNER JOIN tbl_university_master tum on tum.city_ref_id = t.city_id';
        $criteria->select='city_id,city_name';

        $criteria->condition ='t.state_ref_id=:id and t.is_active="Y" and tum.is_active = "Y"';
        $criteria->params= array(':id'=>$stateId);

        $criteria->order= 'city_name';
        $data =  self::model()->findAll($criteria);
        if($data){
            foreach($data as $value){
                $cityList[$value->attributes['city_id']] = $value->attributes['city_name'];
            }
        }else{
            $cityList = array();
        }
        return $cityList;
    }

    public static function getSuggestionListByCountry($searchTerm, $limit = 10,$countryId){
        $criteria = new CDbCriteria;
        $criteria->alias = 'c';
        $criteria->compare('c.city_name', $searchTerm, true);
        $criteria->compare('c.country_id', $countryId);
        $searchTerm = mysql_escape_string($searchTerm);
        $criteria->order = "(CASE WHEN c.city_name LIKE '$searchTerm%' THEN 0 ELSE 1 END ), c.city_name";
        $criteria->limit = $limit;
        return self::model()->findAll($criteria);
    }



    public static function get_city_slug_list_by_country($country_id){
        $result = Yii::app()->db->createCommand()
                ->select('TblCityMaster.city_id, TblCityMaster.city_name')
                ->from(TblCityMaster::model()->tableSchema->name.' TblCityMaster')
                ->where('TblCityMaster.country_id = :country_id AND TblCityMaster.is_active ="Y"', array(':country_id' => $country_id))
                ->order('TblCityMaster.city_name')
                ->queryAll();
        
        $city_list = array();
        foreach($result as $r){
            $city_list[strtolower(Inflector::slug($r['city_name'], '-'))]['id'] = $r['city_id'];
            $city_list[strtolower(Inflector::slug($r['city_name'], '-'))]['title'] = $r['city_name'];
            $city_list[strtolower(Inflector::slug($r['city_name'], '-'))]['slut'] = strtolower(Inflector::slug($r['city_name'], '-'));
        }
        unset($result, $r);
        return $city_list;
    }


}