<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseUmailMessage');

class UmailMessage extends BaseUmailMessage
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  static function insertUmailMessage($param=false,$headerID=false,$userID=false)
  {
		$senderType = !empty($param['guidemesenderType'])?$param['guidemesenderType']:4;
		$recipientType = !empty($param['fldRecipientType'])?$param['fldRecipientType']:1;
				
		//$adminId = !empty(Yii::app()->user->sub_id)?Yii::app()->user->sub_id:'';
		
	    $umailMessageModel = new umailMessage();
		$umailMessageModel->header_ref_id = $headerID;
		$umailMessageModel->sender_type = $senderType;
		if($param['currentAdvisorId'] != ""){
		  $umailMessageModel->sender_id = $param['currentAdvisorId'];
		}
		else if(!empty(Yii::app()->user->sub_id)){
			$siAdminRes = TblAdmin::getSiAdminDetails(Yii::app()->user->sub_id);
			if(isset($_SESSION['extadv']) && $_SESSION['extadv']==1) {
				$siAdminRes = TblAdmin::getExtAdminDetails(Yii::app()->user->sub_id);
			}
			$umailMessageModel->sender_id = $siAdminRes->attributes['admin_id'];
		}
		$umailMessageModel->recipient_type = $recipientType;
		$umailMessageModel->recipient_id = $userID;
		$umailMessageModel->added_on = date("Y-m-d H:i:s");
		$umailMessageModel->message = $param['message'];
		$umailMessageModel->subject = $param['subject'];
		
		
		
		if($senderType == 1)
	    	$umailMessageModel->expected_reply_date = $param['expectedReplyDate'];
		
		$test = $umailMessageModel->save();
		
		$messageId = $umailMessageModel->message_id;
		
		
		
		if($messageId > 0)
		{
		   return $messageId;
		}
		else
		{
			return false;
		}
  }
  static function getUMailMessageDetails($headerId = false,$senderType=false)
    {
         if(!empty($senderType))
		   $where = 'AND sender_type='.$senderType.'';
		 else
		   $where = "";
	    
		$criteria=new CDbCriteria;
		$criteria->condition = 'header_ref_id="'.$headerId.'"  '.$where.'';
        $criteria->order = 'added_on DESC';
        $umailList = self::model()->find($criteria);		
  	    return $umailList;
    }
	static function updateUMailMessage($messageVal,$messageId=false)
    {
		 // $siAdminRes = TblAdmin::getSiAdminDetails(Yii::app()->user->sub_id);
		  $adminId = !empty(Yii::app()->user->sub_id)?Yii::app()->user->sub_id:'';
		  $sql="update umail_message set modified_on=:modifiedOn, modified_by=:modifiedBy, message=:message, subject=:subject where message_id=:messageId";
		  $command=Yii::app()->db->createCommand($sql);         
	      $command->bindParam(':modifiedOn', date('Y-m-d H:i:s'),PDO::PARAM_STR);
		//  $command->bindParam(':modifiedBy', $siAdminRes->attributes['admin_id'],PDO::PARAM_STR);
		
		  $command->bindParam(':modifiedBy', $adminId,PDO::PARAM_STR);
		  $command->bindParam(':message', $messageVal['message'],PDO::PARAM_STR);
		  $command->bindParam(':subject', $messageVal['subject'],PDO::PARAM_STR);
		  $command->bindParam(':messageId', $messageId,PDO::PARAM_STR);
		  $command->execute(); 
    }
	
	/*
	 * Function to validate email and also check csv file for proper values
	 */
	 public function messageValidate($attribute)
     {   
	    //$pattern = "/^([_a-zA-Z0-9-]+)(\.[_a-zA-Z0-9-]+)*@([a-zA-Z0-9-]+)(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,4})$/";
		$isValid = $this->chkValidEmail($attribute['userName']);
		
	    $studentList = self::model()->count('username=:emailId', array(':emailId' => $attribute['userName']));	
	
	    if($studentList > 0)
	    {		
		    $this->addError('username','Email id with "'.$attribute['userName'].'" already exists');		 
		    return false;
	    }
		else if($isValid > 0)
	    {		
		    $this->addError('username','Please enter valid email id "'.$attribute['userName'].'" ');		 
		    return false;
	    }			
	    else
	    {
		    return true;
	    }	
      }
	 public function getUMailMessageViewDetails($headerId = false,$type=false)
	 {
		
	   $headerresult = UmailHeader::getUMailDetails($headerId,'Draft');
	    
	    switch($type){
			case 'draft':
			{				
			   if(!empty($headerresult))
		       {
			    echo  $where = "AND UM.message_id = (SELECT UM.message_id FROM umail_message UM WHERE UM.header_ref_id = '" . $headerId . "' 
								ORDER BY UM.added_on DESC LIMIT 0, 1)";		  
		        }
				break;
				
			}
			case 'inbox':
			case 'sent':
			{
			   if(!empty($headerresult))
		       {
			      $where = "AND UM.message_id <> (SELECT UM.message_id FROM umail_message UM WHERE UM.header_ref_id = '" . $headerId . "' 
								ORDER BY UM.added_on DESC LIMIT 0, 1)";		  
		        }
				else
				{
					 $where = "";
				} 	
				break;
			}
			case 'reply':
			{
			    $where = "AND UM.message_id = (SELECT UM.message_id FROM umail_message UM WHERE UM.header_ref_id = '" . $headerId . "' 
								ORDER BY UM.added_on DESC LIMIT 0, 1)";		  
		       
				 break;
			}
	      }
	 
	   
	    $sql = "SELECT * 
								FROM umail_message UM
							 WHERE	  
								UM.header_ref_id = '" . $headerId . "' 
								".$where." ORDER BY UM.added_on DESC";
		 
	   $cmd = Yii::app()->db->createCommand($sql);	   
	   $res = $cmd->queryAll();
	   
	   if($res)
	   {
		   return $res;
	   }
	 }
	 
	 
	 public function getSenderRecipientName($senderType,$messageId)
	 {
	   
	   if($senderType == 4 || $senderType == 2)
	   {
	      $sqlToFrom = "SELECT U.user_id as `to_id`, U.first_name as `to`, LM.username as to_email, A.admin_id as `from_id`, A.admin_full_name as `from`, A.admin_email as from_email FROM umail_message UM
								LEFT JOIN tbl_user_master U ON U.user_id = UM.recipient_id
								LEFT JOIN login_master LM ON LM.login_id = U.login_ref_id
								LEFT JOIN tbl_admin A ON A.admin_id = UM.sender_id
								 WHERE 
										UM.message_id = '".$messageId."'";
							  
	   }
	   else if($senderType == 1)
	   {
			$sqlToFrom = "SELECT  U.user_id as `from_id`,
								  U.first_name as `from`,
								  LM.username as from_email,
								  A.admin_id as `to_id`,
								  A.admin_full_name as `to`,
								  A.admin_email as to_email 
								 FROM umail_message UM
							     	LEFT JOIN tbl_user_master U ON U.user_id = UM.sender_id
								    LEFT JOIN login_master LM ON LM.login_id = U.login_ref_id
								    LEFT JOIN tbl_admin A ON A.admin_id = UM.recipient_id
								 WHERE 
								     UM.message_id = '".$messageId."'";
	   }
	  
	   	 
	   $cmd = Yii::app()->db->createCommand($sqlToFrom);	   
	   $res = $cmd->queryAll();
	   
	   if($res)
	   {
		   return $res;
	   }
	 }
	 
	 public function getumailCount($senderId,$senderType)
		{				
				$criteria=new CDbCriteria;
				$criteria->condition = 'added_on > DATE_SUB(CURDATE(), INTERVAL 24 HOUR) AND sender_id="'.$senderId.'" AND sender_type="'.$senderType.'" ';				
				$umailCount = self::model()->count($criteria);		
				return $umailCount;			
		}
		
	 public function getUserNewUmailCount( $fldUserId, $fldSenderType )
		{			
			$sqlMessages	= "	SELECT UH.header_id, UM.message_id 
														 FROM umail_header UH 
														  LEFT JOIN umail_message UM ON UM.header_ref_id = UH.header_id 
									  WHERE UM.recipient_id = '$fldUserId' AND UH.sender_type = $fldSenderType AND UH.status = 'Replied' AND
									  UM.added_on = (SELECT added_on from umail_message where header_ref_id = UH.header_id ORDER BY added_on DESC LIMIT 0, 1) 
									  ORDER BY UM.added_on DESC";
	
			  $cmd = Yii::app()->db->createCommand($sqlMessages);	   
	          $res = $cmd->queryAll();
			  
			  return count($res);
		}

    public function getUmailsByStudent($userId,$isReference=false){

        $where = "";
        if($isReference ==1){
            $where = " AND UM.is_refernce_umail='1'";
        }
        $sql = "SELECT UM.message_id,UM.message,UM.is_refernce_umail,UM.subject,UM.added_on,UM.modified_on,UM.modified_by, UH.university_ref_id, A.admin_full_name AS recipient
                FROM umail_message UM
                JOIN umail_header UH ON UH.header_id = UM.header_ref_id
                JOIN tbl_admin A ON A.admin_id = UH.recipient_id
                WHERE UM.sender_id = '$userId' AND UM.sender_type=1 $where  ORDER BY UM.added_on DESC";

        //echo '###'.$sql;
        $rawData=Yii::app()->db->createCommand($sql)->queryAll();

        return new CArrayDataProvider($rawData, array(
            'pagination'=>array(
                'pageSize'=>20,
            ),
            'sort' => array(
                //'defaultOrder' => 'UM.added_on DESC',
                'sortVar' => 'sort',
                'attributes' => array(
                    'added_on',
                ),
            )
        ));
    }

    public function getUmailCountById($userId,$isReference=false)
    {
        $where = "";
        if($isReference ==1){
            $where = " AND UM.is_refernce_umail='1'";
        }
        $sqlMessages	= "SELECT UM.message_id,UM.message,UM.subject,UM.added_on, UH.university_ref_id, A.admin_full_name AS recipient
                FROM umail_message UM
                JOIN umail_header UH ON UH.header_id = UM.header_ref_id
                JOIN tbl_admin A ON A.admin_id = UH.recipient_id
                WHERE UM.sender_id = '$userId' AND UM.sender_type=1 $where ORDER BY UM.added_on DESC";

        $cmd = Yii::app()->db->createCommand($sqlMessages);
        $res = $cmd->queryAll();

        return count($res);
    }
  
}