<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticleCategoryTags is autogenerate by UniModel generator
 *
 * This is the model class for table "article_category_tags".
 *
 * The followings are the available columns in table 'article_category_tags':
 * @property string $article_category_tag_id
 * @property string $tag_name
 * @property integer $article_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Article $articleRef
 */
class BaseArticleCategoryTags extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArticleCategoryTags the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article_category_tags';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('article_ref_id, added_on', 'required'),
			array('article_ref_id', 'numerical', 'integerOnly'=>true),
			array('tag_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('article_category_tag_id, tag_name, article_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'articleRef' => array(self::BELONGS_TO, 'Article', 'article_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'article_category_tag_id' => 'Article Category Tag',
			'tag_name' => 'Tag Name',
			'article_ref_id' => 'Article Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('article_category_tag_id',$this->article_category_tag_id,true);
		$criteria->compare('tag_name',$this->tag_name,true);
		$criteria->compare('article_ref_id',$this->article_ref_id);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}