<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticleKnowldegeSequence is autogenerate by UniModel generator
 *
 * This is the model class for table "article_knowldege_sequence".
 *
 * The followings are the available columns in table 'article_knowldege_sequence':
 * @property integer $knowldege_sequence_id
 * @property integer $article_ref_id
 * @property integer $country_ref_id
 * @property integer $dept_ref_id
 * @property integer $sequence_no
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property Article $articleRef
 * @property LoginMaster $addedBy
 * @property TblCountryMaster $countryRef
 * @property LookupDepartment $deptRef
 */
class BaseArticleKnowldegeSequence extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArticleKnowldegeSequence the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article_knowldege_sequence';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('article_ref_id, added_on, added_by', 'required'),
			array('article_ref_id, country_ref_id, dept_ref_id, sequence_no', 'numerical', 'integerOnly'=>true),
			array('added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('knowldege_sequence_id, article_ref_id, country_ref_id, dept_ref_id, sequence_no, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'articleRef' => array(self::BELONGS_TO, 'Article', 'article_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'deptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'dept_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'knowldege_sequence_id' => 'Knowldege Sequence',
			'article_ref_id' => 'Article Ref',
			'country_ref_id' => 'Country Ref',
			'dept_ref_id' => 'Dept Ref',
			'sequence_no' => 'Sequence No',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('knowldege_sequence_id',$this->knowldege_sequence_id);
		$criteria->compare('article_ref_id',$this->article_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('dept_ref_id',$this->dept_ref_id);
		$criteria->compare('sequence_no',$this->sequence_no);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}