<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticleNewsMailTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "article_news_mail_tracker".
 *
 * The followings are the available columns in table 'article_news_mail_tracker':
 * @property integer $article_news_mail_tracker_id
 * @property integer $article_ref_id
 * @property string $user_ref_id
 * @property string $sent_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property Article $articleRef
 */
class BaseArticleNewsMailTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArticleNewsMailTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article_news_mail_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('article_ref_id, user_ref_id, sent_on', 'required'),
			array('article_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('article_news_mail_tracker_id, article_ref_id, user_ref_id, sent_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'articleRef' => array(self::BELONGS_TO, 'Article', 'article_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'article_news_mail_tracker_id' => 'Article News Mail Tracker',
			'article_ref_id' => 'Article Ref',
			'user_ref_id' => 'User Ref',
			'sent_on' => 'Sent On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('article_news_mail_tracker_id',$this->article_news_mail_tracker_id);
		$criteria->compare('article_ref_id',$this->article_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('sent_on',$this->sent_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}