<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticlePassoutYears is autogenerate by UniModel generator
 *
 * This is the model class for table "article_passout_years".
 *
 * The followings are the available columns in table 'article_passout_years':
 * @property integer $article_passout_year_id
 * @property integer $article_ref_id
 * @property integer $passout_year
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Article $articleRef
 */
class BaseArticlePassoutYears extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArticlePassoutYears the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article_passout_years';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('article_ref_id, added_on', 'required'),
			array('article_ref_id, passout_year', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('article_passout_year_id, article_ref_id, passout_year, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'articleRef' => array(self::BELONGS_TO, 'Article', 'article_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'article_passout_year_id' => 'Article Passout Year',
			'article_ref_id' => 'Article Ref',
			'passout_year' => 'Passout Year',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('article_passout_year_id',$this->article_passout_year_id);
		$criteria->compare('article_ref_id',$this->article_ref_id);
		$criteria->compare('passout_year',$this->passout_year);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}