<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticleTags is autogenerate by UniModel generator
 *
 * This is the model class for table "article_tags".
 *
 * The followings are the available columns in table 'article_tags':
 * @property integer $article_tag_id
 * @property integer $article_ref_id
 * @property integer $tag_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Tag $tagRef
 * @property Article $articleRef
 */
class BaseArticleTags extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArticleTags the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article_tags';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('article_ref_id, added_on', 'required'),
			array('article_ref_id, tag_ref_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('article_tag_id, article_ref_id, tag_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tagRef' => array(self::BELONGS_TO, 'Tag', 'tag_ref_id'),
			'articleRef' => array(self::BELONGS_TO, 'Article', 'article_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'article_tag_id' => 'Article Tag',
			'article_ref_id' => 'Article Ref',
			'tag_ref_id' => 'Tag Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('article_tag_id',$this->article_tag_id);
		$criteria->compare('article_ref_id',$this->article_ref_id);
		$criteria->compare('tag_ref_id',$this->tag_ref_id);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}