<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseAttachment is autogenerate by UniModel generator
 *
 * This is the model class for table "attachment".
 *
 * The followings are the available columns in table 'attachment':
 * @property string $attachement_id
 * @property integer $category_type_ref_id
 * @property integer $category_id
 * @property string $type_of_file
 * @property string $name_of_file
 * @property string $original_file_name
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property EmailAttachment[] $emailAttachments
 */
class BaseAttachment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Attachment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'attachment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('category_type_ref_id, category_id, type_of_file, name_of_file, added_on, added_by', 'required'),
			array('category_type_ref_id, category_id, added_by, modified_by, is_active', 'numerical', 'integerOnly'=>true),
			array('type_of_file', 'length', 'max'=>15),
			array('name_of_file, original_file_name', 'length', 'max'=>255),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('attachement_id, category_type_ref_id, category_id, type_of_file, name_of_file, original_file_name, added_on, added_by, modified_on, modified_by, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailAttachments' => array(self::HAS_MANY, 'EmailAttachment', 'attachment_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'attachement_id' => 'Attachement',
			'category_type_ref_id' => 'Category Type Ref',
			'category_id' => 'Category',
			'type_of_file' => 'Type Of File',
			'name_of_file' => 'Name Of File',
			'original_file_name' => 'Original File Name',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('attachement_id',$this->attachement_id,true);
		$criteria->compare('category_type_ref_id',$this->category_type_ref_id);
		$criteria->compare('category_id',$this->category_id);
		$criteria->compare('type_of_file',$this->type_of_file,true);
		$criteria->compare('name_of_file',$this->name_of_file,true);
		$criteria->compare('original_file_name',$this->original_file_name,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('is_active',$this->is_active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}