<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCourseApplicationDates is autogenerate by UniModel generator
 *
 * This is the model class for table "course_application_dates".
 *
 * The followings are the available columns in table 'course_application_dates':
 * @property string $course_application_dates_id
 * @property string $uni_course_ref_id
 * @property string $start_week
 * @property integer $start_day
 * @property integer $start_week_month
 * @property string $start_date
 * @property string $last_sale_week
 * @property integer $last_sale_week_day
 * @property integer $last_sale_week_month
 * @property string $last_sale_date
 * @property string $submission_last_week
 * @property integer $submission_last_week_day
 * @property integer $submission_last_week_month
 * @property string $submission_last_date
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 * @property TblUniCourses $uniCourseRef
 */
class BaseCourseApplicationDates extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CourseApplicationDates the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'course_application_dates';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_course_ref_id, start_date', 'required'),
			array('start_day, start_week_month, last_sale_week_day, last_sale_week_month, submission_last_week_day, submission_last_week_month, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('uni_course_ref_id', 'length', 'max'=>10),
			array('start_week, last_sale_week, submission_last_week', 'length', 'max'=>3),
			array('last_sale_date, submission_last_date, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('course_application_dates_id, uni_course_ref_id, start_week, start_day, start_week_month, start_date, last_sale_week, last_sale_week_day, last_sale_week_month, last_sale_date, submission_last_week, submission_last_week_day, submission_last_week_month, submission_last_date, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'uniCourseRef' => array(self::BELONGS_TO, 'TblUniCourses', 'uni_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'course_application_dates_id' => 'Course Application Dates',
			'uni_course_ref_id' => 'Uni Course Ref',
			'start_week' => 'Start Week',
			'start_day' => 'Start Day',
			'start_week_month' => 'Start Week Month',
			'start_date' => 'Start Date',
			'last_sale_week' => 'Last Sale Week',
			'last_sale_week_day' => 'Last Sale Week Day',
			'last_sale_week_month' => 'Last Sale Week Month',
			'last_sale_date' => 'Last Sale Date',
			'submission_last_week' => 'Submission Last Week',
			'submission_last_week_day' => 'Submission Last Week Day',
			'submission_last_week_month' => 'Submission Last Week Month',
			'submission_last_date' => 'Submission Last Date',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('course_application_dates_id',$this->course_application_dates_id,true);
		$criteria->compare('uni_course_ref_id',$this->uni_course_ref_id,true);
		$criteria->compare('start_week',$this->start_week,true);
		$criteria->compare('start_day',$this->start_day);
		$criteria->compare('start_week_month',$this->start_week_month);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('last_sale_week',$this->last_sale_week,true);
		$criteria->compare('last_sale_week_day',$this->last_sale_week_day);
		$criteria->compare('last_sale_week_month',$this->last_sale_week_month);
		$criteria->compare('last_sale_date',$this->last_sale_date,true);
		$criteria->compare('submission_last_week',$this->submission_last_week,true);
		$criteria->compare('submission_last_week_day',$this->submission_last_week_day);
		$criteria->compare('submission_last_week_month',$this->submission_last_week_month);
		$criteria->compare('submission_last_date',$this->submission_last_date,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}