<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiBannerCampaignLabels is autogenerate by UniModel generator
 *
 * This is the model class for table "di_banner_campaign_labels".
 *
 * The followings are the available columns in table 'di_banner_campaign_labels':
 * @property string $di_banner_campaign_labels_id
 * @property integer $banner_campaign_ref_id
 * @property string $heading
 * @property string $button_label
 * @property string $popup_heading
 * @property string $popup_subheading
 *
 * The followings are the available model relations:
 * @property DiBannerCampaign $bannerCampaignRef
 */
class BaseDiBannerCampaignLabels extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiBannerCampaignLabels the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_banner_campaign_labels';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('banner_campaign_ref_id', 'numerical', 'integerOnly'=>true),
			array('heading, popup_heading, popup_subheading', 'length', 'max'=>100),
			array('button_label', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_banner_campaign_labels_id, banner_campaign_ref_id, heading, button_label, popup_heading, popup_subheading', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'bannerCampaignRef' => array(self::BELONGS_TO, 'DiBannerCampaign', 'banner_campaign_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_banner_campaign_labels_id' => 'Di Banner Campaign Labels',
			'banner_campaign_ref_id' => 'Banner Campaign Ref',
			'heading' => 'Heading',
			'button_label' => 'Button Label',
			'popup_heading' => 'Popup Heading',
			'popup_subheading' => 'Popup Subheading',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_banner_campaign_labels_id',$this->di_banner_campaign_labels_id,true);
		$criteria->compare('banner_campaign_ref_id',$this->banner_campaign_ref_id);
		$criteria->compare('heading',$this->heading,true);
		$criteria->compare('button_label',$this->button_label,true);
		$criteria->compare('popup_heading',$this->popup_heading,true);
		$criteria->compare('popup_subheading',$this->popup_subheading,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}