<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiBannerRequestCallback is autogenerate by UniModel generator
 *
 * This is the model class for table "di_banner_request_callback".
 *
 * The followings are the available columns in table 'di_banner_request_callback':
 * @property string $di_banner_request_callback_id
 * @property integer $bs_ref_id
 * @property string $request_callback_ref_id
 *
 * The followings are the available model relations:
 * @property DiBannerCampaignAdData $bsRef
 * @property RequestCallback $requestCallbackRef
 */
class BaseDiBannerRequestCallback extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiBannerRequestCallback the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_banner_request_callback';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bs_ref_id, request_callback_ref_id', 'required'),
			array('bs_ref_id', 'numerical', 'integerOnly'=>true),
			array('request_callback_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_banner_request_callback_id, bs_ref_id, request_callback_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'bsRef' => array(self::BELONGS_TO, 'DiBannerCampaignAdData', 'bs_ref_id'),
			'requestCallbackRef' => array(self::BELONGS_TO, 'RequestCallback', 'request_callback_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_banner_request_callback_id' => 'Di Banner Request Callback',
			'bs_ref_id' => 'Bs Ref',
			'request_callback_ref_id' => 'Request Callback Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_banner_request_callback_id',$this->di_banner_request_callback_id,true);
		$criteria->compare('bs_ref_id',$this->bs_ref_id);
		$criteria->compare('request_callback_ref_id',$this->request_callback_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}