<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiInvoice is autogenerate by UniModel generator
 *
 * This is the model class for table "di_invoice".
 *
 * The followings are the available columns in table 'di_invoice':
 * @property string $di_invoice_id
 * @property string $invoice_code
 * @property integer $di_ref_id
 * @property string $invoice_start_date
 * @property string $invoice_end_date
 * @property string $opening_balance
 * @property string $closing_balance
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Di $diRef
 * @property DiInvoiceTransaction[] $diInvoiceTransactions
 */
class BaseDiInvoice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiInvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_invoice';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('invoice_code, di_ref_id, invoice_start_date, invoice_end_date, opening_balance, closing_balance, added_on', 'required'),
			array('di_ref_id', 'numerical', 'integerOnly'=>true),
			array('invoice_code', 'length', 'max'=>50),
			array('opening_balance, closing_balance', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_invoice_id, invoice_code, di_ref_id, invoice_start_date, invoice_end_date, opening_balance, closing_balance, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'diInvoiceTransactions' => array(self::HAS_MANY, 'DiInvoiceTransaction', 'di_invoice_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_invoice_id' => 'Di Invoice',
			'invoice_code' => 'Invoice Code',
			'di_ref_id' => 'Di Ref',
			'invoice_start_date' => 'Invoice Start Date',
			'invoice_end_date' => 'Invoice End Date',
			'opening_balance' => 'Opening Balance',
			'closing_balance' => 'Closing Balance',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_invoice_id',$this->di_invoice_id,true);
		$criteria->compare('invoice_code',$this->invoice_code,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('invoice_start_date',$this->invoice_start_date,true);
		$criteria->compare('invoice_end_date',$this->invoice_end_date,true);
		$criteria->compare('opening_balance',$this->opening_balance,true);
		$criteria->compare('closing_balance',$this->closing_balance,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}