<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiOnboardUniversityShortlist is autogenerate by UniModel generator
 *
 * This is the model class for table "di_onboard_university_shortlist".
 *
 * The followings are the available columns in table 'di_onboard_university_shortlist':
 * @property string $di_onboard_university_shortlist_id
 * @property string $added_on
 * @property integer $uni_ref_id
 * @property string $di_onboard_email_track_ref_id
 *
 * The followings are the available model relations:
 * @property DiOnboardEmailTrack $diOnboardEmailTrackRef
 * @property TblUniversityMaster $uniRef
 */
class BaseDiOnboardUniversityShortlist extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiOnboardUniversityShortlist the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_onboard_university_shortlist';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('di_onboard_email_track_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_onboard_university_shortlist_id, added_on, uni_ref_id, di_onboard_email_track_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diOnboardEmailTrackRef' => array(self::BELONGS_TO, 'DiOnboardEmailTrack', 'di_onboard_email_track_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_onboard_university_shortlist_id' => 'Di Onboard University Shortlist',
			'added_on' => 'Added On',
			'uni_ref_id' => 'Uni Ref',
			'di_onboard_email_track_ref_id' => 'Di Onboard Email Track Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_onboard_university_shortlist_id',$this->di_onboard_university_shortlist_id,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('di_onboard_email_track_ref_id',$this->di_onboard_email_track_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}