<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserEoi is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_eoi".
 *
 * The followings are the available columns in table 'di_user_eoi':
 * @property string $di_user_eoi_id
 * @property string $di_student_selection_ref_id
 * @property integer $main_department_ref_id
 * @property string $admission_chance
 * @property string $scholarship_ref_id
 * @property string $scholarship_name
 * @property string $scholarship_description
 * @property string $scholarship_amount
 * @property string $scholarship_chance
 * @property string $offer_message
 * @property string $eoi_status
 * @property string $marketing_message
 * @property string $unique_key
 * @property string $fee_waiver_desc
 * @property string $fee_waiver_url
 * @property string $fee_waiver_code
 * @property string $fee_waiver_amount
 * @property string $ucounsellor_name
 * @property string $ucounsellor_email
 * @property string $ucounsellor_phone
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property string $responded_on
 * @property string $is_superstar
 *
 * The followings are the available model relations:
 * @property DiUserCounsellorShortlist[] $diUserCounsellorShortlists
 * @property DiUserCriteriaShortlist[] $diUserCriteriaShortlists
 * @property LoginMaster $addedBy
 * @property LookupDepartment $mainDepartmentRef
 * @property LoginMaster $modifiedBy
 * @property Scholarship $scholarshipRef
 * @property DiStudentSelection $diStudentSelectionRef
 * @property DiUserEoiLog[] $diUserEoiLogs
 * @property DiUserEoiScholarship[] $diUserEoiScholarships
 */
class BaseDiUserEoi extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserEoi the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_eoi';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on, added_by', 'required'),
			array('main_department_ref_id', 'numerical', 'integerOnly'=>true),
			array('di_student_selection_ref_id, scholarship_ref_id, eoi_status, added_by, modified_by', 'length', 'max'=>10),
			array('admission_chance, scholarship_chance', 'length', 'max'=>14),
			array('scholarship_name, scholarship_amount, unique_key, ucounsellor_name', 'length', 'max'=>100),
			array('fee_waiver_url', 'length', 'max'=>255),
			array('fee_waiver_code, fee_waiver_amount, ucounsellor_email, ucounsellor_phone', 'length', 'max'=>50),
			array('is_superstar', 'length', 'max'=>1),
			array('scholarship_description, offer_message, marketing_message, fee_waiver_desc, modified_on, responded_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_eoi_id, di_student_selection_ref_id, main_department_ref_id, admission_chance, scholarship_ref_id, scholarship_name, scholarship_description, scholarship_amount, scholarship_chance, offer_message, eoi_status, marketing_message, unique_key, fee_waiver_desc, fee_waiver_url, fee_waiver_code, fee_waiver_amount, ucounsellor_name, ucounsellor_email, ucounsellor_phone, added_on, added_by, modified_on, modified_by, responded_on, is_superstar', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserCounsellorShortlists' => array(self::HAS_MANY, 'DiUserCounsellorShortlist', 'di_user_eoi_ref_id'),
			'diUserCriteriaShortlists' => array(self::HAS_MANY, 'DiUserCriteriaShortlist', 'di_user_eoi_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'mainDepartmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_department_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'diStudentSelectionRef' => array(self::BELONGS_TO, 'DiStudentSelection', 'di_student_selection_ref_id'),
			'diUserEoiLogs' => array(self::HAS_MANY, 'DiUserEoiLog', 'di_user_eoi_ref_id'),
			'diUserEoiScholarships' => array(self::HAS_MANY, 'DiUserEoiScholarship', 'di_user_eoi_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_eoi_id' => 'Di User Eoi',
			'di_student_selection_ref_id' => 'Di Student Selection Ref',
			'main_department_ref_id' => 'Main Department Ref',
			'admission_chance' => 'Admission Chance',
			'scholarship_ref_id' => 'Scholarship Ref',
			'scholarship_name' => 'Scholarship Name',
			'scholarship_description' => 'Scholarship Description',
			'scholarship_amount' => 'Scholarship Amount',
			'scholarship_chance' => 'Scholarship Chance',
			'offer_message' => 'Offer Message',
			'eoi_status' => 'Eoi Status',
			'marketing_message' => 'Marketing Message',
			'unique_key' => 'Unique Key',
			'fee_waiver_desc' => 'Fee Waiver Desc',
			'fee_waiver_url' => 'Fee Waiver Url',
			'fee_waiver_code' => 'Fee Waiver Code',
			'fee_waiver_amount' => 'Fee Waiver Amount',
			'ucounsellor_name' => 'Ucounsellor Name',
			'ucounsellor_email' => 'Ucounsellor Email',
			'ucounsellor_phone' => 'Ucounsellor Phone',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'responded_on' => 'Responded On',
			'is_superstar' => 'Is Superstar',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_eoi_id',$this->di_user_eoi_id,true);
		$criteria->compare('di_student_selection_ref_id',$this->di_student_selection_ref_id,true);
		$criteria->compare('main_department_ref_id',$this->main_department_ref_id);
		$criteria->compare('admission_chance',$this->admission_chance,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('scholarship_name',$this->scholarship_name,true);
		$criteria->compare('scholarship_description',$this->scholarship_description,true);
		$criteria->compare('scholarship_amount',$this->scholarship_amount,true);
		$criteria->compare('scholarship_chance',$this->scholarship_chance,true);
		$criteria->compare('offer_message',$this->offer_message,true);
		$criteria->compare('eoi_status',$this->eoi_status,true);
		$criteria->compare('marketing_message',$this->marketing_message,true);
		$criteria->compare('unique_key',$this->unique_key,true);
		$criteria->compare('fee_waiver_desc',$this->fee_waiver_desc,true);
		$criteria->compare('fee_waiver_url',$this->fee_waiver_url,true);
		$criteria->compare('fee_waiver_code',$this->fee_waiver_code,true);
		$criteria->compare('fee_waiver_amount',$this->fee_waiver_amount,true);
		$criteria->compare('ucounsellor_name',$this->ucounsellor_name,true);
		$criteria->compare('ucounsellor_email',$this->ucounsellor_email,true);
		$criteria->compare('ucounsellor_phone',$this->ucounsellor_phone,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('responded_on',$this->responded_on,true);
		$criteria->compare('is_superstar',$this->is_superstar,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}