<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailAttachment is autogenerate by UniModel generator
 *
 * This is the model class for table "email_attachment".
 *
 * The followings are the available columns in table 'email_attachment':
 * @property string $email_attachment_id
 * @property string $email_message_ref_id
 * @property string $file_name
 * @property string $file_path
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property DiUserEoiLogAttachment[] $diUserEoiLogAttachments
 * @property EmailMessage $emailMessageRef
 */
class BaseEmailAttachment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailAttachment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_attachment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_message_ref_id, file_name, file_path', 'required'),
			array('added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('email_message_ref_id', 'length', 'max'=>10),
			array('file_name', 'length', 'max'=>100),
			array('file_path', 'length', 'max'=>255),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_attachment_id, email_message_ref_id, file_name, file_path, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserEoiLogAttachments' => array(self::HAS_MANY, 'DiUserEoiLogAttachment', 'email_attachment_ref_id'),
			'emailMessageRef' => array(self::BELONGS_TO, 'EmailMessage', 'email_message_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_attachment_id' => 'Email Attachment',
			'email_message_ref_id' => 'Email Message Ref',
			'file_name' => 'File Name',
			'file_path' => 'File Path',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_attachment_id',$this->email_attachment_id,true);
		$criteria->compare('email_message_ref_id',$this->email_message_ref_id,true);
		$criteria->compare('file_name',$this->file_name,true);
		$criteria->compare('file_path',$this->file_path,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}