<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailType is autogenerate by UniModel generator
 *
 * This is the model class for table "email_type".
 *
 * The followings are the available columns in table 'email_type':
 * @property string $email_type_id
 * @property string $name
 * @property string $unique_key
 * @property string $from_name
 * @property string $from_email
 * @property integer $is_response_changable
 * @property string $response_type
 * @property string $reply_to_email
 * @property string $category
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property EmailMessage[] $emailMessages
 * @property EmailTypeResponse[] $emailTypeResponses
 */
class BaseEmailType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'email_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('is_response_changable, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('name, from_name, from_email, reply_to_email', 'length', 'max'=>100),
			array('unique_key', 'length', 'max'=>45),
			array('response_type', 'length', 'max'=>5),
			array('category', 'length', 'max'=>10),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('email_type_id, name, unique_key, from_name, from_email, is_response_changable, response_type, reply_to_email, category, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailMessages' => array(self::HAS_MANY, 'EmailMessage', 'email_type_ref_id'),
			'emailTypeResponses' => array(self::HAS_MANY, 'EmailTypeResponse', 'email_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'email_type_id' => 'Email Type',
			'name' => 'Name',
			'unique_key' => 'Unique Key',
			'from_name' => 'From Name',
			'from_email' => 'From Email',
			'is_response_changable' => 'Is Response Changable',
			'response_type' => 'Response Type',
			'reply_to_email' => 'Reply To Email',
			'category' => 'Category',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('email_type_id',$this->email_type_id,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('unique_key',$this->unique_key,true);
		$criteria->compare('from_name',$this->from_name,true);
		$criteria->compare('from_email',$this->from_email,true);
		$criteria->compare('is_response_changable',$this->is_response_changable);
		$criteria->compare('response_type',$this->response_type,true);
		$criteria->compare('reply_to_email',$this->reply_to_email,true);
		$criteria->compare('category',$this->category,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}