<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailerCountryDepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "emailer_country_department".
 *
 * The followings are the available columns in table 'emailer_country_department':
 * @property integer $emailer_country_department_id
 * @property string $user_ref_id
 * @property integer $country_ref_id
 * @property integer $department_ref_id
 * @property string $sent_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property TblCountryMaster $countryRef
 * @property LookupDepartment $departmentRef
 */
class BaseEmailerCountryDepartment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailerCountryDepartment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'emailer_country_department';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sent_on', 'required'),
			array('country_ref_id, department_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>11),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('emailer_country_department_id, user_ref_id, country_ref_id, department_ref_id, sent_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'emailer_country_department_id' => 'Emailer Country Department',
			'user_ref_id' => 'User Ref',
			'country_ref_id' => 'Country Ref',
			'department_ref_id' => 'Department Ref',
			'sent_on' => 'Sent On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('emailer_country_department_id',$this->emailer_country_department_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('sent_on',$this->sent_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}