<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailerMilestoneTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "emailer_milestone_tracker".
 *
 * The followings are the available columns in table 'emailer_milestone_tracker':
 * @property string $emailer_milestone_tracker_id
 * @property string $login_ref_id
 * @property integer $emailer_cron_milestone_ref_id
 * @property string $sent_on
 * @property string $opened_on
 *
 * The followings are the available model relations:
 * @property EmailerCronMilestone $emailerCronMilestoneRef
 * @property LoginMaster $loginRef
 */
class BaseEmailerMilestoneTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailerMilestoneTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'emailer_milestone_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('login_ref_id, sent_on', 'required'),
			array('emailer_cron_milestone_ref_id', 'numerical', 'integerOnly'=>true),
			array('login_ref_id', 'length', 'max'=>10),
			array('opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('emailer_milestone_tracker_id, login_ref_id, emailer_cron_milestone_ref_id, sent_on, opened_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailerCronMilestoneRef' => array(self::BELONGS_TO, 'EmailerCronMilestone', 'emailer_cron_milestone_ref_id'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'emailer_milestone_tracker_id' => 'Emailer Milestone Tracker',
			'login_ref_id' => 'Login Ref',
			'emailer_cron_milestone_ref_id' => 'Emailer Cron Milestone Ref',
			'sent_on' => 'Sent On',
			'opened_on' => 'Opened On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('emailer_milestone_tracker_id',$this->emailer_milestone_tracker_id,true);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('emailer_cron_milestone_ref_id',$this->emailer_cron_milestone_ref_id);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('opened_on',$this->opened_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}