<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEngagementEmails is autogenerate by UniModel generator
 *
 * This is the model class for table "engagement_emails".
 *
 * The followings are the available columns in table 'engagement_emails':
 * @property string $engagement_emails_id
 * @property string $user_ref_id
 * @property integer $day
 * @property string $email_type
 * @property string $sent_on
 * @property string $opened_on
 *
 * The followings are the available model relations:
 * @property ArticleKnowledgeMailTracker[] $articleKnowledgeMailTrackers
 * @property TblUserMaster $userRef
 * @property EngagementEmailsEvents[] $engagementEmailsEvents
 * @property EngagementEmailsTests[] $engagementEmailsTests
 * @property EngagementEmailsUniversities[] $engagementEmailsUniversities
 */
class BaseEngagementEmails extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EngagementEmails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'engagement_emails';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, day, sent_on', 'required'),
			array('day', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('email_type', 'length', 'max'=>150),
			array('opened_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('engagement_emails_id, user_ref_id, day, email_type, sent_on, opened_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'articleKnowledgeMailTrackers' => array(self::HAS_MANY, 'ArticleKnowledgeMailTracker', 'engagement_emails_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'engagementEmailsEvents' => array(self::HAS_MANY, 'EngagementEmailsEvents', 'engagement_emails_ref_id'),
			'engagementEmailsTests' => array(self::HAS_MANY, 'EngagementEmailsTests', 'engagement_emails_ref_id'),
			'engagementEmailsUniversities' => array(self::HAS_MANY, 'EngagementEmailsUniversities', 'engagement_emails_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'engagement_emails_id' => 'Engagement Emails',
			'user_ref_id' => 'User Ref',
			'day' => 'Day',
			'email_type' => 'Email Type',
			'sent_on' => 'Sent On',
			'opened_on' => 'Opened On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('engagement_emails_id',$this->engagement_emails_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('day',$this->day);
		$criteria->compare('email_type',$this->email_type,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('opened_on',$this->opened_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}