<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamRankingDepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_ranking_department".
 *
 * The followings are the available columns in table 'entrance_exam_ranking_department':
 * @property integer $entrance_exam_ranking_department_id
 * @property string $entrance_exam_ranking_ref_id
 * @property integer $main_department_ref_id
 * @property integer $rank
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property EntranceExamRanking $entranceExamRankingRef
 * @property LookupDepartment $mainDepartmentRef
 */
class BaseEntranceExamRankingDepartment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamRankingDepartment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_ranking_department';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('main_department_ref_id, rank', 'numerical', 'integerOnly'=>true),
			array('entrance_exam_ranking_ref_id, added_by', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_ranking_department_id, entrance_exam_ranking_ref_id, main_department_ref_id, rank, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'entranceExamRankingRef' => array(self::BELONGS_TO, 'EntranceExamRanking', 'entrance_exam_ranking_ref_id'),
			'mainDepartmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_department_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_ranking_department_id' => 'Entrance Exam Ranking Department',
			'entrance_exam_ranking_ref_id' => 'Entrance Exam Ranking Ref',
			'main_department_ref_id' => 'Main Department Ref',
			'rank' => 'Rank',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_ranking_department_id',$this->entrance_exam_ranking_department_id);
		$criteria->compare('entrance_exam_ranking_ref_id',$this->entrance_exam_ranking_ref_id,true);
		$criteria->compare('main_department_ref_id',$this->main_department_ref_id);
		$criteria->compare('rank',$this->rank);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}