<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEoiApplication is autogenerate by UniModel generator
 *
 * This is the model class for table "eoi_application".
 *
 * The followings are the available columns in table 'eoi_application':
 * @property string $eoi_application_id
 * @property string $di_user_eoi_log_ref_id
 * @property string $application_date
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property DiUserEoiLog $diUserEoiLogRef
 */
class BaseEoiApplication extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EoiApplication the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'eoi_application';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_user_eoi_log_ref_id', 'required'),
			array('di_user_eoi_log_ref_id', 'length', 'max'=>10),
			array('application_date, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('eoi_application_id, di_user_eoi_log_ref_id, application_date, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserEoiLogRef' => array(self::BELONGS_TO, 'DiUserEoiLog', 'di_user_eoi_log_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'eoi_application_id' => 'Eoi Application',
			'di_user_eoi_log_ref_id' => 'Di User Eoi Log Ref',
			'application_date' => 'Application Date',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('eoi_application_id',$this->eoi_application_id,true);
		$criteria->compare('di_user_eoi_log_ref_id',$this->di_user_eoi_log_ref_id,true);
		$criteria->compare('application_date',$this->application_date,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}