<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseErrorReportScholarship is autogenerate by UniModel generator
 *
 * This is the model class for table "error_report_scholarship".
 *
 * The followings are the available columns in table 'error_report_scholarship':
 * @property integer $error_report_scholarship_id
 * @property string $scholarship_ref_id
 * @property string $about_scholarship
 * @property string $scholarship_details
 * @property string $requirements
 * @property string $application
 * @property string $other_info
 * @property string $email_id
 * @property string $suggestion
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property Scholarship $scholarshipRef
 * @property LoginMaster $addedBy
 */
class BaseErrorReportScholarship extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ErrorReportScholarship the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'error_report_scholarship';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id, added_on', 'required'),
			array('scholarship_ref_id, added_by', 'length', 'max'=>10),
			array('about_scholarship, scholarship_details, requirements, application, other_info', 'length', 'max'=>1),
			array('email_id', 'length', 'max'=>100),
			array('suggestion', 'length', 'max'=>1000),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('error_report_scholarship_id, scholarship_ref_id, about_scholarship, scholarship_details, requirements, application, other_info, email_id, suggestion, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'error_report_scholarship_id' => 'Error Report Scholarship',
			'scholarship_ref_id' => 'Scholarship Ref',
			'about_scholarship' => 'About Scholarship',
			'scholarship_details' => 'Scholarship Details',
			'requirements' => 'Requirements',
			'application' => 'Application',
			'other_info' => 'Other Info',
			'email_id' => 'Email',
			'suggestion' => 'Suggestion',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('error_report_scholarship_id',$this->error_report_scholarship_id);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('about_scholarship',$this->about_scholarship,true);
		$criteria->compare('scholarship_details',$this->scholarship_details,true);
		$criteria->compare('requirements',$this->requirements,true);
		$criteria->compare('application',$this->application,true);
		$criteria->compare('other_info',$this->other_info,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('suggestion',$this->suggestion,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}